<?php
/**
* @version	$Id: gift_certificates_config.php 14717 2011-11-01 10:39:34Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'gc',
		'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'GiftCertificateEventHandler', 'file' => 'gift_certificates_eh.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'GiftCertificateTagProcessor', 'file' => 'gift_certificates_tp.php', 'build_event' => 'OnBuild'),
		'AutoLoad' => true,

		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'PerPage',
			4 => 'event',
			5 => 'mode',
		),

		'IDField' => 'GiftCertificateId',
		'StatusField' => Array('Status'),
		'TitleField' => 'Recipient',
		'TableName' => TABLE_PREFIX.'GiftCertificates',

		'TitlePresets' => Array (
			'default' => Array (
				'new_status_labels' => Array ('gc' => '!la_title_AddingGiftCertificate!'),
				'edit_status_labels' => Array ('gc' => '!la_title_EditingGiftCertificate!'),
				'new_titlefield' => Array ('gc' => '!la_title_NewGiftCertificate!'),
			),

			'gift_certificates_list' => Array ('prefixes' => Array ('gc_List'), 'format' => "!la_title_GiftCertificates!",),
			'gift_certificates_edit' => Array ('prefixes' => Array ('gc'), 'format' => "#gc_status# '#gc_titlefield#' - !la_title_General!",),
		),

		'PermSection' => Array ('main' => 'in-commerce:gift-certificates'),

		'Sections' => Array (
			'in-commerce:gift-certificates' => Array (
				'parent'		=>	'in-commerce:discounts_folder',
				'icon'			=>	'discounts_coupons',
				'label'			=>	'la_tab_GiftCertificates',
				'url'			=>	Array('t' => 'in-commerce/discounts/gift_certificate_list', 'pass' => 'm'),
				'permissions'	=>	Array('view', 'add', 'edit', 'delete', 'advanced:approve', 'advanced:decline'),
				'priority'		=>	3.3, // <parent_priority>.<own_priority>, because this section replaces parent in tree
				'type'			=>	stTAB,
			),
		),

		'ListSQLs' => Array ('' => 'SELECT %1$s.* %2$s FROM %1$s',),
		'ItemSQLs' => Array ('' => 'SELECT * FROM %1$s',),

		'ListSortings' => Array (
			'' => Array(
				'Sorting' => Array('Recipient' => 'asc'),
			)
		),

		'Fields' => Array (
		    'GiftCertificateId' => Array('type' => 'int', 'not_null' => 1, 'default' => 0),
		    'OrderId' => Array ('type' => 'int', 'default' => 0),
		    'Status' => Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array ( 1 => 'la_Enabled', 2 => 'la_Used', 0 => 'la_Disabled' ), 'use_phrases' => 1, 'not_null' => 1, 'default' => 2 ),
		    'SendVia' => Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array ( 0 => 'la_opt_Email', 1 => 'la_opt_PostalMail'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 0 ),
		    'Purchaser' => Array('type'=>'string','required'=>1,'default'=>null, 'max_len'=>255),
		    'Recipient' => Array('type'=>'string','required'=>1,'default'=>null, 'max_len'=>255),
	        'RecipientEmail' => Array('type' => 'string', 'formatter'=>'kFormatter', 'regexp'=>'/^(' . REGEX_EMAIL_USER . '@' . REGEX_EMAIL_DOMAIN . ')$/i', 'sample_value' => 'email@domain.com', 'not_null' => '1', 'required'=>1, 'default' => '', 'error_msgs' => Array('invalid_format'=>'!la_invalid_email!') ),
		    'RecipientFirstname' => Array('type'=>'string','required'=>1,'default'=>null, 'max_len'=>255),
		    'RecipientLastname' => Array('type'=>'string','required'=>1,'default'=>null, 'max_len'=>255),
		    'RecipientAddress1' => Array('type'=>'string','required'=>1,'default'=>null, 'max_len'=>255),
		    'RecipientAddress2' => Array('type'=>'string', 'default'=>null, 'max_len'=>255),
		    'RecipientCity' => Array('type'=>'string','required'=>1,'default'=>null, 'max_len'=>255),
		    'RecipientState' => Array('type'=>'string','required'=>1,'default'=>null, 'max_len'=>255),
		    'RecipientZipcode' => Array('type'=>'string','required'=>1,'default'=>null, 'max_len'=>255),
			'RecipientCountry' => Array(
				'type' => 'string',
				'formatter' => 'kOptionsFormatter',
            	'options_sql' => '	SELECT IF(l%2$s_Name = "", l%3$s_Name, l%2$s_Name) AS Name, IsoCode
									FROM '.TABLE_PREFIX.'CountryStates
									WHERE Type = ' . DESTINATION_TYPE_COUNTRY . '
									ORDER BY Name',
				'option_key_field' => 'IsoCode', 'option_title_field' => 'Name',
				'not_null' => 1, 'required' => 1, 'default' => 'USA'
			),

		    'RecipientPhone' => Array('type'=>'string','default'=>null, 'max_len'=>255),
		    'Message' => Array('type' => 'string', 'formatter' => 'kFormatter', 'using_fck' => 1, 'default' => null),
		    'Code' => Array('type'=>'string','required'=>1,'default'=>null, 'max_len'=>255, 'unique'=>Array('Code')),
		    'AddDate' => Array('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => '#NOW#',),
		    'Expiration' => Array('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => null,),
		    'Amount' => Array('type'=>'double', 'default' => null, 'required' => 1, 'min_value_exc' => 0),
		    'Debit' => Array('type'=>'double', 'default' => null),
		),

		'Grids' => Array (
			'Default' => Array (
				'Icons' => Array(
					'default' => 'icon16_item.png',
					0 => 'icon16_disabled.png',
					1 => 'icon16_item.png',
					2 => 'icon16_pending.png',
					'module' => 'core',
				),
				'Fields' => Array (
					'GiftCertificateId'	=> Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
					'Code' => Array ('filter_block' => 'grid_like_filter', 'width' => 100, ),
					'Status' => Array ('filter_block' => 'grid_options_filter', 'width' => 100, ),
					'Debit' => Array ('title' => 'column:la_fld_RemainingAmount', 'filter_block' => 'grid_range_filter', 'width' => 160, ),
					'Amount' => Array ('filter_block' => 'grid_range_filter', 'width' => 100, ),
					'Expiration' => Array ('filter_block' => 'grid_date_range_filter', 'width' => 145, ),
				),
			),
		),
	);