<?php
/**
* @version	$Id: gw_tag_processor.php 14257 2011-03-16 21:41:19Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class GatewayTagProcessor extends kDBTagProcessor {

	/**
	 * Payment gateway config values for current payment type
	 *
	 * @var Array
	 * @access private
	 */
	var $ConfigValues=Array();

	/**
	 * Payment type id for current gateway values
	 *
	 * @var int
	 * @access private
	 */
	var $PaymentTypeID=0;


	function initGWConfigValues()
	{
		$payment_type_id = $this->Application->GetVar('pt_id');
		$GWConfigValue =& $this->Application->recallObject('gwfv');

		$sql = 'SELECT Value, GWConfigFieldId FROM '.$GWConfigValue->TableName.' WHERE PaymentTypeId = '.$payment_type_id;
		$this->ConfigValues = $this->Conn->GetCol($sql,'GWConfigFieldId');
	}

	function gwConfigValue($params)
	{
		$object =& $this->Application->recallObject($this->getPrefixSpecial(), $this->Prefix, $params);
		$id = $object->GetID();

		$value = isset($this->ConfigValues[$id]) ? $this->ConfigValues[$id] : '';
		if (!array_key_exists('no_special', $params) || !$params['no_special']) {
			$value = htmlspecialchars($value);
		}

		if ( getArrayValue($params,'checked') ) {
			$value = ($value == 1) ? 'checked' : '';
		}

		return $value;
	}

	function PrintList($params)
	{
		$list =& $this->Application->recallObject( $this->getPrefixSpecial(), $this->Prefix.'_List', $params);
		$id_field = $this->Application->getUnitOption($this->Prefix,'IDField');

		$list->Query();
		$list->GoFirst();

		$block_params=$this->prepareTagParams($params);
		$block_params['name']=$params['block'];
		$block_params['pass_params']='true';

		$payment_type_object =& $this->Application->recallObject('pt');

		$o = '';

		while (!$list->EOL())
		{
			$this->Application->SetVar( $this->getPrefixSpecial().'_id', $list->GetDBField($id_field) );

			$display_style = $payment_type_object->GetDBField('GatewayId') == $list->GetDBField('GatewayId') ? 'table-row' : 'none';
			$block_params['input_block'] = $params['input_block_prefix'].$list->GetDBField('ElementType');
			$block_params['gateway_id'] = $list->GetDBField('GatewayId');
			$block_params['display'] = $display_style;

			$o .= $this->Application->ParseBlock($block_params, 1);

			$list->GoNext();
		}

		return $o;
	}

	function PredefinedOptions($params)
	{
		$object =& $this->Application->recallObject($this->getPrefixSpecial(),$this->Prefix, $params);

		$value = $this->gwConfigValue($params);

		$options = explode(',', $object->GetDBField('ValueList') );

		$block_params = $this->prepareTagParams($params);

		$block_params['name'] = $this->SelectParam($params, 'render_as,block');
		$block_params['pass_params'] = 'true';

		$o = '';
		foreach ($options as $key_val)
		{
			list($key,$val) = explode('=', $key_val);
			$block_params['key'] = $key;
			$block_params['option'] = $val;
			$block_params['selected'] = ( $key == $value ? ' '.$params['selected'] : '');
			$block_params['PrefixSpecial'] = $this->getPrefixSpecial();
			$o .= $this->Application->ParseBlock($block_params, 1);
		}

		return $o;
	}
}