<?php
/**
* @version	$Id: manufacturers_config.php 14158 2011-01-11 10:37:05Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config =	Array (
					'Prefix'			=>	'manuf',
					'ItemClass'			=>	Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
					'ListClass'			=>	Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
					'EventHandlerClass'	=>	Array ('class' => 'ManufacturersEventHandler', 'file' => 'manufacturers_event_handler.php', 'build_event' => 'OnBuild'),
					'TagProcessorClass' =>	Array ('class' => 'ManufacturersTagProcessor', 'file' => 'manufacturers_tag_processor.php', 'build_event' => 'OnBuild'),
					'AutoLoad'			=>	true,

					'QueryString'		=>	Array (
												1 => 'id',
												2 => 'Page',
												3 => 'PerPage',
												4 => 'event',
												5 => 'mode',
											),
					'IDField'			=>	'ManufacturerId',
					'StatusField'		=>	Array (),
					'TableName'			=>	TABLE_PREFIX.'Manufacturers',

					'TitlePresets' => Array (
						'default' => Array (
							'new_status_labels' => Array ('manuf' => '!la_title_AddingManufacturer!'),
							'edit_status_labels' => Array ('manuf' => '!la_title_EditingManufacturer!'),																		
						),
						'manuf_list' => Array (
							'prefixes' => Array ('manuf_List'), 'format' => "!la_title_Manufacturers!",
						),
						'manuf_edit' => Array (
							'prefixes' => Array ('manuf'),
							'new_titlefield' => Array ('manuf' => '!la_title_NewManufacturer!'),
							'format' => "#manuf_status# '#manuf_titlefield#' - !la_title_General!",
						),
					),

					'PermSection'		=>	Array ('main' => 'in-commerce:manufacturers'),

					'Sections'			=>	Array (
						'in-commerce:manufacturers'	=>	Array (
							'parent'		=>	'in-commerce',
							'icon'			=>	'manufacturers',
							'label'			=>	'la_tab_Manufacturers',
							'url'			=>	Array ('t' => 'in-commerce/manufacturers/manufacturers_list', 'pass' => 'm'),
							'permissions'	=>	Array ('view', 'add', 'edit', 'delete'),
							'priority'		=>	4,
							'type'			=>	stTREE,
						),
					),

					'TitleField'		=>	'Name',		// field, used in bluebar when editing existing item


					'ListSQLs'			=>	Array (	'' => 'SELECT * FROM %s',
													), // key - special, value - list select sql
					'ItemSQLs'			=>	Array ('' => 'SELECT * FROM %s',
																		),
					'ListSortings'	=> 	Array (
																'' => Array (
																	'Sorting' => Array ('Name' => 'asc'),
																)
															),
					'Fields' => Array (
			            'ManufacturerId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0,),
			            'Name' => Array ('type' => 'string', 'not_null' => '1', 'default' => '', 'required' =>true, 'max_len' =>255),
			            'Description' => Array ('type' => 'string', 'formatter' => 'kFormatter', 'using_fck' => 1, 'default' => NULL),
			            'URL' => Array ('type' => 'string', 'not_null' => '1', 'default' => '', 'max_len' =>255),
			            'Logo' => Array (
			            	'type' => 'string',
			            	'formatter' => 'kPictureFormatter',
			            	'max_size' => MAX_UPLOAD_SIZE, 'upload_dir' => IMAGES_PATH.'manufacturers/',
			            	'file_types' => '*.jpg;*.gif;*.png', 'files_description' => '!la_hint_ImageFiles!',
			            	'multiple' => false, 'thumb_format' => 'resize:100x100',
			            	'max_len' => 255, 'not_null' => 1, 'default' => ''
			            ),
			            'IsPopular' => Array (
			            	'type' => 'int',
			            	'formatter' => 'kOptionsFormatter',
			            	'options' => Array (0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1,
			            	'not_null' => 1, 'default' => 0,
			            ),
			            'Email' => Array ('type' => 'string', 'formatter' => 'kFormatter', 'regexp' => '/^(' . REGEX_EMAIL_USER . '@' . REGEX_EMAIL_DOMAIN . ')$/i', 'sample_value' => 'email@domain.com', 'default' => null, 'error_msgs' => Array ('invalid_format' => '!la_invalid_email!') ),
				        'Phone' => Array ('type' => 'string', 'default' => null),
				        'Fax' => Array ('type' => 'string', 'default' => null),
				        'Address1' => Array ('type' => 'string', 'default' => null),
				        'Address2' => Array ('type' => 'string', 'default' => null),
				        'City' => Array ('type' => 'string', 'default' => null),
				        'State' => Array ('type' => 'string', 'formatter' => 'kOptionsFormatter', 'options' => Array (), 'option_key_field' => 'DestAbbr', 'option_title_field' => 'Translation', 'default' => null),
				        'Zip' => Array ('type' => 'string', 'default' => null),
						'Country' => Array (
				        	'type' => 'string',
				        	'formatter' => 'kOptionsFormatter',
				            'options_sql' => '	SELECT IF(l%2$s_Name = "", l%3$s_Name, l%2$s_Name) AS Name, IsoCode
												FROM '.TABLE_PREFIX.'CountryStates
												WHERE Type = ' . DESTINATION_TYPE_COUNTRY . '
												ORDER BY Name',
			            	'option_key_field' => 'IsoCode', 'option_title_field' => 'Name', 'default' => null
			           	),
					),

					'Grids' => Array (
						'Default' => Array (
							'Icons' => Array (
								'default' => 'icon16_item.png',
								0 => 'icon16_disabled.png',
								1 => 'icon16_item.png',
								'module' => 'core',
							),
							'Fields' => Array (
								'ManufacturerId' => Array ('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
								'Name' => Array ('title' => 'la_col_ManufacturerName', 'filter_block' => 'grid_like_filter', 'width' => 200, ),
								'IsPopular' => Array ('title' => 'la_col_IsPopular', 'filter_block' => 'grid_options_filter', 'width' => 100, ),
								'URL' => Array ('title' => 'la_col_URL', 'filter_block' => 'grid_like_filter', 'width' => 250, ),
							),
						),
					),

					'ConfigMapping' => Array (
						'PerPage' => 'Comm_Perpage_Manufacturers',
						'ShortListPerPage' => 'Comm_Perpage_Manufacturers_Short',
					),
	);