<?php
/**
* @version	$Id: shipping_costs_event_handler.php 13602 2010-05-23 09:52:40Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class ShippingCostsEventHandler extends kDBEventHandler {

	/**
	 * Allows to override standart permission mapping
	 *
	 */
	function mapPermissions()
	{
		parent::mapPermissions();
		$permissions = Array(
								'OnPropagate'	=>	Array('subitem' => 'add|edit'),
								'OnClearAll'	=>	Array('subitem' => 'add|edit'),
								'OnSaveCreated'	=>	Array('subitem' => 'add|edit'),
						);
		$this->permMapping = array_merge($this->permMapping, $permissions);
	}

	/**
	 * Enter description here...
	 *
	 * @param kEvent $event
	 */
	function OnCreate(&$event)
	{
		$object =& $event->getObject( Array('skip_autoload' => true) );
		$zones_object =& $this->Application->recallObject('z');

		$sql = 'SELECT ZoneID FROM '.$zones_object->TableName.' WHERE ShippingTypeID='.$this->Application->GetVar('s_id');
		$res = $this->Conn->GetCol($sql);
		$sql = 'DELETE FROM '.$object->TableName.' WHERE ZoneID IN ('.implode(',', $res).')';
		$this->Conn->Query($sql);

		$items_info = $this->Application->GetVar( $event->getPrefixSpecial(true) );
		if($items_info)
		{
			foreach($items_info as $id => $field_values)
			{
				$object->SetFieldsFromHash($field_values);
				$this->customProcessing($event,'before');

				if( $object->Create() ) {
					$this->customProcessing($event,'after');
					$event->status = erSUCCESS;
				}
				else {
					$event->status = erFAIL;
					$event->redirect = false;
					$this->Application->SetVar($event->Prefix_Special.'_SaveEvent','OnCreate');
					$object->setID(0);
				}
			}
		}
	}

	/**
	 * Enter description here...
	 *
	 * @param kEvent $event
	 */
	function OnPropagate(&$event)
	{
	//	$this->OnCreate(&$event);

		$object =& $event->getObject();

		$shipping_object =& $this->Application->recallObject('s');

		if( $this->Application->GetVar('br_propagate_id') )
		{
			$propagate_id = $this->Application->GetVar('br_propagate_id');
			$idfield = 'BracketId';
		}
		else
		{
			$propagate_id = $this->Application->GetVar('z_propagate_id');
			$idfield = 'ZoneID';
		}

		$cost_type = $shipping_object->GetDBField('CostType');
		switch($cost_type)
		{
			case 1:
				$affected_fields = Array(0 => 'Flat');
				break;
			case 2:
				$affected_fields = Array(0 => 'PerUnit');
				break;
			default:
				$affected_fields = Array(0 => 'PerUnit', 1 => 'Flat');
				break;
		}

		$sql = 'SELECT ShippingCostId,'.implode(',', $affected_fields).'
				FROM '.$object->TableName.'
				WHERE '.$idfield.'='.$propagate_id;
		$res = $this->Conn->Query($sql);

		if(is_array($res))
		{
			$res = array_reverse($res);
			foreach($affected_fields as $field)
			{
				$first_elem = getArrayValue($res, 0);
				if( (double)$first_elem[$field] )
				{
					$iterating_value = $first_elem[$field];
					$second_elem = getArrayValue($res, 1);
					if( is_array($second_elem) && (double)$second_elem[$field] )
					{
						$increment = $second_elem[$field] - $first_elem[$field];
					}
					else
					{
						$increment = 0;
					}

					foreach($res as $record)
					{
						$object->Load($record['ShippingCostId']);

						$new_value = ($iterating_value >= 0) ? $iterating_value : null;
						$object->SetDBField($field, $new_value);

						$object->Update();
						$iterating_value += $increment;
					}
				}
			}
		}

	/*	$shipping_event = new kEvent();
		$shipping_event->Init('s');
		$shipping_event->Name = 'OnPreSave';
		$shipping_event->status = erFATAL;
		$this->Application->HandleEvent(&$shipping_event);*/
	}

	/**
	 * Enter description here...
	 *
	 * @param kEvent $event
	 */
	function OnClearAll(&$event)
	{
		$object =& $event->getObject( Array('skip_autoload' => true) );
		$zones_object =& $this->Application->recallObject('z');

		$sql = 'SELECT ZoneID FROM '.$zones_object->TableName.' WHERE ShippingTypeID='.$this->Application->GetVar('s_id');
		$res = $this->Conn->GetCol($sql);
		$sql = 'DELETE FROM '.$object->TableName.' WHERE ZoneID IN ('.implode(',', $res).')';
		$this->Conn->Query($sql);

		$event->redirect_params = Array('opener' => 's', 'pass_events' => false);
		$event->status=erSUCCESS;
	}

	function customProcessing(&$event, $type)
	{
		if( $type == 'before' && $this->Application->GetVar('sc') )
		{
			$shipping_obj =& $this->Application->recallObject('s');
			$cost =& $event->getObject();
			$zero_if_empty = $shipping_obj->GetDBField('ZeroIfEmpty');

			if($cost->GetDBField('Flat') == '')
			{
				$flat = $zero_if_empty ? 0 : null;
				$cost->SetDBField('Flat', $flat);
			}
			if($cost->GetDBField('PerUnit') == '')
			{
				$per_unit = $zero_if_empty ? 0 : null;
				$cost->SetDBField('PerUnit', $per_unit);
			}
		}
	}

	function OnSaveCreated(&$event)
	{
		$event->CallSubEvent('OnCreate');
		$event->redirect = false;
		$event->redirect_params = Array('opener'=>'s','pass'=>'all');
	}

	function OnAfterCopyToTemp(&$event)
	{
		$id = $event->getEventParam('id');
		$object =& $this->Application->recallObject($event->Prefix.'.-item', $event->Prefix);
		$object->SwitchToTemp();
		$object->Load($id);
		$shipping_obj =& $this->Application->recallObject('s');
		$lang_object =& $this->Application->recallObject('lang.current');
		// by weight and US/UK system - we need to store recalculated price per Kg cause shipping calculation is done per Kg!
		if ($shipping_obj->GetDBField('Type') == 1 && $lang_object->GetDBField('UnitSystem') == 2) {
			$object->SetDBField('PerUnit', $object->GetDBField('PerUnit') * POUND_TO_KG);
			$object->Update(null, true);
		}
	}

	function OnBeforeCopyToLive(&$event)
	{
		$id = $event->getEventParam('id');
		$object =& $this->Application->recallObject($event->Prefix.'.-item', $event->Prefix);
		$object->SwitchToTemp();
		$object->Load($id);

		$shipping_obj =& $this->Application->recallObject('s');
		$lang_object =& $this->Application->recallObject('lang.current');
		// by weight and US/UK system - we need to store recalculated price per Kg cause shipping calculation is done per Kg!
		if ($shipping_obj->GetDBField('Type') == 1 && $lang_object->GetDBField('UnitSystem') == 2) {
			$object->SetDBField('PerUnit', $object->GetDBField('PerUnit') / POUND_TO_KG);
			$object->Update(null, true);
		}
	}
}