<?php
/**
* @version	$Id: install.php 12361 2009-08-22 19:04:26Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.net/license/commercial/ for copyright notices and details.
*/
	$module_folder = 'in-commerce';

	if (!defined('IS_INSTALL')) {
		// separate module install
		define('IS_INSTALL', 1);
		define('ADMIN', 1);
		define('REL_PATH', $module_folder);
		define('FULL_PATH', realpath(dirname(__FILE__) . '/..') );

		include_once(FULL_PATH . '/core/kernel/startup.php');
		require_once FULL_PATH . '/core/install/install_toolkit.php';

		$toolkit = new kInstallToolkit();
	}
	else {
		// install, using installation wizard
		$toolkit =& $this->toolkit;
		/* @var $toolkit kInstallToolkit */
	}

	$application =& kApplication::Instance();
	$application->Init();

	if ($application->RecallVar('user_id') != -1) {
		die('restricted access!');
	}

	$category =& $toolkit->createModuleCategory('Products', 'Product Catalog', '/in-commerce/designs/section', 'in-commerce/img/menu_products.gif');

	$toolkit->RunSQL('/' . $module_folder . '/install/install_schema.sql');
	$toolkit->RunSQL('/' . $module_folder . '/install/install_data.sql', '{ProductCatId}', $category->GetID());
	$toolkit->ImportLanguage('/' . $module_folder . '/install/english');

	$toolkit->SetModuleRootCategory($module_folder, $category->GetID());

	$toolkit->linkCustomFields($module_folder, 'p', 11); // to create Custom Fields for Products
	$toolkit->linkCustomFields('KERNEL', 'u', 6); // to create shipping related Custom Fields for Users
	$toolkit->linkCustomFields('KERNEL', 'c', 1); // to create ItemTemplate custom field
	$toolkit->setModuleItemTemplate($category, 'p', 'in-commerce/products/product_detail');

	$toolkit->finalizeModuleInstall($module_folder, true);