<?php
/**
* @version	$Id: taxes_tag_processor.php 11899 2009-07-14 11:11:59Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.net/license/commercial/ for copyright notices and details.
*/

class TaxesTagProcessor extends kDBTagProcessor 
{
	/*
	function ShowDestinations($param)
	{
		$zone =& $this->Application->recallObject('tax');
		$zone->SetDBField('TaxZoneId', $zone->ID);
		$destination =& $this->Application->recallObject('taxdst');
		
		if(!$this->Application->GetVar('loaded'))
		{									
			if ($zone->GetID() == 0)
			{
				$this->Application->DeleteVar('taxdst');
			}
			else 
			{
				$sql = 'SELECT * FROM '.$destination->TableName.' WHERE TaxZoneId='.$zone->GetID();
				$res = $this->Conn->Query($sql);
				if (is_array($res)) foreach ($res as $dest_record)
				{
					$temp[$dest_record['TaxZoneDestId']]['TaxZoneDestId'] = $dest_record['TaxZoneDestId'];
					$temp[$dest_record['TaxZoneDestId']]['StdDestId'] = $dest_record['StdDestId'];
					$temp[$dest_record['TaxZoneDestId']]['DestValue'] = $dest_record['DestValue'];
				}
				$this->Application->SetVar('taxdst', $temp);
			}
		}
		$destination =& $this->Application->recallObject('taxdst');
		
		$hidden_clause = '<input type="hidden" name="loaded" value="1"><input type="hidden" name="zone_id" value="'.$zone->GetDBField('TaxZoneId').'">';
		
		switch ( $zone->GetDBField('Type') )
		{
			case 1:
				
				$sql = 'SELECT * FROM '.TABLE_PREFIX.'StdDestinations WHERE DestType=1';
				$res = $this->Conn->Query($sql, 'DestId');
				
				$dropdown = '<select name="country">'."\n";
				foreach ($res as $record)
				{
					$dropdown .= '<option value="'.$record['DestId'].'">'.$this->Application->Phrase($record['DestName']).'</option>'."\n";
				}
				$dropdown .= '</select>'."\n";
				
				$form_params = Array();
				$form_params['dropdown'] = $dropdown;
				$form_params['block'] = $param['block'];
				$form_params['res'] = $res;
				$ret = $this->ShowDestionationForm($form_params);
				break;
			case 2:

				$country_sql = 'SELECT d1.* FROM '.TABLE_PREFIX.'StdDestinations d1,
								'.TABLE_PREFIX.'StdDestinations d2								
								WHERE d1.DestType=1 AND d1.DestId=d2.DestParentId
								GROUP BY d1.DestId';
				if( !($current_country = $this->Application->GetVar('StatesCountry')) )
				{
					$current_country_sql = 'SELECT sd.DestParentId FROM '.TABLE_PREFIX.'StdDestinations sd
												LEFT JOIN '.$destination->TableName.' zd
												ON zd.StdDestId = sd.DestId
												WHERE sd.DestType=2 AND zd.TaxZoneId='.$zone->GetDBField('TaxZoneId');
					if($zone->GetDBField('TaxZoneId'))
					{
						$current_country = $this->Conn->GetOne($current_country_sql);
					}
					
					if(!$current_country)
					{
						$current_country_sql = 'SELECT DestId FROM '.TABLE_PREFIX.'StdDestinations WHERE DestType=1';
						$current_country = $this->Conn->GetOne($current_country_sql);
					}
				}				
				$states_sql = 'SELECT * FROM '.TABLE_PREFIX.'StdDestinations WHERE DestType=2 AND DestParentId='.$current_country;
				$countries = $this->Conn->Query($country_sql, 'DestId');
				$states = $this->Conn->Query($states_sql, 'DestId');
				
				if($countries)
				{
					$countries_dropdown = '<select name="StatesCountry" onchange="submit_event(\'tax\', \'OnCountryChange\')">'."\n";
					foreach ($countries as $record)
					{
						$countries_dropdown .= '<option value="'.$record['DestId'].'" ';
						if($record['DestId'] == $current_country)
						{
							$countries_dropdown .= 'selected';
						}
						$countries_dropdown .= '>'.$this->Application->Phrase($record['DestName']).'</option>'."\n";
					}
					$countries_dropdown .= '</select>'."\n";
				}
				
				if($states)
				{
					$states_dropdown = '<select name="state">'."\n";
					foreach ($states as $id => $record)
					{
						$states_dropdown .= '<option value="'.$record['DestId'].'">'.$this->Application->Phrase($record['DestName']).'</option>'."\n";
					}
					$states_dropdown .= '</select>'."\n";
				}
				
				$form_params = Array();
				$table = '<table border="0"><tr><td>'.$this->Application->Phrase('la_Country').': </td><td>'.$countries_dropdown.'</td></tr>';
				$table .= '<tr><td>'.$this->Application->Phrase('la_State').': </td><td>'.$states_dropdown.'</td></tr></table>';
				$form_params['dropdown'] = $table;
				$form_params['block'] = $param['block'];
				$form_params['res'] = $states;
				$ret = $this->ShowDestionationForm($form_params);
				
				break;
			case 3:
				
			if( !($current_country = $this->Application->GetVar('StatesCountry')) )
				{
					$current_country_sql = 'SELECT sd.DestParentId FROM '.TABLE_PREFIX.'StdDestinations sd
												LEFT JOIN '.$destination->TableName.' zd
												ON zd.StdDestId = sd.DestId
												WHERE sd.DestType=2 AND zd.TaxZoneId='.$zone->GetDBField('TaxZoneId');
					if($zone->GetDBField('TaxZoneId'))
					{
						$current_country = $this->Conn->GetOne($current_country_sql);
					}

					if(!$current_country)
					{
						$current_country_sql = 'SELECT StdDestId FROM '.$destination->TableName.' WHERE TaxZoneId='.$zone->GetID();
						$current_country = $this->Conn->GetOne($current_country_sql);
					}						
					
					if(!$current_country)
					{
						$current_country_sql = 'SELECT DestId FROM '.TABLE_PREFIX.'StdDestinations WHERE DestType=1';
						$current_country = $this->Conn->GetOne($current_country_sql);
					}
				
				
				}
				
				$country_sql = 'SELECT d1.* FROM '.TABLE_PREFIX.'StdDestinations d1
								WHERE d1.DestType=1
								GROUP BY d1.DestId';			
				$countries = $this->Conn->Query($country_sql, 'DestId');		

				if($countries)
				{
					$countries_dropdown = '<select name="StatesCountry" onchange="submit_event(\'tax\', \'OnCountryChange\')">'."\n";
					foreach ($countries as $record)
					{
						print "<br>";
						$countries_dropdown .= '<option value="'.$record['DestId'].'" ';
						if($record['DestId'] == $current_country)
						{
							$countries_dropdown .= 'selected';
						}
						$countries_dropdown .= '>'.$this->Application->Phrase($record['DestName']).'</option>'."\n";
					}
					$countries_dropdown .= '</select>'."\n";
				}				
				
				$sql = 'SELECT DestValue FROM '.$this->Application->getUnitOption('taxdst', 'TableName').' WHERE NOT(DestValue IS NULL) AND DestValue<>"" AND StdDestId='.$current_country;
				$res = array_unique( $this->Conn->GetCol($sql) );
				$dropdown = '<input type="text" name="zip_input" id="zip_input" size="15">';
				if($res)
				{
					$dropdown .= ' or <select name="zip_dropdown">'."\n";
					$dropdown .= '<option value=""></option>';
					foreach ($res as $record)
					{
						$dropdown .= '<option value="'.$record.'">'.$record.'</option>'."\n";
					}
					$dropdown .= '</select>'."\n";
				}
				
				$table = '<table border="0"><tr><td>'.$this->Application->Phrase('la_Country').': </td><td>'.$countries_dropdown.'</td></tr>';
				$table .= '<tr><td>'.$this->Application->Phrase('la_fld_ZIP').': </td><td>'.$dropdown.'</td></tr></table>';
				
				$form_params = Array();
				$form_params['dropdown'] = $table;
				$form_params['block'] = $param['block'];
				$form_params['res'] = $res;
				$ret = $this->ShowDestionationForm($form_params);
				
				break;
			default:
		}
		
		$ret .= $hidden_clause;		
		return $ret;
	}
	*/
	/*
	function ShowDestionationForm($param)
	{
		$add_button = '<input type="button" class="button" value="'.$this->Application->Phrase('la_btn_AddLocation').'" onclick="submit_event(\'tax\', \'OnAddLocation\')">';
				
		$main_processor =& $this->Application->RecallObject('m_TagProcessor');
		$oddevenparam['odd'] = 'table-color1';
		$oddevenparam['even'] = 'table-color2';
		$ret = '<tr class="'.$main_processor->Odd_Even($oddevenparam).'"><td></td><td>'.$param['dropdown'].'</td><td>'.$add_button.'</td></tr>';
		
		$dest_list = $this->Application->GetVar('taxdst');
		if (is_array($dest_list))
		{
			
			
			if (sizeof($dest_list)>0){
				$ret .= '<tr class="'.$main_processor->Odd_Even($oddevenparam).'"><td>&nbsp;</td><td>';
				$ret .= '<select multiple name="location_list" onchange="SelectToString(this)">';
				$hidden = '';
				
				foreach ($dest_list as $id => $destination)
				{
					$params = $destination;
					$params['id'] = $id;
					$hidden .= '<input type="hidden" id="taxdst['.$destination['TaxZoneDestId'].'][TaxZoneDestId]" name="taxdst['.$destination['TaxZoneDestId'].'][TaxZoneDestId]" value="'.$destination['TaxZoneDestId'].'">';
					if($destination['StdDestId'] && !$destination['DestValue'])
					{
						$params['destination_title'] = $param['res'][$destination['StdDestId']]['DestName'];
						$hidden .= '<input type="hidden" id="taxdst['.$destination['TaxZoneDestId'].'][StdDestId]" name="taxdst['.$destination['TaxZoneDestId'].'][StdDestId]" value="'.$destination['StdDestId'].'">';
					}
					else
					{
						$params['destination_title'] = $destination['DestValue'];
						$hidden .= '<input type="hidden" id="taxdst['.$destination['TaxZoneDestId'].'][DestValue]" name="taxdst['.$destination['TaxZoneDestId'].'][DestValue]" value="'.$destination['DestValue'].'">';
					}
					
					$params['name']	= $param['block'];
					$ret .= $main_processor->ParseBlock($params);
				}	
				$ret .= '</select>';
						
				$ret .= '</td><td><input type="button" class="button" value="'.$this->Application->Phrase('la_btn_RemoveLocations').'" onclick="remove_location('.$destination['TaxZoneDestId'].')">';
				$ret .= $hidden;				
				$ret .= "&nbsp;</td></tr>";				
			}else{
				
			}
		}
		
//		<input type="hidden" id="taxdst[<inp:m_param name="id"/>][TaxZoneDestId]" name="taxdst[<inp:m_param name="id"/>][TaxZoneDestId]" value="<inp:m_param name="id"/>">
		return $ret;
	}
	*/
	function ShowCountries($param){
		
		$param = $this->prepareTagParams($param);
		$param['name'] = $param['block'];
		
		$destination 	= &$this->Application->recallObject('taxdst');
		$zone 			= &$this->Application->recallObject('tax');
				
		switch ($param['show']){
			case 'current':
				$sql = 'SELECT sd.* FROM '.TABLE_PREFIX.'StdDestinations sd
												LEFT JOIN '.$destination->TableName.' zd
													ON zd.StdDestId = sd.DestId
												LEFT JOIN '.TABLE_PREFIX.'Phrase
													ON '.TABLE_PREFIX.'Phrase.Phrase = sd.DestName													
												WHERE sd.DestType=1 
												AND LanguageId='.$this->Application->GetVar('lang.current_id').'
												AND zd.TaxZoneId='.$zone->GetDBField('TaxZoneId').'
												ORDER BY Translation
												';
				break;
			case 'available':
				$sql = 'SELECT sd.* FROM '.TABLE_PREFIX.'StdDestinations sd
												LEFT JOIN '.$destination->TableName.' zd
													ON zd.StdDestId = sd.DestId
												LEFT JOIN '.TABLE_PREFIX.'Phrase
													ON '.TABLE_PREFIX.'Phrase.Phrase = sd.DestName													
												WHERE sd.DestType=1 
												AND LanguageId='.$this->Application->GetVar('lang.current_id').'
												AND zd.TaxZoneId IS NULL
												ORDER BY Translation
												';
				break;		
			case 'all':
			
				$selected_country = $this->Application->GetVar('CountrySelector');
				if (!$selected_country){
					// get 1st available country ID
					$selected_country = $this->Conn->GetOne('SELECT StdDestId FROM '.$destination->TableName.'
								WHERE TaxZoneId='.$zone->GetDBField('TaxZoneId'));
					if ($selected_country){
						$this->Application->SetVar('CountrySelector', $selected_country);
					}
				}			
			
				$sql = 'SELECT sd.* FROM '.TABLE_PREFIX.'StdDestinations sd
												LEFT JOIN '.TABLE_PREFIX.'Phrase
													ON '.TABLE_PREFIX.'Phrase.Phrase = sd.DestName
												WHERE sd.DestType=1
												AND LanguageId='.$this->Application->GetVar('lang.current_id').'
												ORDER BY Translation
												';
				break;	
			case 'has_states':
				$has_states = $this->Conn->GetCol('SELECT DISTINCT DestParentId FROM '.TABLE_PREFIX.'StdDestinations sd
												WHERE sd.DestType=2');
				$selected_country = $this->Application->GetVar('CountrySelector');
				
				if ($selected_country && !in_array($selected_country, $has_states)){
					$selected_country = $has_states[0];
					$this->Application->SetVar('CountrySelector', $selected_country);
				}
				
				if (!$selected_country){
					// get 1st available country ID
					$selected_country = $this->Conn->GetOne('SELECT DestParentId FROM '.TABLE_PREFIX.'StdDestinations sd
								LEFT JOIN '.$destination->TableName.' zd
								ON zd.StdDestId = sd.DestId
								WHERE sd.DestType=2 
								AND zd.TaxZoneId='.$zone->GetDBField('TaxZoneId'));
					if ($selected_country){
						$this->Application->SetVar('CountrySelector', $selected_country);
					}
					else {
						$selected_country = $has_states[0];
						$this->Application->SetVar('CountrySelector', $selected_country);
					}
				}
				
				
				$sql = 'SELECT sd.* FROM '.TABLE_PREFIX.'StdDestinations sd
												LEFT JOIN '.TABLE_PREFIX.'Phrase
													ON '.TABLE_PREFIX.'Phrase.Phrase = sd.DestName
												WHERE sd.DestType=1 
												AND LanguageId='.$this->Application->GetVar('lang.current_id').'
												AND DestId IN ('.implode(',', $has_states).') 
												ORDER BY Translation
												';
				break;								
		}
		
		$countries = $this->Conn->Query($sql);
		$o = '';
		
		
		foreach($countries as $key => $country) {
			$param['id'] = $country['DestId'];
			$param['destination_title'] = $this->Application->Phrase($country['DestName']);
			if (isset($selected_country) && $selected_country == $param['id']){
				$param['selected'] = ' selected="selected"';
			}
			else {
				$param['selected']='';
			}
			$o .= $this->Application->ParseBlock($param);
		}
		return $o;
		
	}
	
	function ShowStates($param){
		
		$param = $this->prepareTagParams($param);
		$param['name'] = $param['block'];
		
		$destination 	= &$this->Application->recallObject('taxdst');
		$zone 			= &$this->Application->recallObject('tax');
		
		switch ($param['show']){
			case 'current':
				$sql = 'SELECT * FROM '.TABLE_PREFIX.'StdDestinations sd
												LEFT JOIN '.$destination->TableName.' zd
													ON zd.StdDestId = sd.DestId
												LEFT JOIN '.TABLE_PREFIX.'Phrase
													ON '.TABLE_PREFIX.'Phrase.Phrase = sd.DestName
												WHERE sd.DestType=2 
												AND LanguageId='.$this->Application->GetVar('lang.current_id').'
												AND sd.DestParentId='.$this->Application->GetVar('CountrySelector').'
												AND zd.TaxZoneId='.$zone->GetDBField('TaxZoneId').'
												ORDER BY Translation
												';
				break;
			case 'available':
				$sql = 'SELECT * FROM '.TABLE_PREFIX.'StdDestinations sd
												LEFT JOIN '.$destination->TableName.' zd
													ON zd.StdDestId = sd.DestId
												LEFT JOIN '.TABLE_PREFIX.'Phrase
													ON '.TABLE_PREFIX.'Phrase.Phrase = sd.DestName
												WHERE sd.DestType=2 
												AND LanguageId='.$this->Application->GetVar('lang.current_id').'
												AND zd.TaxZoneId IS NULL 
												AND sd.DestParentId='.$this->Application->GetVar('CountrySelector').'
												ORDER BY Translation
												';
												
				break;		
			case 'all':
				$sql = 'SELECT sd.* FROM '.TABLE_PREFIX.'StdDestinations sd
												LEFT JOIN '.TABLE_PREFIX.'Phrase
													ON '.TABLE_PREFIX.'Phrase.Phrase = sd.DestName
												WHERE sd.DestType=2 
												AND LanguageId='.$this->Application->GetVar('lang.current_id').'
												AND sd.DestParentId='.$this->Application->GetVar('CountrySelector').'
												ORDER BY Translation
												';
				break;	
		}		
		
		$states = $this->Conn->Query($sql);
		$o = '';
		foreach($states as $key => $state) {
			$param['id'] = $state['DestId'];
			$param['destination_title'] = $this->Application->Phrase($state['DestName']);
			$o .= $this->Application->ParseBlock($param);
		}
		return $o;
		
	}
	
	function ShowZips($param){
		
		$param = $this->prepareTagParams($param);
		$param['name'] = $param['block'];
		
		$destination 	= &$this->Application->recallObject('taxdst');
		$zone 			= &$this->Application->recallObject('tax');
		
		$country_selector = $this->Application->GetVar('CountrySelector');
		if (!$country_selector){
			$country_selector=0;
		}
		
		switch ($param['show']){
			case 'current':
				$sql = 'SELECT * FROM '.$destination->TableName.'
												WHERE NOT(DestValue IS NULL) 
												AND DestValue<>""
												AND TaxZoneID='.$zone->GetDBField('TaxZoneId').'
												ORDER BY DestValue
												';
				break;
			case 'available':
				$selected_zips = $this->Conn->GetCol('SELECT DestValue FROM '.$destination->TableName.'
												WHERE NOT(DestValue IS NULL) 
												AND DestValue<>""
												AND TaxZoneID='.$zone->GetDBField('TaxZoneId').'
												ORDER BY DestValue
												');
				
				$sql = 'SELECT DISTINCT(DestValue) FROM '.$this->Application->getUnitOption('taxdst', 'TableName').'
												WHERE NOT(DestValue IS NULL) 
												AND TaxZoneID!='.$zone->GetDBField('TaxZoneId').'
												AND DestValue NOT IN ("'.implode('", "', $selected_zips).'")
												AND DestValue<>"" AND StdDestId='.$country_selector.'
												ORDER BY DestValue
												';
												
				break;		
			case 'all':
				$sql = 'SELECT sd.* FROM '.TABLE_PREFIX.'StdDestinations sd
												WHERE sd.DestType=3 AND sd.DestParentId='.$country_selector.'
												ORDER BY DestValue
												';
				break;	
		}		
		
		$zips = $this->Conn->Query($sql);
		$o = '';
		foreach($zips as $key => $zip) {
			$param['id'] = $zip['DestId'].'|'.$zip['DestValue'];
			$param['destination_title'] = $zip['DestValue'];
			$o .= $this->Application->ParseBlock($param);
		}
		return $o;
		
	}	
	
	
}

?>