<?php
/**
* @version	$Id: manufacturers_config.php 11899 2009-07-14 11:11:59Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.net/license/commercial/ for copyright notices and details.
*/

$config	=	Array(
					'Prefix'			=>	'manuf',
					'ItemClass'			=>	Array('class'=>'kDBItem','file'=>'','build_event'=>'OnItemBuild'),
					'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
					'EventHandlerClass'	=>	Array('class'=>'ManufacturersEventHandler','file'=>'manufacturers_event_handler.php','build_event'=>'OnBuild'),
					'TagProcessorClass' =>	Array('class'=>'ManufacturersTagProcessor','file'=>'manufacturers_tag_processor.php','build_event'=>'OnBuild'),
					'AutoLoad'			=>	true,
					'Hooks'				=>	Array(
												Array(
													'Mode' => hAFTER,
													'Conditional' => false,
													'HookToPrefix' => 'manuf',
													'HookToSpecial' => '',
													'HookToEvent' => Array('OnAfterItemLoad', 'OnBeforeItemCreate', 'OnBeforeItemUpdate', 'OnUpdateAddress'),
													'DoPrefix' => '',
													'DoSpecial' => '',
													'DoEvent' => 'OnPrepareStates',
												),
						),
					'QueryString'		=>	Array(
												1	=>	'id',
												2	=>	'Page',
												3	=>	'event',
												4	=>	'mode',
											),
					'IDField'			=>	'ManufacturerId',
					'StatusField'		=>	Array(),
					'TableName'			=>	TABLE_PREFIX.'Manufacturers',

					'TitlePresets'		=>	Array(
												'default'	=>	Array(	'new_status_labels'		=> Array('manuf'=>'!la_title_AddingManufacturer!'),
																		'edit_status_labels'	=> Array('manuf'=>'!la_title_EditingManufacturer!'),
																		'new_titlefield'		=> Array('manuf'=>'!la_title_NewManufacturers!'),
																),

												'manuf_list'=>Array(	'prefixes'				=> Array('manuf_List'),
																			'format'				=>	"!la_title_Manufacturers!",
																),

												'manuf_edit'=>Array(	'prefixes'				=> Array('manuf'),
																			'new_titlefield'		=> Array('manuf'=>'!la_title_NewManufacturer!'),
																			'format'				=> "#manuf_status# '#manuf_titlefield#' - !la_title_General!",
																),

											),

					'PermSection'		=>	Array('main' => 'in-commerce:manufacturers'),

					'Sections'			=>	Array(
						'in-commerce:manufacturers'	=>	Array(
							'parent'		=>	'in-commerce',
							'icon'			=>	'in-commerce:manufacturers',
							'label'			=>	'la_tab_Manufacturers',
							'url'			=>	Array('t' => 'in-commerce/manufacturers/manufacturers_list', 'pass' => 'm'),
							'permissions'	=>	Array('view', 'add', 'edit', 'delete'),
							'priority'		=>	6,
							'type'			=>	stTREE,
						),
					),

					'TitleField'		=>	'Name',		// field, used in bluebar when editing existing item


					'ListSQLs'			=>	Array(	''=>'SELECT * FROM %s',
													), // key - special, value - list select sql
					'ItemSQLs'			=>	Array(''=>'SELECT * FROM %s',
																		),
					'ListSortings'	=> 	Array(
																'' => Array(
																	'Sorting' => Array('Name' => 'asc'),
																)
															),
					'Fields' => Array (
			            'ManufacturerId' => Array('type' => 'int', 'not_null' => 1, 'default' => 0,),
			            'Name' => Array('type' => 'string','not_null' => '1','default' => '', 'required'=>true,'max_len'=>255),
			            'Description' => Array('type' => 'string', 'formatter' => 'kFormatter', 'not_null' => 1, 'using_fck' => 1, 'default' => ''),
			            'URL' => Array('type' => 'string','not_null' => '1','default' => '','max_len'=>255),
			            'Logo' => Array (
			            	'type' => 'string',
			            	'formatter' => 'kPictureFormatter',
			            	'max_size' => MAX_UPLOAD_SIZE, 'upload_dir' => IMAGES_PATH.'manufacturers/',
			            	'file_types' => '*.jpg;*.gif;*.png', 'files_description' => '!la_ImageFiles!',
			            	'multiple' => false,
			            	'max_len' => 255, 'not_null' => 1, 'default' => ''
			            ),
			            'IsPopular' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 0),
			            'Email' => Array('type' => 'string', 'formatter'=>'kFormatter', 'regexp'=>'/^(' . REGEX_EMAIL_USER . '@' . REGEX_EMAIL_DOMAIN . ')$/i', 'sample_value' => 'email@domain.com', 'default' => null, 'error_msgs' => Array('invalid_format'=>'!la_invalid_email!') ),
				        'Phone' => Array('type' => 'string','default' => null),
				        'Fax' => Array('type' => 'string', 'default' => null),
				        'Address1' => Array('type' => 'string','default' => null),
				        'Address2' => Array('type' => 'string', 'default' => null),
				        'City' => Array('type' => 'string','default' => null),
				        'State' => Array('type' => 'string', 'formatter' => 'kOptionsFormatter', 'options' => Array(), 'option_key_field' => 'DestAbbr', 'option_title_field' => 'Translation', 'default' => null),
				        'Zip' => Array('type' => 'string', 'default' => null),
				        'Country' => Array('type' => 'string', 'formatter'=>'kOptionsFormatter',
				            				'options_sql'=>'SELECT %1$s
																	FROM '.TABLE_PREFIX.'StdDestinations
																	LEFT JOIN '.TABLE_PREFIX.'Phrase
																		ON '.TABLE_PREFIX.'Phrase.Phrase = '.TABLE_PREFIX.'StdDestinations.DestName
																	WHERE
																		DestType=1
																		AND
																		LanguageId = %2$s
																	ORDER BY Translation',
									            		'option_key_field'=>'DestAbbr','option_title_field'=>'Translation', 'default' => null),
					),

					'Grids' => Array (
						'Default' => Array (
							'Icons' => Array ('default'=>'icon16_manuf.gif'),
							'Fields' => Array (
								'ManufacturerId' => Array ('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter'),
								'Name' => Array ('title' => 'la_col_ManufacturerName', 'filter_block' => 'grid_like_filter'),
								'IsPopular' => Array ('title' => 'la_col_IsPopular', 'filter_block' => 'grid_options_filter'),
								'URL' => Array ('title' => 'la_col_URL', 'filter_block' => 'grid_like_filter'),
							),
						),
					),

					'ConfigMapping' => Array (
						'PerPage' => 'Comm_Perpage_Manufacturers',
						'ShortListPerPage' => 'Comm_Perpage_Manufacturers_Short',
					),
	);

?>