<?php
/**
* @version	$Id: affiliate_payments_config.php 11909 2009-07-18 01:29:18Z dmitrya $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.net/license/commercial/ for copyright notices and details.
*/

$config	=	Array(
					'Prefix'			=>	'apayments',
					'ItemClass'			=>	Array('class'=>'kDBItem','file'=>'','build_event'=>'OnItemBuild'),
					'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
					'EventHandlerClass'	=>	Array('class'=>'AffiliatePaymentsEventHandler','file'=>'affiliate_payments_event_handler.php','build_event'=>'OnBuild'),
					'TagProcessorClass' =>	Array('class'=>'AffiliatePaymentsTagProcessor','file'=>'affiliate_payments_tag_processor.php','build_event'=>'OnBuild'),
					'AutoLoad'			=>	true,

					'AggregateTags' => Array(
											Array(
												'AggregateTo' => 'ord',
												'AggregatedTagName' => 'InitPaymentsList',
												'LocalTagName' => 'InitList',
											),
											Array(
												'AggregateTo' => 'ord',
												'AggregatedTagName' => 'ListPayments',
												'LocalTagName' => 'ListPayments',
											),
											Array(
												'AggregateTo' => 'ord',
												'AggregatedTagName' => 'PaymentsPaginationBar',
												'LocalTagName' => 'PaginationBar',
											),
											Array(
												'AggregateTo' => 'ord',
												'AggregatedTagName' => 'PaymentsCount',
												'LocalTagName' => 'TotalRecords',
											),
										),
					'QueryString'		=>	Array(
												1	=>	'id',
												2	=>	'Page',
												3	=>	'event',
											),

					'IDField'			=>	'AffiliatePaymentId',

					'TitlePresets'		=>	Array(
												'default'	=>	Array(	'new_status_labels'		=> Array('apayments'=>'!la_title_Adding_Affiliate_Payment!'),
																		'edit_status_labels'	=> Array('apayments'=>'!la_title_Editing_Affiliate_Payment!'),
																		'new_titlefield'		=> Array('apayments'=>'!la_title_New_Affiliate_Payment!'),
																),
												'payments_log'	=>	Array('prefixes' => Array('apayments.log_List'), 'format' => "!la_title_AffiliatePayments!"),

											),

					'Sections'			=>	Array(
						'in-commerce:paymentlog'		=>	Array(
							'parent'		=>	'in-commerce',
							'icon'			=>	'payment_log',
							'label'			=>	'la_tab_PaymentLog',
							'url'			=>	Array('t' => 'in-commerce/payments/payments_list', 'pass' => 'm'),
							'permissions'	=>	Array('view'),
							'priority'		=>	9,
							'type'			=>	stTREE,
						),
					),

					'TableName'			=>	TABLE_PREFIX.'AffiliatePayments',

					'ListSQLs'			=>	Array(''=>'	SELECT %1$s.* %2$s
														FROM %1$s
														LEFT JOIN '.TABLE_PREFIX.'Affiliates af ON %1$s.AffiliateId = af.AffiliateId
														LEFT JOIN '.TABLE_PREFIX.'PortalUser au ON af.PortalUserId = au.PortalUserId'),

					'ItemSQLs'			=>	Array(''=>'	SELECT %1$s.* %2$s
														FROM %1$s
														LEFT JOIN '.TABLE_PREFIX.'Affiliates af ON %1$s.AffiliateId = af.AffiliateId
														LEFT JOIN '.TABLE_PREFIX.'PortalUser au ON af.PortalUserId = au.PortalUserId'),

					'CalculatedFields'	=>	Array(
												''		=> Array(
													'PortalUserId'	=>	'af.PortalUserId',
												),
												'log' 	=> Array(
													'Username'		=>	'au.Login',
													'PortalUserId'	=>	'af.PortalUserId',
												),
											),

					'ForeignKey'		=>	'AffiliateId',
					'ParentTableKey'	=>	'AffiliateId',
					'ParentPrefix' 		=>	'affil',
					'AutoDelete'		=>	true,
					'AutoClone'			=>	true,

					'ListSortings'	=> 	Array(
												'' => Array(
															'Sorting' => Array('PaymentDate' => 'desc'),
														)
										),

					'Fields' => Array(
										'AffiliatePaymentId' => Array('type' => 'int', 'not_null' => 1, 'default' => 0),
										'AffiliateId' => Array('type'=>'int','formatter'=>'kLEFTFormatter', 'error_msgs' => Array ('invalid_option' => '!la_error_UserNotFound!'), 'options' => Array(0 => 'lu_None'), 'left_sql'=>'SELECT %s FROM '.TABLE_PREFIX.'Affiliates af LEFT JOIN '.TABLE_PREFIX.'PortalUser pu ON pu.PortalUserId = af.PortalUserId WHERE `%s` = \'%s\'','left_key_field'=>'AffiliateId','left_title_field'=>'Login','not_null'=>1,'default'=>0),
										'PaymentDate' => Array('type' => 'int', 'formatter'=>'kDateFormatter', 'not_null' => '1','default' => '#NOW#'),
										'Amount' => Array('type' => 'double', 'formatter'=>'kFormatter', 'format'=>'%.02f', 'not_null' => '1', 'required'=>1, 'default' => '0.00'),
										'Comment' => Array('type' => 'string', 'formatter' => 'kFormatter', 'not_null' => 1, 'using_fck' => 1, 'default' => ''),
										'PaymentReference' => Array('type' => 'string','not_null' => '1','default' => ''),
										'PaymentTypeId' => Array('type' => 'int', 'formatter'=>'kOptionsFormatter', 'options_sql'=>'SELECT Name, PaymentTypeId FROM '.TABLE_PREFIX.'AffiliatePaymentTypes WHERE Status = 1 ORDER BY IsPrimary DESC, Priority DESC, Name ASC', 'option_key_field'=>'PaymentTypeId', 'option_title_field'=>'Name', 'not_null' => 1, 'default' => 0),
									),

					'VirtualFields' => Array(
										'Username' 		=> Array('type' => 'string'),
										'PortalUserId' 	=> Array('type' => 'int'),
								),

					'Grids'	=> Array(
								'Default'		=>	Array(
															'Icons' => Array('default'=>'icon16_affiliate_payment.gif'),
															'Fields' => Array(
																			'AffiliatePaymentId'=> Array( 'title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter'),
																			'PaymentDate'		=> Array( 'title' => 'la_col_PaymentDate', 'filter_block' => 'grid_date_range_filter'),
																			'Amount'			=> Array( 'title' => 'la_col_Amount', 'filter_block' => 'grid_float_range_filter'),
																			'Comment'			=> Array( 'title' => 'la_col_Comment', 'filter_block' => 'grid_like_filter', 'first_chars' => 50),
																			'PaymentTypeId'		=> Array( 'title' => 'la_col_PaymentType', 'filter_block' => 'grid_options_filter'),
																			'PaymentReference'	=> Array( 'title' => 'la_col_PaymentReference', 'filter_block' => 'grid_like_filter', 'first_chars' => 50),
																		),
													),
								'Log'			=>	Array(
															'Icons' => Array('default'=>'icon16_affiliate_payment.gif'),
															'Fields' => Array(
																			'AffiliatePaymentId'=> Array( 'title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter'),
																			'Username'			=> Array( 'title' => 'la_col_Username', 'data_block' => 'grid_userlink_td', 'filter_block' => 'grid_like_filter'),
																			'PaymentDate'		=> Array( 'title' => 'la_col_PaymentDate', 'filter_block' => 'grid_date_range_filter'),
																			'Amount'			=> Array( 'title' => 'la_col_Amount', 'data_block' => 'grid_currency_td', 'filter_block' => 'grid_float_range_filter'),
																			'Comment'			=> Array( 'title' => 'la_col_Comment', 'filter_block' => 'grid_like_filter', 'first_chars' => 50),
																			'PaymentTypeId'		=> Array( 'title' => 'la_col_PaymentType', 'filter_block' => 'grid_options_filter'),
																			'PaymentReference'	=> Array( 'title' => 'la_col_PaymentReference', 'filter_block' => 'grid_like_filter', 'first_chars' => 50),
																		),
													),

								),
	);

?>