<?php
/**
* @version	$Id: affiliates_tag_processor.php 16516 2017-01-20 14:12:22Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class AffiliatesTagProcessor extends kDBTagProcessor {

		/**
		 * Returns link to be placed on other sites
		 *
		 * @param array $params Tag params.
		 *
		 * @return string
		 */
		protected function GetAffiliateLink(array $params)
		{
			/** @var kDBItem $object */
			$object = $this->getObject($params);

			return $this->buildAffiliateLink($object);
		}

		/**
		 * Returns link to be placed on other sites (for current user)
		 *
		 * @param array $params Tag params.
		 *
		 * @return string
		 */
		protected function GetUserAffiliateLink(array $params)
		{
			/** @var kDBItem $object */
			$object = $this->Application->recallObject($this->Prefix . '.manual', null, array('skip_autoload' => true));
			$object->Load($this->Application->RecallVar('user_id'), 'PortalUserId');

			return $this->buildAffiliateLink($object);
		}

		/**
		 * Builds affiliate link for given affiliate record.
		 *
		 * @param kDBBase $object Affiliate.
		 *
		 * @return string
		 */
		protected function buildAffiliateLink(kDBBase $object)
		{
			$params['affiliate'] = $object->GetDBField('AffiliateCode');

			if ( $this->Application->isAdmin ) {
				$params['prefix'] = '_FRONT_END_';
			}

			// Force defaults to remove "index.html" in Mod-Rewrite mode.
			$params['template'] = 'index';
			$params['m_lang'] = $this->Application->GetDefaultLanguageId();
			$params['m_theme'] = $this->Application->GetDefaultThemeId();

			// Build non-SSL link without SID in case, when SSL is enabled (or SSL domain doesn't match non-SSL domain).
			$params['__SSL__'] = 0;
			$params['__NO_SID__'] = 1;

			// Use Mod-Rewrite, when available.
			if ( $this->Application->ConfigValue('UseModRewrite') ) {
				$params['__MOD_REWRITE__'] = 1;
			}
			else {
				$params['index_file'] = 'index.php';
			}

			$link = $this->Application->ProcessParsedTag('m', 'Link', $params);

			// Manually remove "env".
			return preg_replace('/(.*)\/index.php\?env=(.*?)&amp;(.*)/', '\\1/index.php?\\3', $link);
		}

		/**
		 * [Aggregated Tag] Returns true if user is affiliate
		 *
		 * @param Array $params
		 * @return bool
		 * @access protected
		 */
		protected function User_IsAffiliate($params)
		{
			/** @var kDBItem $object */
			$object = $this->Application->recallObject($this->Prefix . '.user');

			return $object->isLoaded();
		}

		/**
		 * [Aggregated Tag] Checks, that affiliate record for current user exists and is active
		 *
		 * @param $params
		 * @return bool
		 * @access protected
		 */
		protected function User_AffiliateIsActive($params)
		{
			/** @var kDBItem $object */
			$object = $this->Application->recallObject($this->Prefix . '.user');

			return $object->isLoaded() && ($object->GetDBField('Status') == STATUS_ACTIVE);
		}

		/**
		 * Returns url for editing user from current record
		 *
		 * @param Array $params
		 * @return string
		 */
		function UserLink($params)
		{
			/** @var kDBItem $object */
			$object = $this->getObject($params);

			$user_id = $object->GetDBField('PortalUserId');

			if ( !$user_id ) {
				return '';
			}

			$url_params =  Array (
				'm_opener' => 'd',
				'u_mode' => 't',
				'u_event' => 'OnEdit',
				'u_id' => $user_id,
				'pass' => 'all,u'
			);

			return $this->Application->HREF($params['edit_template'], '', $url_params);
		}

		function CurrentUserAffiliateField($params)
		{
			return $this->Application->ProcessParsedTag($this->Prefix . '.user', 'Field', $params);
		}

		function IsAffiliateOrRegisterAsAffiliateAllowed($params)
		{
			/** @var kDBItem $object */
			$object = $this->Application->recallObject($this->Prefix . '.user');

			return $this->Application->ConfigValue('Comm_RegisterAsAffiliate') || $object->isLoaded() ? 1 : 0;
		}

		/**
		 * [AGGREGATED TAG] Checks if affiliate registration is allowed
		 *
		 * @param Array $params
		 * @return int
		 */
		function AllowAffiliateRegistration($params)
		{
			return $this->Application->ConfigValue('Comm_RegisterAsAffiliate') ? 1 : 0;
		}

		function Main_RequireAffiliate($params)
		{
			$t = $params['registration_template'];

			if ( !$this->User_IsAffiliate($params) ) {
				$redirect_params = Array ('next_template' => $this->Application->GetVar('t'));
				$this->Application->Redirect($t, $redirect_params);
			}
		}

		/**
		 * Calls OnNew event from template, when no other event submitted
		 *
		 * @param Array $params
		 */
		function PresetFormFields($params)
		{
			$prefix = $this->getPrefixSpecial();

			if ( !$this->Application->GetVar($prefix . '_event') && !$this->Application->GetVar('u.register_event') ) {
				$this->Application->HandleEvent(new kEvent($prefix . ':OnNew'));
			}
		}
	}
