<?php
/**
* @version	$Id: taxes_dst_event_handler.php 16516 2017-01-20 14:12:22Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class TaxDstEventHandler extends kDBEventHandler {

	/**
	 * Saves items
	 *
	 * @param kEvent $event
	 */
	function OnSaveDestinations($event)
	{
		/** @var kDBItem $object */
		$object = $event->getObject(Array ('skip_autoload' => true));

		$items_info = $this->Application->GetVar($event->getPrefixSpecial(true));

		/** @var kDBItem $tax_object */
		$tax_object = $this->Application->recallObject('tax');

		$std_dest_id = $this->Application->GetVar('StatesCountry');

		if ( $items_info ) {
			/** @var kDBItem $taxdest */
			$taxdest = $this->Application->recallObject($event->getPrefixSpecial(true), null);

			$parent_info =& $object->GetLinkedInfo();

			$queryDel = "DELETE FROM " . $object->TableName . " WHERE TaxZoneId=" . $parent_info['ParentId'];
			$this->Conn->Query($queryDel);

			foreach ($items_info as $field_values) {
				if ( $tax_object->GetDBField('Type') == 3 && (!$field_values['DestValue'] || $field_values['DestValue'] == '') ) {
					continue;
				}

				if ( !$field_values['StdDestId'] ) {
					$field_values['StdDestId'] = $std_dest_id;
				}

				$field_values['TaxZoneId'] = $parent_info['ParentId'];

				if ( $taxdest->Load($field_values['TaxZoneDestId'], "TaxZoneDestId") ) {
					$taxdest->SetFieldsFromHash($field_values);
					$event->setEventParam('form_data', $field_values);

					$taxdest->Update($field_values['TaxZoneDestId']);
				}
				else {
					$taxdest->SetFieldsFromHash($field_values);
					$event->setEventParam('form_data', $field_values);

					$taxdest->Create($field_values['TaxZoneDestId']);
				}
			}
		}
	}

	/**
	 * Creates new kDBItem
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnCreate(kEvent $event)
	{
		/** @var kDBItem $object */
		$object = $event->getObject(Array ('skip_autoload' => true));

		$items_info = $this->Application->GetVar($event->getPrefixSpecial(true));
		if ( !$items_info ) {
			return;
		}

		foreach ($items_info as $field_values) {
			$object->setID(0);
			$object->SetFieldsFromHash($field_values);
			$event->setEventParam('form_data', $field_values);

			$this->customProcessing($event, 'before');

			if ( $object->Create() ) {
				$this->customProcessing($event, 'after');
			}
			else {
				$event->status = kEvent::erFAIL;
				$event->redirect = false;
				$this->Application->SetVar($event->getPrefixSpecial() . '_SaveEvent', 'OnCreate');
				$object->setID(0);
			}
		}
	}

	/**
	 * Apply custom processing to item
	 *
	 * @param kEvent $event
	 * @param string $type
	 * @return void
	 * @access protected
	 */
	protected function customProcessing(kEvent $event, $type)
	{
		switch ($type) {
			case 'before':
				/** @var kDBItem $object */
				$object = $event->getObject();

				$events = $this->Application->GetVar('events');

				if ( $events['tax'] == 'OnUpdate' ) {
					$object->SetDBField('TaxZoneId', $this->Application->GetVar('tax_id'));
				}

				/** @var kDBItem $tax_object */
				$tax_object = $this->Application->recallObject('tax');

				if ( $tax_object->GetDBField('Type') == 3 ) {
					$tax_object->SetDBField('StdDestId', $this->Application->GetVar('StatesCountry'));
				}
				break;
		}
	}

	 /**
	 *
	 *
	 * @param kEvent $event
	 */
	function OnZoneUpdate($event) {

		/** @var kDBItem $object */
		$object = $event->getObject();

		/** @var kDBItem $zone_object */
		$zone_object = $this->Application->recallObject('tax');

		$zone_id = (int)$this->Application->GetVar('tax_id');
		$zone_type = $zone_object->GetDBField('Type');

		$delete_zones_sql = 'DELETE FROM '.$object->TableName.' WHERE TaxZoneId = '.$zone_id;
		$this->Conn->Query($delete_zones_sql);

		$selected_destinations = $this->Application->GetVar('selected_destinations');
		$selected_destinations_array = explode(',', $selected_destinations);
		$selected_destinations_array = array_unique($selected_destinations_array);

		foreach ($selected_destinations_array as $key => $dest_id) {

					if ($zone_object->GetDBField('Type') == 3){
						list ($tax_dest_id, $dest_value) = explode('|', $dest_id);
						$dest_id = $this->Application->GetVar('CountrySelector');
					}
					else {
						$dest_value = '';
					}

					if ($dest_id > 0){
						$object->SetDBField('TaxZoneId', $zone_id);
						$object->SetDBField('StdDestId', $dest_id);
						$object->SetDBField('DestValue', $dest_value);
						$object->Create();
					}

		}


	}

}
