<?php
/**
* @version	$Id: coupon_items_config.php 16385 2016-08-11 08:15:43Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

$config = Array (
	'Prefix' => 'coupi',
	'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
	'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
	'EventHandlerClass' => Array ('class' => 'CouponItemsEventHandler', 'file' => 'coupon_items_event_handler.php', 'build_event' => 'OnBuild'),
	'TagProcessorClass' => Array ('class' => 'CouponItemsTagProcessor', 'file' => 'coupon_items_tag_processor.php', 'build_event' => 'OnBuild'),

	'AutoLoad' => true,

	'Hooks' => Array (
		Array (
			'Mode' => hAFTER,
			'Conditional' => false,
			'HookToPrefix' => 'p',
			'HookToSpecial' => '-item',
			'HookToEvent' => Array ('OnAfterItemDelete'),
			'DoPrefix' => '',
			'DoSpecial' => '',
			'DoEvent' => 'OnDeleteCouponItem',
		),
	),

	'QueryString' => Array (
		1 => 'id',
		2 => 'Page',
		3 => 'PerPage',
		4 => 'event',
	),

	'IDField' => 'CouponItemId',
	'StatusField' => Array ('Status'),
	'TableName' => TABLE_PREFIX . 'ProductsCouponItems',

	'ForeignKey' => 'CouponId',
	'ParentTableKey' => 'CouponId',
	'ParentPrefix' => 'coup',
	'AutoDelete' => true,
	'AutoClone' => true,

	'ListSQLs' => Array (
		'' => '	SELECT %1$s.* %2$s
				FROM %1$s
				LEFT JOIN ' . TABLE_PREFIX . 'Products p ON %1$s.ItemResourceId = p.ResourceId
				LEFT JOIN ' . TABLE_PREFIX . 'Categories c ON %1$s.ItemResourceId = c.ResourceId',
	),

	/*'BelongsTo' => Array (
		Array (
			'prefix' => 'd', 'key' => 'DiscountId', 'ForeignKey' => 'DiscountId'),
	),*/

	'ListSortings' => Array (
		'' => Array (
			'Sorting' => Array ('ItemName' => 'asc'),
		),
	),

	'CalculatedFields' => Array (
		'' => Array (
			'ProductId' => 'p.ProductId',
			'ItemName' => 'IF(p.Name IS NULL,c.Name,p.l1_Name)',
			'SKU' => 'p.SKU',
			'Weight' => 'p.Weight',
			'CreatedOn' => 'p.CreatedOn',
			'BackOrderDate' => 'p.BackOrderDate',
			'Status' => 'p.Status',
			'CategoryId' => 'c.CategoryId',
		),
	),

	'Fields' => Array (
		'CouponItemId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0,),
		'CouponId' => Array ('type' => 'int', 'default' => null, ),
		'ItemResourceId' => Array ('type' => 'int', 'default' => null, ),
		'ItemType' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter',
			'options' => Array (1 => 'la_Product', 2 => 'la_Category', 0 => 'la_WholeOrder'), 'use_phrases' => 1,
			'not_null' => 1, 'default' => 1
		),
	),

	'VirtualFields' => Array (
		'ProductId' => Array ('type' => 'int', 'default' => 0),
		'ItemName' => Array ('type' => 'string', 'default' => ''),
		'SKU' => Array ('type' => 'string', 'default' => ''),
		'Weight' => Array (
			'type' => 'float',
			'formatter' => 'kFormatter', 'format' => '%0.2f',
			'min_value_exc' => 0, 'default' => NULL,
		),
		'CreatedOn' => Array (
			'type' => 'int',
			'formatter' => 'kDateFormatter',
			'default' => '#NOW#',
		),
		'BackOrderDate' => Array (
			'type' => 'int',
			'formatter' => 'kDateFormatter',
			'default' => NULL,
		),
		'Status' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter',
			'options' => Array (1 => 'la_Active', 2 => 'la_Pending', 0 => 'la_Disabled'), 'use_phrases' => 1,
			'default' => 2,
		),
		'CategoryId' => Array ('type' => 'int', 'default' => 0),
	),

	'Grids' => Array (
		'Default' => Array (
			'Icons' => Array ('default' => 'icon16_entire_order.gif'),
			'Fields' => Array (
				'ItemType' => Array ( 'title' => 'la_col_ItemType', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_empty_filter', 'width' => 200, ),
			),
		),
		'CouponItems' => Array (
			'Icons' => Array (
				'default' => 'icon16_product.png',
				0 => 'icon16_product_disabled.png',
				1 => 'icon16_product.png',
				2 => 'icon16_product_pending.png',
			),
			'Fields' => Array (
				'ProductId' => Array ( 'title' => 'column:la_fld_Id', 'data_block' => 'grid_item_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
				'ItemName' => Array ( 'filter_block' => 'grid_like_filter', 'width' => 250, ),
				'ItemType' => Array ( 'title' => 'la_col_CouponItemType', 'filter_block' => 'grid_options_filter', 'width' => 150, ),
			),
		),
	),
);