<?php
/**
* @version	$Id: affiliates_tag_processor.php 15960 2013-08-29 14:54:10Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class AffiliatesTagProcessor extends kDBTagProcessor {

		/**
		 * Returns link to be placed on other sites
		 *
		 * @param Array $params
		 * @return string
		 */
		function GetAffiliateLink($params)
		{
			$object = $this->getObject($params);
			/* @var $object kDBItem */

			$params['affiliate'] = $object->GetDBField('AffiliateCode');
			$params['prefix'] = '_FRONT_END_';
			$params['index_file'] = 'index.php';

			// to build non-SSL link without SID in case, when SSL is enabled (or SSL domain doesn't match non-SSL domain)
			$params['__SSL__'] = 0;
			$params['__NO_SID__'] = 1;

			$link = $this->Application->ProcessParsedTag('m', 'Link', $params);

			// remove env manually
			return preg_replace('/(.*)\/index.php\?env=(.*?)&amp;(.*)/', '\\1/index.php?\\3', $link);
		}

		/**
		 * Returns link to be placed on other sites (for current user)
		 *
		 * @param Array $params
		 * @return string
		 */
		function GetUserAffiliateLink($params)
		{
			$object = $this->getObject(kUtil::array_merge_recursive($params, array('skip_autoload' => true)));
			/* @var $object kDBItem */

			$object->Load(array('PortalUserId' => $this->Application->RecallVar('user_id')));

			$params['index_file'] = 'index.php';
			$params['affiliate'] = $object->GetDBField('AffiliateCode');

			// to build non-SSL link without SID in case, when SSL is enabled (or SSL domain doesn't match non-SSL domain)
			$params['__SSL__'] = 0;
			$params['__NO_SID__'] = 1;

			$link = $this->Application->ProcessParsedTag('m', 'Link', $params);

			// remove env manually
			return preg_replace('/(.*)\/index.php\?env=(.*?)&amp;(.*)/', '\\1/index.php?\\3', $link);
		}

		/**
		 * [Aggregated Tag] Returns true if user is affiliate
		 *
		 * @param Array $params
		 * @return bool
		 * @access protected
		 */
		protected function User_IsAffiliate($params)
		{
			$object = $this->Application->recallObject($this->Prefix . '.user');
			/* @var $object kDBItem */

			return $object->isLoaded();
		}

		/**
		 * [Aggregated Tag] Checks, that affiliate record for current user exists and is active
		 *
		 * @param $params
		 * @return bool
		 * @access protected
		 */
		protected function User_AffiliateIsActive($params)
		{
			$object = $this->Application->recallObject($this->Prefix . '.user');
			/* @var $object kDBItem */

			return $object->isLoaded() && ($object->GetDBField('Status') == STATUS_ACTIVE);
		}

		/**
		 * Returns url for editing user from current record
		 *
		 * @param Array $params
		 * @return string
		 */
		function UserLink($params)
		{
			$object = $this->getObject($params);
			/* @var $object kDBItem */

			$user_id = $object->GetDBField('PortalUserId');

			if ( !$user_id ) {
				return '';
			}

			$url_params =  Array (
				'm_opener' => 'd',
				'u_mode' => 't',
				'u_event' => 'OnEdit',
				'u_id' => $user_id,
				'pass' => 'all,u'
			);

			return $this->Application->HREF($params['edit_template'], '', $url_params);
		}

		function CurrentUserAffiliateField($params)
		{
			return $this->Application->ProcessParsedTag($this->Prefix . '.user', 'Field', $params);
		}

		function IsAffiliateOrRegisterAsAffiliateAllowed($params)
		{
			$object = $this->Application->recallObject($this->Prefix . '.user');
			/* @var $object kDBItem */

			return $this->Application->ConfigValue('Comm_RegisterAsAffiliate') || $object->isLoaded() ? 1 : 0;
		}

		/**
		 * [AGGREGATED TAG] Checks if affiliate registration is allowed
		 *
		 * @param Array $params
		 * @return int
		 */
		function AllowAffiliateRegistration($params)
		{
			return $this->Application->ConfigValue('Comm_RegisterAsAffiliate') ? 1 : 0;
		}

		function Main_RequireAffiliate($params)
		{
			$t = $params['registration_template'];

			if ( !$this->User_IsAffiliate($params) ) {
				$redirect_params = Array ('next_template' => $this->Application->GetVar('t'));
				$this->Application->Redirect($t, $redirect_params);
			}
		}

		/**
		 * Calls OnNew event from template, when no other event submitted
		 *
		 * @param Array $params
		 */
		function PresetFormFields($params)
		{
			$prefix = $this->getPrefixSpecial();

			if ( !$this->Application->GetVar($prefix . '_event') && !$this->Application->GetVar('u.register_event') ) {
				$this->Application->HandleEvent(new kEvent($prefix . ':OnNew'));
			}
		}
	}