CREATE TABLE Addresses (
  AddressId int(11) NOT NULL auto_increment,
  PortalUserId int(11) NOT NULL default '0',
  `To` varchar(255) NOT NULL default '',
  Company varchar(255) NOT NULL default '',
  Phone varchar(255) NOT NULL default '',
  Fax varchar(255) NOT NULL default '',
  Email varchar(255) NOT NULL default '',
  Address1 varchar(255) NOT NULL default '',
  Address2 varchar(255) NOT NULL default '',
  City varchar(255) NOT NULL default '',
  State char(2) NOT NULL default '',
  Zip varchar(20) NOT NULL default '',
  Country char(3) NOT NULL default '',
  LastUsedAsBilling tinyint(4) unsigned NOT NULL default '0',
  LastUsedAsShipping tinyint(4) unsigned NOT NULL default '0',
  IsProfileAddress tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (AddressId),
  KEY PortalUserId (PortalUserId),
  KEY LastUsedAsBilling (LastUsedAsBilling),
  KEY LastUsedAsShipping (LastUsedAsShipping),
  KEY IsProfileAddress (IsProfileAddress)
);

CREATE TABLE Currencies (
  CurrencyId int(11) NOT NULL AUTO_INCREMENT,
  ISO char(3) NOT NULL DEFAULT '',
  Symbol varchar(255) DEFAULT NULL,
  SymbolPosition tinyint(4) DEFAULT NULL,
  `Name` varchar(255) NOT NULL DEFAULT '',
  RateToPrimary double NOT NULL DEFAULT '1',
  Modified int(11) DEFAULT NULL,
  `Status` smallint(6) NOT NULL DEFAULT '1',
  IsPrimary smallint(6) NOT NULL DEFAULT '0',
  Priority int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (CurrencyId),
  KEY Priority (Priority),
  KEY IsPrimary (IsPrimary),
  KEY Modified (Modified)
);

CREATE TABLE GatewayConfigFields (
  GWConfigFieldId int(11) NOT NULL AUTO_INCREMENT,
  SystemFieldName varchar(50) NOT NULL DEFAULT '',
  FieldName varchar(100) NOT NULL DEFAULT '',
  ElementType varchar(30) NOT NULL DEFAULT 'text',
  ValueList mediumtext,
  GatewayId int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (GWConfigFieldId),
  KEY GatewayId (GatewayId)
);

CREATE TABLE GatewayConfigValues (
  GWConfigValueId int(11) NOT NULL auto_increment,
  GWConfigFieldId int(11) NOT NULL default '0',
  PaymentTypeId int(11) NOT NULL default '0',
  Value varchar(255) default NULL,
  PRIMARY KEY  (GWConfigValueId),
  KEY GWConfigFieldId (GWConfigFieldId),
  KEY PaymentTypeId (PaymentTypeId)
);

CREATE TABLE Gateways (
  GatewayId int(11) NOT NULL auto_increment,
  Name varchar(100) NOT NULL default '',
  ClassName varchar(150) NOT NULL default '',
  ClassFile varchar(255) NOT NULL default '',
  RequireCCFields tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (GatewayId)
);

CREATE TABLE Manufacturers (
  ManufacturerId int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) NOT NULL DEFAULT '',
  Description text,
  URL varchar(255) NOT NULL DEFAULT '',
  Logo varchar(255) NOT NULL DEFAULT '',
  IsPopular int(10) unsigned NOT NULL DEFAULT '0',
  Address1 varchar(255) DEFAULT NULL,
  Address2 varchar(255) DEFAULT NULL,
  City varchar(255) DEFAULT NULL,
  State varchar(50) DEFAULT NULL,
  Zip varchar(50) DEFAULT NULL,
  Country varchar(255) DEFAULT NULL,
  Phone varchar(50) DEFAULT NULL,
  Fax varchar(50) DEFAULT NULL,
  Email varchar(255) DEFAULT NULL,
  PRIMARY KEY (ManufacturerId)
);

CREATE TABLE OrderItems (
  OrderItemId int(11) NOT NULL AUTO_INCREMENT,
  OrderId int(11) NOT NULL DEFAULT '0',
  ProductId int(11) NOT NULL DEFAULT '0',
  ProductName varchar(255) NOT NULL DEFAULT '',
  Quantity int(11) NOT NULL DEFAULT '0',
  QuantityReserved int(11) DEFAULT NULL,
  FlatPrice decimal(10,4) NOT NULL DEFAULT '0.0000',
  Price decimal(10,4) NOT NULL DEFAULT '0.0000',
  Cost double(10,4) NOT NULL DEFAULT '0.0000',
  BackOrderFlag tinyint(4) DEFAULT '0',
  Weight double DEFAULT NULL,
  ShippingTypeId varchar(255) DEFAULT NULL,
  ItemData text,
  OptionsSalt bigint(11) DEFAULT '0',
  SplitShippingGroup int(11) NOT NULL DEFAULT '0',
  PackageNum int(11) NOT NULL DEFAULT '0',
  ReturnType tinyint(3) unsigned NOT NULL DEFAULT '0',
  ReturnAmount decimal(10,2) NOT NULL DEFAULT '0.00',
  ReturnedOn int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (OrderItemId),
  KEY OrderId (OrderId),
  KEY ProductId (ProductId),
  KEY BackOrderFlag (BackOrderFlag),
  KEY PackageNum (PackageNum),
  KEY ReturnType (ReturnType),
  KEY ReturnedOn (ReturnedOn),
  KEY Quantity (Quantity),
  KEY QuantityReserved (QuantityReserved),
  KEY OptionsSalt (OptionsSalt),
  KEY SplitShippingGroup (SplitShippingGroup)
);

CREATE TABLE Orders (
  OrderId int(11) NOT NULL AUTO_INCREMENT,
  Number mediumint(9) NOT NULL DEFAULT '0',
  SubNumber smallint(6) NOT NULL DEFAULT '0',
  `Status` tinyint(3) unsigned NOT NULL DEFAULT '0',
  OnHold tinyint(3) unsigned NOT NULL DEFAULT '0',
  OrderDate int(10) unsigned DEFAULT NULL,
  PortalUserId int(11) NOT NULL DEFAULT '-1',
  OrderIP varchar(30) NOT NULL DEFAULT '',
  UserComment text,
  AdminComment text,
  BillingTo varchar(255) NOT NULL DEFAULT '',
  BillingCompany varchar(255) NOT NULL DEFAULT '',
  BillingPhone varchar(255) NOT NULL DEFAULT '',
  BillingFax varchar(255) NOT NULL DEFAULT '',
  BillingEmail varchar(255) NOT NULL DEFAULT '',
  BillingAddress1 varchar(255) NOT NULL DEFAULT '',
  BillingAddress2 varchar(255) NOT NULL DEFAULT '',
  BillingCity varchar(255) NOT NULL DEFAULT '',
  BillingState varchar(255) NOT NULL DEFAULT '',
  BillingZip varchar(255) NOT NULL DEFAULT '',
  BillingCountry varchar(255) NOT NULL DEFAULT 'USA',
  VAT decimal(20,4) NOT NULL DEFAULT '0.0000',
  VATPercent decimal(20,4) NOT NULL DEFAULT '0.0000',
  PaymentType tinyint(3) unsigned NOT NULL DEFAULT '0',
  PaymentAccount varchar(255) NOT NULL DEFAULT '',
  PaymentExpires int(10) unsigned DEFAULT NULL,
  PaymentNameOnCard varchar(255) NOT NULL DEFAULT '',
  PaymentCCExpDate varchar(5) NOT NULL DEFAULT '',
  PaymentCardType varchar(255) NOT NULL DEFAULT '',
  ShippingTo varchar(255) NOT NULL DEFAULT '',
  ShippingCompany varchar(255) NOT NULL DEFAULT '',
  ShippingPhone varchar(255) NOT NULL DEFAULT '',
  ShippingFax varchar(255) NOT NULL DEFAULT '',
  ShippingEmail varchar(255) NOT NULL DEFAULT '',
  ShippingAddress1 varchar(255) NOT NULL DEFAULT '',
  ShippingAddress2 varchar(255) NOT NULL DEFAULT '',
  ShippingCity varchar(255) NOT NULL DEFAULT '',
  ShippingState varchar(255) NOT NULL DEFAULT '',
  ShippingZip varchar(255) NOT NULL DEFAULT '',
  ShippingCountry varchar(255) NOT NULL DEFAULT 'USA',
  ShippingType int(11) NOT NULL DEFAULT '0',
  ShippingCost decimal(20,4) NOT NULL DEFAULT '0.0000',
  ShippingCustomerAccount varchar(255) NOT NULL DEFAULT '',
  ShippingTracking varchar(255) NOT NULL DEFAULT '',
  ShippingDate int(11) DEFAULT NULL,
  SubTotal decimal(20,4) unsigned NOT NULL DEFAULT '0.0000',
  ReturnTotal decimal(20,4) NOT NULL DEFAULT '0.0000',
  CostTotal decimal(20,4) NOT NULL DEFAULT '0.0000',
  OriginalAmount decimal(20,4) NOT NULL DEFAULT '0.0000',
  ShippingOption tinyint(4) NOT NULL DEFAULT '0',
  ShippingInfo text,
  CouponId int(11) DEFAULT NULL,
  CouponDiscount decimal(20,4) NOT NULL DEFAULT '0.0000',
  DiscountTotal decimal(10,4) NOT NULL DEFAULT '0.0000',
  TransactionStatus tinyint(3) unsigned NOT NULL DEFAULT '2',
  GWResult1 mediumtext,
  GWResult2 mediumtext,
  AffiliateId int(10) unsigned NOT NULL DEFAULT '0',
  VisitId int(10) unsigned NOT NULL DEFAULT '0',
  AffiliateCommission decimal(10,4) NOT NULL DEFAULT '0.0000',
  ProcessingFee decimal(20,4) DEFAULT '0.0000',
  InsuranceFee decimal(20,4) NOT NULL DEFAULT '0.0000',
  ShippingTaxable tinyint(1) NOT NULL DEFAULT '0',
  ProcessingTaxable tinyint(1) NOT NULL DEFAULT '0',
  IsRecurringBilling tinyint(4) NOT NULL DEFAULT '0',
  NextCharge int(10) unsigned DEFAULT NULL,
  GroupId int(10) unsigned NOT NULL DEFAULT '0',
  ChargeOnNextApprove tinyint(4) NOT NULL DEFAULT '0',
  ShippingGroupOption tinyint(4) NOT NULL DEFAULT '0',
  GiftCertificateId int(11) DEFAULT NULL,
  GiftCertificateDiscount decimal(20,4) NOT NULL DEFAULT '0.0000',
  GoogleOrderNumber bigint(20) unsigned DEFAULT NULL,
  VATIncluded tinyint(1) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (OrderId),
  KEY AffiliateId (AffiliateId),
  KEY VisitId (VisitId),
  KEY GoogleOrderNumber (GoogleOrderNumber),
  KEY Number (Number),
  KEY SubNumber (SubNumber),
  KEY `Status` (`Status`),
  KEY OrderDate (OrderDate),
  KEY PaymentType (PaymentType),
  KEY CouponId (CouponId),
  KEY GroupId (GroupId),
  KEY GiftCertificateId (GiftCertificateId)
);

CREATE TABLE GiftCertificates (
  GiftCertificateId int(11) NOT NULL AUTO_INCREMENT,
  OrderId int(11) DEFAULT '0',
  Purchaser varchar(64) DEFAULT NULL,
  Recipient varchar(64) DEFAULT NULL,
  SendVia tinyint(1) NOT NULL DEFAULT '0',
  RecipientEmail varchar(64) NOT NULL DEFAULT '',
  RecipientFirstname varchar(128) DEFAULT NULL,
  RecipientLastname varchar(128) DEFAULT NULL,
  RecipientAddress1 varchar(255) DEFAULT NULL,
  RecipientAddress2 varchar(255) DEFAULT NULL,
  RecipientCity varchar(64) DEFAULT NULL,
  RecipientState varchar(32) DEFAULT NULL,
  RecipientZipcode varchar(32) DEFAULT NULL,
  RecipientCountry char(3) NOT NULL DEFAULT 'USA',
  RecipientPhone varchar(32) DEFAULT NULL,
  Message text,
  Amount decimal(12,2) DEFAULT '0.00',
  Debit decimal(12,2) DEFAULT '0.00',
  `Status` tinyint(1) NOT NULL DEFAULT '2',
  AddDate int(11) DEFAULT '0',
  Expiration int(11) DEFAULT NULL,
  `Code` varchar(255) DEFAULT NULL,
  PRIMARY KEY (GiftCertificateId),
  UNIQUE KEY `Code` (`Code`),
  KEY OrderId (OrderId),
  KEY `Status` (`Status`),
  KEY AddDate (AddDate)
);

CREATE TABLE PaymentTypeCurrencies (
  PaymentTypeCurrencyId int(11) NOT NULL auto_increment,
  PaymentTypeId int(11) NOT NULL default '0',
  CurrencyId int(11) NOT NULL default '0',
  PRIMARY KEY  (PaymentTypeCurrencyId),
  KEY PaymentTypeId (PaymentTypeId),
  KEY CurrencyId (CurrencyId)
);

CREATE TABLE PaymentTypes (
  PaymentTypeId int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(100) NOT NULL DEFAULT '',
  l1_Description varchar(255) DEFAULT '',
  l2_Description varchar(255) DEFAULT '',
  l3_Description varchar(255) DEFAULT '',
  l4_Description varchar(255) DEFAULT '',
  l5_Description varchar(255) DEFAULT '',
  l1_Instructions text,
  l2_Instructions text,
  l3_Instructions text,
  l4_Instructions text,
  l5_Instructions text,
  AdminComments text,
  `Status` int(11) NOT NULL DEFAULT '0',
  Priority int(11) NOT NULL DEFAULT '0',
  IsPrimary tinyint(4) NOT NULL DEFAULT '0',
  BuiltIn smallint(6) NOT NULL DEFAULT '0',
  GatewayId int(11) NOT NULL DEFAULT '1',
  PlacedOrdersEdit tinyint(4) NOT NULL DEFAULT '0',
  ProcessingFee double NOT NULL DEFAULT '0',
  PortalGroups text,
  PRIMARY KEY (PaymentTypeId),
  KEY `Status` (`Status`),
  KEY Priority (Priority),
  KEY GatewayId (GatewayId),
  KEY BuiltIn (BuiltIn),
  KEY IsPrimary (IsPrimary),
  KEY l1_Description (l1_Description(5)),
  KEY l2_Description (l2_Description(5)),
  KEY l3_Description (l3_Description(5)),
  KEY l4_Description (l4_Description(5)),
  KEY l5_Description (l5_Description(5)),
  KEY l1_Instructions (l1_Instructions(5)),
  KEY l2_Instructions (l2_Instructions(5)),
  KEY l3_Instructions (l3_Instructions(5)),
  KEY l4_Instructions (l4_Instructions(5)),
  KEY l5_Instructions (l5_Instructions(5))
);

CREATE TABLE Products (
  ProductId int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) DEFAULT '',
  l1_Name varchar(255) DEFAULT NULL,
  l2_Name varchar(255) DEFAULT NULL,
  l3_Name varchar(255) DEFAULT NULL,
  l4_Name varchar(255) DEFAULT NULL,
  l5_Name varchar(255) DEFAULT NULL,
  AutomaticFilename tinyint(3) unsigned NOT NULL DEFAULT '1',
  SKU varchar(255) DEFAULT NULL,
  `Type` tinyint(2) unsigned NOT NULL DEFAULT '1',
  Description text,
  l1_Description text,
  l2_Description text,
  l3_Description text,
  l4_Description text,
  l5_Description text,
  DescriptionExcerpt text,
  l1_DescriptionExcerpt text,
  l2_DescriptionExcerpt text,
  l3_DescriptionExcerpt text,
  l4_DescriptionExcerpt text,
  l5_DescriptionExcerpt text,
  Weight double(10,4) DEFAULT NULL,
  ManufacturerId int(11) NOT NULL DEFAULT '0',
  MSRP double DEFAULT NULL,
  BackOrder tinyint(3) unsigned NOT NULL DEFAULT '2',
  BackOrderDate int(11) DEFAULT NULL,
  CreatedOn int(10) unsigned DEFAULT NULL,
  Modified int(10) unsigned DEFAULT NULL,
  Expire int(10) unsigned DEFAULT NULL,
  Hits double NOT NULL DEFAULT '0',
  CachedRating varchar(10) NOT NULL DEFAULT '0',
  CachedVotesQty int(11) NOT NULL DEFAULT '0',
  CachedReviewsQty int(11) NOT NULL DEFAULT '0',
  CreatedById int(11) DEFAULT NULL,
  ModifiedById int(11) DEFAULT NULL,
  Priority int(11) NOT NULL DEFAULT '0',
  `Status` tinyint(4) NOT NULL DEFAULT '2',
  EditorsPick tinyint(4) NOT NULL DEFAULT '0',
  Featured tinyint(4) NOT NULL DEFAULT '0',
  OnSale tinyint(1) NOT NULL DEFAULT '0',
  ResourceId int(11) DEFAULT NULL,
  HotItem tinyint(4) NOT NULL DEFAULT '2',
  PopItem tinyint(4) NOT NULL DEFAULT '2',
  NewItem tinyint(4) NOT NULL DEFAULT '2',
  InventoryStatus tinyint(4) NOT NULL DEFAULT '0',
  QtyInStock int(11) NOT NULL DEFAULT '0',
  QtyInStockMin int(11) NOT NULL DEFAULT '0',
  QtyReserved int(11) NOT NULL DEFAULT '0',
  QtyBackOrdered int(11) NOT NULL DEFAULT '0',
  QtyOnOrder int(11) NOT NULL DEFAULT '0',
  InventoryComment text,
  AccessGroupId int(11) DEFAULT NULL,
  AccessDuration int(11) DEFAULT NULL,
  AccessDurationType tinyint(4) DEFAULT NULL,
  AccessStart int(11) DEFAULT NULL,
  AccessEnd int(11) DEFAULT NULL,
  Virtual tinyint(4) NOT NULL DEFAULT '0',
  ProcessingData text,
  PackageContent mediumtext,
  OptionsSelectionMode tinyint(4) DEFAULT '0',
  HasRequiredOptions tinyint(1) NOT NULL DEFAULT '0',
  IsRecurringBilling tinyint(3) unsigned NOT NULL DEFAULT '0',
  ShippingMode tinyint(1) NOT NULL DEFAULT '0',
  ShippingLimitation text,
  AssignedCoupon int(11) NOT NULL DEFAULT '0',
  MinQtyFreePromoShipping int(11) NOT NULL DEFAULT '0',
  MetaKeywords varchar(255) DEFAULT NULL,
  MetaDescription text,
  PRIMARY KEY (ProductId),
  KEY ResourceId (ResourceId),
  KEY Hits (Hits),
  KEY `Name` (`Name`),
  KEY EditorsPick (EditorsPick),
  KEY CreatedOn (CreatedOn),
  KEY Modified (Modified,CreatedOn),
  KEY `Status` (`Status`),
  KEY l1_Name (l1_Name),
  KEY Priority (Priority),
  KEY ManufacturerId (ManufacturerId),
  KEY NewItem (NewItem),
  KEY PopItem (PopItem),
  KEY HotItem (HotItem),
  KEY Featured (Featured),
  KEY OnSale (OnSale),
  KEY Expire (Expire),
  KEY Virtual (Virtual),
  KEY AccessGroupId (AccessGroupId)
);

CREATE TABLE ProductsCouponItems (
  CouponItemId int(11) NOT NULL auto_increment,
  CouponId int(11) default NULL,
  ItemResourceId int(11) default NULL,
  ItemType TINYINT(4) NOT NULL DEFAULT '1',
  PRIMARY KEY  (CouponItemId),
  KEY DiscountId (CouponId),
  KEY ItemResourceId (ItemResourceId),
  KEY ItemType (ItemType)
);

CREATE TABLE ProductsCoupons (
  CouponId int(11) NOT NULL auto_increment,
  `Status` tinyint(4) NOT NULL default '1',
  Name varchar(255) default NULL,
  Code varchar(255) default NULL,
  Expiration int(11) default NULL,
  GroupId int(11) default NULL,
  `Type` tinyint(1) NOT NULL default '1',
  Amount double default NULL,
  LastUsedBy int(11) default NULL,
  LastUsedOn int(11) default NULL,
  NumberOfUses int(11) default '1',
  PRIMARY KEY  (CouponId),
  KEY `Status` (`Status`),
  KEY Code (Code)
);

CREATE TABLE ProductsDiscountItems (
  DiscountItemId int(11) NOT NULL auto_increment,
  DiscountId int(11) default NULL,
  ItemResourceId int(11) default NULL,
  ItemType TINYINT(4) NOT NULL DEFAULT '1',
  PRIMARY KEY  (DiscountItemId),
  KEY DiscountId (DiscountId),
  KEY ItemResourceId (ItemResourceId),
  KEY ItemType (ItemType)
);

CREATE TABLE ProductsDiscounts (
  DiscountId int(11) NOT NULL auto_increment,
  `Status` tinyint(4) default '2',
  `Name` varchar(255) default NULL,
  `Start` int(11) default NULL,
  `End` int(11) default NULL,
  GroupId int(11) default NULL,
  `Type` tinyint(1) default '1',
  Amount double default NULL,
  PRIMARY KEY  (DiscountId),
  KEY `Status` (`Status`)
);

CREATE TABLE ProductsPricing (
  PriceId int(11) NOT NULL auto_increment,
  ProductId int(11) NOT NULL default '0',
  MinQty int(11) default NULL,
  MaxQty int(11) default NULL,
  Cost decimal(10,4) default NULL,
  Price decimal(10,4) NOT NULL default '0.0000',
  Negotiated tinyint(1) default NULL,
  Points int(11) default NULL,
  AccessDuration int(11) NOT NULL default '0',
  AccessUnit int(11) NOT NULL default '0',
  Description varchar(255) default NULL,
  IsPrimary tinyint(4) NOT NULL default '0',
  GroupId int(11) NOT NULL default '0',
  PRIMARY KEY  (PriceId),
  KEY ProductId (ProductId),
  KEY GroupId (GroupId),
  KEY IsPrimary (IsPrimary)
);

CREATE TABLE ProductFiles (
  FileId int(11) NOT NULL AUTO_INCREMENT,
  ProductId int(11) NOT NULL DEFAULT '0',
  `Name` varchar(255) NOT NULL DEFAULT '',
  Version varchar(100) NOT NULL DEFAULT '',
  FilePath varchar(255) NOT NULL DEFAULT '',
  RealPath varchar(255) NOT NULL DEFAULT '',
  Size int(11) NOT NULL DEFAULT '0',
  `Status` tinyint(4) NOT NULL DEFAULT '0',
  IsPrimary tinyint(4) NOT NULL DEFAULT '0',
  Priority smallint(6) NOT NULL DEFAULT '0',
  AddedOn int(11) DEFAULT NULL,
  AddedById int(11) DEFAULT NULL,
  MIMEType varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (FileId),
  KEY ProductId (ProductId),
  KEY `Status` (`Status`),
  KEY IsPrimary (IsPrimary),
  KEY Priority (Priority),
  KEY AddedOn (AddedOn)
);

CREATE TABLE UserFileAccess (
  FileAccessId int(11) NOT NULL AUTO_INCREMENT,
  ProductId int(11) NOT NULL DEFAULT '0',
  PortalUserId int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (FileAccessId),
  KEY ProductId (ProductId),
  KEY PortalUserId (PortalUserId)
);

CREATE TABLE UserDownloads (
  DownloadId int(11) NOT NULL AUTO_INCREMENT,
  PortalUserId int(11) NOT NULL DEFAULT '0',
  Username varchar(255) NOT NULL DEFAULT '',
  ProductId int(11) NOT NULL DEFAULT '0',
  ProductName varchar(255) NOT NULL DEFAULT '',
  FileId int(11) NOT NULL DEFAULT '0',
  Filename varchar(255) NOT NULL DEFAULT '',
  IPAddress varchar(100) NOT NULL DEFAULT '',
  StartedOn int(11) DEFAULT NULL,
  EndedOn int(11) DEFAULT NULL,
  PRIMARY KEY (DownloadId),
  KEY PortalUserId (PortalUserId),
  KEY ProductId (ProductId)
);

CREATE TABLE ShippingBrackets (
  BracketId int(11) NOT NULL auto_increment,
  ShippingTypeID int(11) NOT NULL default '0',
  Start double NOT NULL default '0',
  End double NOT NULL default '0',
  PRIMARY KEY  (BracketId),
  KEY ShippingTypeID (ShippingTypeID),
  KEY Start (Start),
  KEY End (End)
);

CREATE TABLE ShippingCosts (
  ShippingCostId int(11) NOT NULL auto_increment,
  ZoneID int(11) NOT NULL default '0',
  BracketId int(11) NOT NULL default '0',
  Flat decimal(10,4) default NULL,
  PerUnit decimal(10,4) default NULL,
  PRIMARY KEY  (ShippingCostId),
  KEY ZoneID (ZoneID),
  KEY BracketId (BracketId)
);

CREATE TABLE ShippingQuoteEngines (
  EngineId int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) NOT NULL DEFAULT '',
  FlatSurcharge double NOT NULL DEFAULT '0',
  PercentSurcharge double NOT NULL DEFAULT '0',
  `Status` smallint(6) NOT NULL DEFAULT '0',
  Properties text,
  ClassName varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (EngineId),
  KEY `Status` (`Status`)
);

CREATE TABLE ShippingType (
  ShippingID int(11) NOT NULL AUTO_INCREMENT,
  `Code` varchar(25) NOT NULL DEFAULT '',
  `Name` varchar(100) NOT NULL DEFAULT '',
  SpeedCode varchar(25) NOT NULL DEFAULT '',
  LocationFrom int(11) NOT NULL DEFAULT '1',
  `Type` int(11) NOT NULL DEFAULT '1',
  BaseFee double NOT NULL DEFAULT '0',
  CODFlatSurcharge double NOT NULL DEFAULT '0',
  CODPercentSurcharge double NOT NULL DEFAULT '0',
  `Status` tinyint(4) NOT NULL DEFAULT '1',
  CostType tinyint(4) NOT NULL DEFAULT '1',
  ZeroIfEmpty tinyint(4) NOT NULL DEFAULT '1',
  PrecisionBeforeSep tinyint(4) NOT NULL DEFAULT '2',
  PrecisionAfterSep tinyint(4) NOT NULL DEFAULT '2',
  PortalGroups text,
  FreeShippingMinAmount double(10,4) NOT NULL DEFAULT '0.0000',
  IsFreePromoShipping tinyint(1) NOT NULL DEFAULT '0',
  InsuranceFee decimal(10,2) DEFAULT NULL,
  InsuranceType tinyint(1) NOT NULL DEFAULT '2',
  PRIMARY KEY (ShippingID),
  KEY `Type` (`Type`),
  KEY `Status` (`Status`)
);

CREATE TABLE ShippingZones (
  ZoneID int(11) NOT NULL auto_increment,
  ShippingTypeID int(11) NOT NULL default '0',
  Name varchar(100) NOT NULL default '',
  Type int(11) NOT NULL default '1',
  CODallowed smallint(6) NOT NULL default '1',
  PRIMARY KEY  (ZoneID),
  KEY ShippingTypeID (ShippingTypeID),
  KEY `Type` (`Type`)
);

CREATE TABLE ShippingZonesDestinations (
  ZoneDestId int(11) NOT NULL auto_increment,
  ShippingZoneId int(11) NOT NULL default '0',
  StdDestId int(11) default '0',
  DestValue varchar(255) default NULL,
  PRIMARY KEY  (ZoneDestId),
  KEY ShippingZoneId (ShippingZoneId),
  KEY StdDestId (StdDestId)
);

CREATE TABLE TaxZones (
  TaxZoneId int(11) NOT NULL auto_increment,
  Name varchar(100) NOT NULL default '',
  Type int(11) NOT NULL default '1',
  TaxValue double NOT NULL default '0',
  ApplyToShipping TINYINT( 1 ) NOT NULL DEFAULT '0',
  ApplyToProcessing TINYINT( 1 ) NOT NULL DEFAULT '0',
  PRIMARY KEY  (TaxZoneId)
);

CREATE TABLE TaxZonesDestinations (
  TaxZoneDestId int(11) NOT NULL auto_increment,
  TaxZoneId int(11) NOT NULL default '0',
  StdDestId int(11) default '0',
  DestValue varchar(255) default NULL,
  PRIMARY KEY  (TaxZoneDestId),
  KEY TaxZoneId (TaxZoneId),
  KEY StdDestId (StdDestId)
);

CREATE TABLE AffiliatePayments (
  AffiliatePaymentId int(11) NOT NULL AUTO_INCREMENT,
  AffiliateId int(10) unsigned NOT NULL DEFAULT '0',
  PaymentDate int(10) unsigned DEFAULT NULL,
  Amount decimal(10,2) NOT NULL DEFAULT '0.00',
  `Comment` text,
  PaymentReference varchar(255) NOT NULL DEFAULT '',
  PaymentTypeId int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (AffiliatePaymentId),
  KEY AffiliateId (AffiliateId),
  KEY PaymentDate (PaymentDate),
  KEY PaymentTypeId (PaymentTypeId)
);

CREATE TABLE AffiliatePaymentTypes (
  PaymentTypeId int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(255) NOT NULL DEFAULT '',
  Description text,
  IsPrimary tinyint(4) NOT NULL DEFAULT '0',
  `Status` tinyint(4) NOT NULL DEFAULT '0',
  Priority tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (PaymentTypeId),
  KEY IsPrimary (IsPrimary),
  KEY `Status` (`Status`),
  KEY Priority (Priority)
);

CREATE TABLE AffiliatePlans (
  AffiliatePlanId int(11) NOT NULL auto_increment,
  Name varchar(255) NOT NULL default '',
  PlanType tinyint(3) unsigned NOT NULL default '1',
  ResetInterval int(10) unsigned NOT NULL default '0',
  PaymentType tinyint(4) NOT NULL default '0',
  MinPaymentAmount varchar(255) NOT NULL default '',
  Enabled tinyint(4) unsigned NOT NULL default '0',
  IsPrimary tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (AffiliatePlanId),
  KEY PaymentType (PaymentType),
  KEY Enabled (Enabled),
  KEY IsPrimary (IsPrimary)
);

CREATE TABLE AffiliatePlansBrackets (
  AffiliateBracketId int(11) NOT NULL auto_increment,
  AffiliatePlanId int(11) NOT NULL default '0',
  FromAmount decimal(10,4) NOT NULL default '0.0000',
  ToAmount decimal(10,4) NOT NULL default '0.0000',
  Percent decimal(10,2) NOT NULL default '0.00',
  PRIMARY KEY  (AffiliateBracketId),
  KEY AffiliatePlanId (AffiliatePlanId)
);

CREATE TABLE AffiliatePlansItems (
  AffiliateItemId int(11) NOT NULL auto_increment,
  AffiliatePlanId int(11) NOT NULL default '0',
  ItemResourceId int(10) unsigned NOT NULL default '0',
  ItemType tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (AffiliateItemId),
  KEY AffiliatePlanId (AffiliatePlanId),
  KEY ItemResourceId (ItemResourceId),
  KEY ItemType (ItemType)
);

CREATE TABLE Affiliates (
  AffiliateId int(11) NOT NULL AUTO_INCREMENT,
  PortalUserId int(10) DEFAULT NULL,
  AffiliatePlanId int(10) unsigned NOT NULL DEFAULT '0',
  AccumulatedAmount decimal(10,2) NOT NULL DEFAULT '0.00',
  AmountToPay decimal(10,2) NOT NULL DEFAULT '0.00',
  LastPaymentDate int(11) unsigned DEFAULT NULL,
  LastOrderDate int(11) unsigned DEFAULT NULL,
  `Status` tinyint(4) NOT NULL DEFAULT '2',
  AffiliateCode varchar(30) NOT NULL DEFAULT '',
  ItemsSold int(10) unsigned NOT NULL DEFAULT '0',
  PaymentTypeId int(11) NOT NULL DEFAULT '0',
  SSN varchar(100) NOT NULL DEFAULT '',
  Comments text,
  CreatedOn int(11) DEFAULT NULL,
  PRIMARY KEY (AffiliateId),
  UNIQUE KEY AffiliateCode (AffiliateCode),
  UNIQUE KEY PortalUserId (PortalUserId),
  KEY LastOrderDate (LastOrderDate),
  KEY AffiliatePlanId (AffiliatePlanId),
  KEY `Status` (`Status`),
  KEY PaymentTypeId (PaymentTypeId),
  KEY CreatedOn (CreatedOn)
);

CREATE TABLE ProductOptionCombinations (
  CombinationId int(11) NOT NULL AUTO_INCREMENT,
  ProductId int(11) NOT NULL DEFAULT '0',
  Combination text,
  CombinationCRC bigint(11) NOT NULL DEFAULT '0',
  PriceType tinyint(1) DEFAULT '3',
  Price float DEFAULT NULL,
  WeightType tinyint(1) DEFAULT '3',
  Weight float DEFAULT NULL,
  Availability tinyint(1) NOT NULL DEFAULT '1',
  Priority int(11) NOT NULL DEFAULT '0',
  QtyInStock int(11) NOT NULL DEFAULT '0',
  QtyReserved int(11) NOT NULL DEFAULT '0',
  QtyBackOrdered int(11) NOT NULL DEFAULT '0',
  QtyOnOrder int(11) NOT NULL DEFAULT '0',
  SKU varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (CombinationId),
  KEY CombinationCRC (CombinationCRC),
  KEY ProductId (ProductId),
  KEY Availability (Availability)
);

CREATE TABLE ProductOptions (
  ProductOptionId int(11) NOT NULL auto_increment,
  ProductId int(11) NOT NULL default '0',
  Name varchar(255) NOT NULL default '',
  OptionType TINYINT(4) NOT NULL DEFAULT '0',
  Required tinyint(4) NOT NULL default '0',
  Listable tinyint(4) NOT NULL default '0',
  Priority int(11) NOT NULL default '0',
  `Values` text,
  Prices text,
  PriceTypes text,
  PRIMARY KEY  (ProductOptionId),
  KEY ProductId (ProductId,Priority),
  KEY OptionType (OptionType),
  KEY Listable (Listable)
);

CREATE TABLE ProductsCustomData (
  CustomDataId int(11) NOT NULL auto_increment,
  ResourceId int(10) unsigned NOT NULL default '0',
  KEY ResourceId (ResourceId),
  PRIMARY KEY  (CustomDataId)
);

ALTER TABLE SiteDomains
	ADD COLUMN BillingCountry varchar(3) NOT NULL DEFAULT '',
	ADD COLUMN ShippingCountry varchar(3) NOT NULL DEFAULT '',
	ADD COLUMN PrimaryCurrencyId int(11) NOT NULL DEFAULT '0',
	ADD COLUMN Currencies varchar(255) NOT NULL DEFAULT '',
	ADD COLUMN PrimaryPaymentTypeId int(11) NOT NULL DEFAULT '0',
	ADD COLUMN PaymentTypes varchar(255) NOT NULL DEFAULT '',
	ADD INDEX (BillingCountry),
	ADD INDEX (ShippingCountry),
	ADD INDEX (PrimaryCurrencyId),
	ADD INDEX (Currencies),
	ADD INDEX (PrimaryPaymentTypeId),
	ADD INDEX (PaymentTypes);