function FormManager() { }

FormManager.init = function ($settings) {
	$.ajaxSetup( {cache: false} );

	this.url = '';
	this.fieldMask = '#PREFIX#[#ID#][#FIELD_NAME#]';

	this.noErrorsHTML = '';
	this.checkTimeout = 1000;
	this.pendingChecks = {};

	this.fields = {};
	this.errors = {};
	this.fieldTypes = {};
	this.forms = {};
	this.fieldWatermarks = {};

	this.xhrRequests = [];
	this.windowScope = 'a.form-manager-window, area.form-manager-window, input.form-manager-window';
	this.windowManager = undefined;

	$.extend(this, $settings);

	if ( this.windowManager === undefined ) {
		this.windowManager = new FormManager_WindowManagerExample();
	}

	$(document).ready(function () {
		FormManager.windowManager.init(FormManager.windowScope);

		$(document).on('FormManager.WindowManager.Ready', function ($e) {
			$(FormManager.windowManager.getContentSelector()).scrollTop(0);
		});
	});
};

FormManager.resetFields = function ($prefix) {
	this.fields[$prefix] = [];
};

FormManager.registerField = function ($prefix, $field, $watermark, $field_type) {
	// fields are registered before form -> store them in separate array
	if (!this.fields[$prefix]) {
		this.fields[$prefix] = [];
	}

	if ($watermark === undefined) {
		$watermark = '';
	}

	this.fieldWatermarks[$prefix + '_' + $field] = $watermark;

	this.fields[$prefix].push($field);

	if ($field_type !== undefined) {
		this.fieldTypes[$prefix + '_' + $field] = $field_type;
	}
};

FormManager.unregisterField = function ($prefix, $field) {
	var $field_index = array_search($field, this.fields[$prefix]);

	this.fields[$prefix].splice($field_index, 1);

	delete this.fieldWatermarks[$prefix + '_' + $field];
	delete this.fieldTypes[$prefix + '_' + $field];
};

FormManager.getFieldMask = function ($prefix) {
	return this.fieldMask.replace('#PREFIX#', $prefix).replace('#ID#', this.form_param($prefix, 'id'));
};

FormManager.getField = function ($prefix, $field, $prepend, $append) {
	if ($prepend === undefined) {
		$prepend = '';
	}

	if ($append === undefined) {
		$append = '';
	}

	var $control_id = this.getFieldMask($prefix).replace('#FIELD_NAME#', $field);

	return document.getElementById($prepend + $control_id + $append);
};

FormManager.getBlurFields = function ($prefix, $field) {
	var $field_mask = this.getFieldMask($prefix);

	switch ( this.fieldTypes[$prefix + '_' + $field] ) {
		case 'swf_upload':
			return this.getField($prefix, $field, undefined, '[json]');
			break;

		case 'date':
			$field += '_date';
			break;

		case 'radio':
			return $("input[name='" + jq($field_mask.replace('#FIELD_NAME#', $field)) + "']");
			break;

		case 'checkbox':
			return get_control($field_mask, $field, undefined, '_cb');
			break;

		case 'checkboxes':
			return $("input[id^='" + jq($field_mask.replace('#FIELD_NAME#', $field)) + "_']");
			break;

		case 'cc_expiration':
			return $('select', this.getCell($prefix, $field, 'field'));
			break;
	}

	return this.getField($prefix, $field);
};

FormManager.registerForm = function ($settings) {
	var $defaults = {
		url: false,					// url for form submission
		template: '',				// template to use instead of empty string
		prefix: '',					// unit prefix, used in the form
		enabled: true,				// form submit enabled
		enabledTimer: null,			// timer that performs form-resubmit countdown
		save_event: '',				// event to use for form data processing
		id: 0,						// id of item being add/edited on a form
		form_id: '',				// form id to work with
		before_close: '',			// before window close callback
		validation_failure: '',		// on validate failure callback
		immediate_validation: true	// perform validation on blur
	};

	this.forms[$settings.prefix] = {};
	$.extend(this.forms[$settings.prefix], $defaults, $settings);

	$(document).trigger('FormManager.Form.Ready', [$settings.prefix]);

	// when form is registered, then all it's fields should also be registered

	if ( !this.form_param($settings.prefix, 'immediate_validation') ) {
		return ;
	}

	var $me = this;

	$( this.fields[$settings.prefix] ).each(
		function () {
			var $blur_fields = $( $me.getBlurFields($settings.prefix, this) ),
				$event_name = $blur_fields.length == 1 ? 'blur' : 'click';

			$blur_fields[$event_name](
				function ($e) {
					$me.checkField(this);
				}
			);
		}
	);

	for (var $error_field in this.errors[$settings.prefix]) {
		this.setFieldStatus($settings.prefix, $error_field, this.errors[$settings.prefix][$error_field]);
	}
};

FormManager.getURL = function ($prefix, $template, $event, $params) {
	var $url = this.getUrlMask($prefix);

	if ($template === undefined) {
		$template = this.form_param($prefix, 'template');
	}

	$url = $url.replace('#TEMPLATE#', $template);

	if ($event !== undefined) {
		$url += ($url.indexOf('?') == -1 ? '?' : '&') + 'events[' + $prefix + ']=' + $event;
	}

	if ( typeof($params) == 'object' ) {
		for (key in $params) {
			$url += ($url.indexOf('?') == -1 ? '?' : '&') + key + '=' + $params[key];
		}
	}

	return $url;
};

FormManager.getUrlMask = function ($prefix) {
	// 1. look in form config
	var $url = this.form_param($prefix, 'url');

	if ( !$url ) {
		// 2. look at 'action' attribute of a form
		$url = this.getForm($prefix).attr('action');
	}

	if ( !$url ) {
		// 3. use global fallback url
		$url = this.url;
	}

	return $url;
};

FormManager.processResponse = function ($prefix, $data, $add_params) {
	// enable form back
//	alert('enabling for for [' + $prefix + '] in processResponse');

	if ( $add_params !== undefined ) {
		$add_params.response = $data;
	}
	else {
		$add_params = {response: $data};
	}

	this.clearErrors($prefix);
	this.processUploadFields($prefix, $data);

	if ($data.status == 'OK') {
		var $next_template = this.getNextTemplate($prefix, $data);

		if ( $next_template || $data.do_refresh || $data.redirect_to ) {
			var $before_close = this.getFormParamOverride($prefix, 'before_close', $add_params);

			if ( $.isFunction($before_close) ) {
				$before_close.call(this, $data, $add_params);
			}

			if ( $next_template ) {
				// load another template instead of current form
				$(this.windowManager.getContentSelector())
				.html('')
				.load(this.getURL($prefix, $next_template, undefined, $data.params), function () {
					$(document).trigger('FormManager.WindowManager.Ready');
				});
			}
			else if ( $data.do_refresh ) {
				// refresh whole page
				window.location.reload(true);
			}
			else if ( $data.redirect_to ) {
				// redirect to given page
				window.location.assign($data.redirect_to);
			}
		}
		else {
			// close form without refreshing the page
			this.closeForm($prefix, $data, $add_params);
		}
	}
	else {
		// set new errors
		for ($field in $data.field_errors) {
			this.setFieldStatus($prefix, $field, $data.field_errors[$field]);
		}

		var $validation_failure = this.form_param($prefix, 'validation_failure');

		if ( $.isFunction($validation_failure) ) {
			$validation_failure.call(this, $data, $add_params);
		}
	}

	this.enableForm($prefix, true);

//	var $me = this;
//	setTimeout(function () { $me.enableForm($prefix, true); }, 1000);
};

/**
 * Clear errors from all from fields
 *
 * @param $prefix
 */
FormManager.clearErrors = function ($prefix) {
	var $fields = this.fields[$prefix];

	if (typeof($fields) == 'undefined') {
		$fields = [];
	}

	this.errors[$prefix] = {};

	for (var $i = 0; $i < $fields.length; $i++) {
		this.setFieldStatus($prefix, $fields[$i]);
	}
};

FormManager.getNextTemplate = function ($prefix, $responce) {
	if ( $responce.next_template && $responce.next_template != '' ) {
		return $responce.next_template;
	}
	else if ( this.form_param($prefix, 'next_template') ) {
		return this.form_param($prefix, 'next_template');
	}

	return false;
};

FormManager.getCell = function ($prefix, $field_name, $cell_type) {
	$field_name = $field_name.replace(/_(date|time)$/, '');

	return this.getField($prefix, $field_name, undefined, '_' + $cell_type + '_cell');
};

FormManager.setFieldStatus = function ($prefix, $field_name, $error_msg) {
	var field_cell = $(this.getCell($prefix, $field_name, 'field'));
	var status_cell = $(this.getCell($prefix, $field_name, 'status'));

	if ( $error_msg === undefined || !$error_msg ) {
		$error_msg = '';
	}

	if ( field_cell.length == 0 ) {
		if (!this.errors[$prefix]) {
			this.errors[$prefix] = {};
		}

		this.errors[$prefix][$field_name] = $error_msg;

		/*if(typeof console === 'object') {
			console.log('FormManager: Error field "' + $field_name + '" missing.');
		}*/

		return ;
	}

	if ($error_msg === undefined || !$error_msg) {
		// show OK
		field_cell.parents('tr:first').removeClass('error').addClass('ok');
		status_cell.removeClass('field-error').html(this.noErrorsHTML);

		var $fields = this.fields[$prefix];

		for (var $i = 0; $i < $fields.length; $i++) {
			if ( this.fieldHasError($prefix, $fields[$i]) ) {
				return ;
			}
		}
	}
	else {
		// show error message
		field_cell.parents('tr:first').removeClass('ok').addClass('error');
		status_cell.addClass('field-error').html($error_msg);
	}
};

FormManager.fieldHasError = function ($prefix, $field) {
	var status_cell = this.getField($prefix, $field, undefined, '_status_cell');

	return $.trim( $(status_cell).html() ) != $.trim( this.noErrorsHTML );
};

FormManager.checkField = function ($input, $delayed) {
	if ( !$input.id.match(/^(.*?)\[.*?\]\[(.*?)\].*?$/) ) {
		return ;
	}

	var $prefix = RegExp.$1;
	var $field = RegExp.$2.replace(/(_date|_time)$/, '');

	if ( $field.match(/(.*)(Month|Year)$/) && this.fieldTypes[$prefix + '_' + RegExp.$1 + 'Date'] == 'cc_expiration' ) {
		$field = RegExp.$1 + 'Date';
	}

	if ( this.pendingChecks[$field] ) {
		clearTimeout( this.pendingChecks[$field] );
		delete this.pendingChecks[$field];
	}

	var $me = this;

	this.pendingChecks[$field] = setTimeout(
		function () {
			$me.validateField($prefix, $field, $input)
		},
		($delayed === true ? this.checkTimeout : 0)
	);
};

FormManager.validateField = function ($prefix, $field, $input) {
	var $me = this;

	var $request = $.post(
		this.getURL($prefix, undefined, 'OnValidateField') + '&field=' + encodeURIComponent($field) + '&' + $input.name + '=' + encodeURIComponent($input.value),
		this._getFormFields($prefix),
		function ($data) {
			$data = eval('(' + $data + ')');
			$me.setFieldStatus($prefix, $field, $data.status == 'OK' ? undefined : $data.status);
			$me.processUploadFields($prefix, $data);

			// show/hide general error notice
			$('#' + $prefix + '_error_message').toggle(!$.isArray($data.other_errors));
		}
	);

	this.xhrRequests.push($request);
};

FormManager.processUploadFields = function ($prefix, $response) {
	if ( $response['uploader_info'] === undefined || $.isArray($response['uploader_info']) ) {
		// no data (event don't support that) OR empty array (no uploader fields on form)
		return;
	}

	var	$field_mask = this.getFieldMask($prefix);

	$.each($response['uploader_info'], function ($field_name, $field_data) {
		var $uploader_id = $field_mask.replace('#FIELD_NAME#', $field_name);

		$(document).trigger('UploadsManager.Uploader.' + crc32($uploader_id), ['refreshQueue', $field_data]);
	});
};

FormManager.form_param = function ($prefix, $param, $value) {
	if ( this.forms[$prefix] === undefined ) {
		return '';
	}

	if ($value === undefined) {
		return this.forms[$prefix][$param];
	}

	this.forms[$prefix][$param] = $value;
};

FormManager.getFormParamOverride = function ($prefix, $param, $overrides) {
	if ( $overrides[$param] !== undefined ) {
		return $overrides[$param];
	}

	return this.form_param($prefix, $param);
};

/* === related to form opening/closing/submitting === */
FormManager.openForm = function ($prefix, $template, $width, $height, $source_form, $params) {
	var $url = this.getURL($prefix, $template, undefined, $params);

	this.windowManager.open($url, $width, $height, $source_form);
};

FormManager.validateAll = function ($prefix, $status) {
	var $fields = this.fields[$prefix];

	for (var $i = 0; $i < $fields.length; $i++) {
		this.setFieldStatus($prefix, $fields[$i], $status);
	}
};

FormManager.closeForm = function ($prefix, $data, $add_params) {
	if ( $data === undefined ) {
		$data = {};
	}

	if ( $add_params === undefined ) {
		$add_params = {};
	}

	var $before_close = this.getFormParamOverride($prefix, 'before_close', $add_params);

	this.cancelXHRRequests();
	this.validateAll($prefix);

	if ( $.isFunction($before_close) ) {
		var $result = $before_close.call(this, $data, $add_params);

		if ($result === false) {
			return;
		}
	}

	this.windowManager.close();
};

FormManager._getFormFields = function ($prefix) {
	var	$old_values = {},
		$fields = this.fields[$prefix];

	if (typeof($fields) == 'undefined') {
		$fields = [];
	}

	// remove watermarks from input fields
	for (var $i = 0; $i < $fields.length; $i++) {
		var	$control = this.getField($prefix, $fields[$i]),
			$watermark = this.fieldWatermarks[ $prefix + '_' + $fields[$i] ];

		if ( $control ) {
			$old_values[$fields[$i]] = $control.value;

			if ( $watermark !== undefined && $control.value == $watermark ) {
				$control.value = '';
			}
		}
	}

	var	$form_fields = this.getForm($prefix).serialize();

	// restore original values into input fields
	for (var $i = 0; $i < $fields.length; $i++) {
		var $control = this.getField($prefix, $fields[$i]);

		if ( $control ) {
			$control.value = $old_values[$fields[$i]];
		}
	}

	return $form_fields;
};

FormManager.getForm = function ($prefix) {
	var $form_id = this.form_param($prefix, 'form_id');

	return $('#' + jq($form_id));
};

FormManager.enableForm = function ($prefix, $enabled) {
	if ($enabled === undefined) {
		$enabled = true;
	}

	if ($enabled) {
		clearTimeout( this.form_param($prefix, 'enabledTimer') );
		this.form_param($prefix, 'enabledTimer', null);
	}
	else {
		var $me = this;

		// set timer for 10 seconds to enable form back (just in case if ajax responce fails)
		var $timer = setTimeout(
			function () {
//				alert('enabling for for [' + $prefix + '] in setTimeout');
				$me.enableForm($prefix, true);
			}
			, 10000
		);

		this.form_param($prefix, 'enabledTimer', $timer);
	}

	this.form_param($prefix, 'enabled', $enabled);
};

FormManager.cancelXHRRequests = function () {
	while ( this.xhrRequests.length > 0 ) {
		this.xhrRequests.shift().abort();
	}
};

FormManager.submitForm = function ($prefix, $add_params) {
	if ( !this.form_param($prefix, 'enabled') ) {
		return ;
	}

	// disable form
	this.enableForm($prefix, false);

	var $me = this;
	this.cancelXHRRequests();

	$.post(
		this.getURL( $prefix, undefined, this.form_param($prefix, 'save_event') ),
		this._getFormFields($prefix),
		function ($data) {
			var $redirect = FormManager.parseRedirect($data);

			if ( $redirect !== false ) {
				window.location.href = $redirect;

				return ;
			}

			$me.processResponse($prefix, eval('(' + $data + ')'), $add_params);
		}
	)
};

FormManager.beforeClose = function () {
	this.cancelXHRRequests();

	for (var $prefix in this.forms) {
		var $before_close = this.form_param($prefix, 'before_close');

		this.clearErrors($prefix);

		if ( $.isFunction($before_close) ) {
			$before_close.call(this, {}, {});
		}
	}
};

FormManager.parseRedirect = function ($data) {
	var $match_redirect = new RegExp('^#redirect#(.*?)($|\\s.*)').exec($data);

	if ( $match_redirect != null ) {
		// redirect to external template requested
		return $match_redirect[1];
	}

	return false;
};

FormManager.parseQueryString = function ($url) {
	var $query_string = {};

	$url.replace(
		new RegExp('([^?=&]+)(=([^&]*))?', 'g'),
		function($0, $1, $2, $3) {
			$query_string[$1] = decodeURIComponent($3);
		}
	);

	return $query_string;
};

/* ==================================================================== */

function FormManager_WindowManagerExample() {

}

FormManager_WindowManagerExample.prototype.init = function ($window_scope, $context) {
	throw 'FormManager_WindowManagerExample: Please use other window manager.';
};

FormManager_WindowManagerExample.prototype.open = function ($url, $width, $height, $source_form) {

};

FormManager_WindowManagerExample.prototype.getDefaultOptions = function ($url, $width, $height) {

};

FormManager_WindowManagerExample.prototype.close = function () {

};

FormManager_WindowManagerExample.prototype.getContentSelector = function () {

};

/* ==================================================================== */

function FormManager_WindowManagerThickBox() {
	this.lastWindowScope = '';
}

FormManager_WindowManagerThickBox.prototype.init = function ($window_scope, $context) {
	var $me = this;

	$(this.getWindowScope($window_scope), $context).click(function ($e) {
		var $options = $me.getDefaultOptions(this.href || this.alt);

		$.extend($options, {
			caption: this.title || this.name || null,
			imageGroup: this.rel || false
		});

		TB.show($options);
		this.blur();

		$e.preventDefault();
	});
};

FormManager_WindowManagerThickBox.prototype.getWindowScope = function ($window_scope) {
	if ( $window_scope !== undefined ) {
		this.lastWindowScope = $window_scope;

		return $window_scope;
	}

	return this.lastWindowScope;
};

FormManager_WindowManagerThickBox.prototype.open = function ($url, $width, $height, $source_form) {
	$url += ($url.indexOf('?') == -1 ? '?' : '&') + 'width=' + $width + '&height=' + $height + '&modal=true';

	var $options = this.getDefaultOptions($url, $width, $height);

	if ( $source_form !== undefined ) {
		$options.postParams = $($source_form).serialize();
	}

	TB.show($options);
};

FormManager_WindowManagerThickBox.prototype.getDefaultOptions = function ($url, $width, $height) {
	var $me = this;

	return {
		url: $url,
		onAfterShow: function () {
			$me.init(undefined, $me.getContentSelector());

			// document.ready equivalent for ajax loaded windows
			$(document).trigger('FormManager.WindowManager.Ready');
		}
	};
};

FormManager_WindowManagerThickBox.prototype.close = function () {
	TB.remove();
};

FormManager_WindowManagerThickBox.prototype.getContentSelector = function () {
	return '#TB_ajaxContent';
};

/* ==================================================================== */

function FormManager_WindowManagerColorBox() {
	this.lastWindowScope = '';
}

FormManager_WindowManagerColorBox.prototype.init = function ($window_scope, $context) {
	var $me = this;

	$(this.getWindowScope($window_scope), $context).each(function () {
		var $url = this.href || this.alt,
			$query_string = FormManager.parseQueryString($url),
			$options = $me.getDefaultOptions(
				this.href || this.alt,
				$query_string['width'] !== undefined ? $query_string['width'] : false,
				$query_string['height'] !== undefined ? $query_string['height'] : false
			);

		$.extend($options, {
			title: this.title || this.name || false
		});

		$(this).colorbox($options);
	});
};

FormManager_WindowManagerColorBox.prototype.getWindowScope = function ($window_scope) {
	if ( $window_scope !== undefined ) {
		this.lastWindowScope = $window_scope;

		return $window_scope;
	}

	return this.lastWindowScope;
};

FormManager_WindowManagerColorBox.prototype.open = function ($url, $width, $height, $source_form) {
	var $options = this.getDefaultOptions($url, $width, $height);

	$.extend($options, {
		// modal analog
		escKey: false,
		overlayClose: false
	});

	if ( $source_form !== undefined ) {
		$options.data = $($source_form).serialize();
	}

	$.colorbox($options);
};

FormManager_WindowManagerColorBox.prototype.getDefaultOptions = function ($url, $width, $height) {
	var $me = this;

	return {
		href: $url,

		innerWidth: $width,
		innerHeight: $height,

		onComplete: function () {
			$me.init(undefined, $me.getContentSelector());

			// document.ready equivalent for ajax loaded windows
			$(document).trigger('FormManager.WindowManager.Ready');
		}
	};
};

FormManager_WindowManagerColorBox.prototype.close = function () {
	$.colorbox.close();
};

FormManager_WindowManagerColorBox.prototype.getContentSelector = function () {
	return '#cboxLoadedContent';
};

/* ==================================================================== */

function FormManager_WindowManagerFancyBox() {
	this.lastWindowScope = '';
}

FormManager_WindowManagerFancyBox.prototype.init = function ($window_scope, $context) {
	var $me = this;

	$(this.getWindowScope($window_scope), $context).each(function () {
		var $url = this.href || this.alt,
			$query_string = FormManager.parseQueryString($url),
			$options = $me.getDefaultOptions(
				$url,
				$query_string['width'] !== undefined ? $query_string['width'] : false,
				$query_string['height'] !== undefined ? $query_string['height'] : false
			);

		$.extend($options, {
			title: this.title || this.name || false
		});

		$(this).fancybox($options);
	});
};

FormManager_WindowManagerFancyBox.prototype.getWindowScope = function ($window_scope) {
	if ( $window_scope !== undefined ) {
		this.lastWindowScope = $window_scope;

		return $window_scope;
	}

	return this.lastWindowScope;
};

FormManager_WindowManagerFancyBox.prototype.open = function ($url, $width, $height, $source_form) {
	var $options = this.getDefaultOptions($url, $width, $height);

	$.extend($options, {
		modal: true
	});

	if ($source_form !== undefined) {
		$options['ajax'] = {
			data: $($source_form).serialize()
		};
	}

	$.fancybox.open($options);
};

FormManager_WindowManagerFancyBox.prototype.getDefaultOptions = function ($url, $width, $height) {
	var $me = this;

	return {
		href: $url,
		type : $.fancybox.isImage($url) ? 'image' : 'ajax',

		width: $width,
		height: $height,
		autoSize: false,

		afterShow: function () {
			$me.init(undefined, $me.getContentSelector());

			// document.ready equivalent for ajax loaded windows
			$(document).trigger('FormManager.WindowManager.Ready');
		}
	};
};

FormManager_WindowManagerFancyBox.prototype.close = function () {
	$.fancybox.close();
};

FormManager_WindowManagerFancyBox.prototype.getContentSelector = function () {
	return '.fancybox-inner';
};
