<?php
/**
* @version	$Id: private_messages_config.php 15008 2012-01-06 20:37:30Z alex $
* @package	In-Bulletin
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'private-message',
		'ItemClass'			=>	Array('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass'			=>	Array('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass'	=>	Array('class' => 'PrivateMessageEventHandler', 'file' => 'private_message_eh.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' =>	Array('class' => 'PrivateMessageTagProcessor', 'file' => 'private_message_tp.php', 'build_event' => 'OnBuild'),

		'AutoLoad' => true,

		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'PerPage',
			4 => 'event',
			5 => 'mode',
		),

		'IDField' => 'PmId',
		'StatusField' => Array ('Status'),
		'TitleField' => 'Subject',

   		'PermSection' => Array('main' => 'in-bulletin:private_messages',),

		'TableName' => TABLE_PREFIX.'PrivateMessages',

		'CalculatedFields' => Array (
			'' => Array (
				'Subject' => 'pmb.Subject',
				'Body' => 'pmb.Body',
			),
		),

		'ListSQLs' => Array (
			'' => ' SELECT %1$s.* %2$s
					FROM %1$s
					LEFT JOIN '.TABLE_PREFIX.'%3$sPrivateMessageBody pmb ON pmb.PMBodyId = %1$s.PMBodyId
					LEFT JOIN '.TABLE_PREFIX.'Users from_user ON from_user.PortalUserId = %1$s.FromId
					LEFT JOIN '.TABLE_PREFIX.'Users to_user ON to_user.PortalUserId = %1$s.ToId',
		),

		'ListSortings' => Array (
			'' => Array(
				'ForcedSorting' => Array('CreatedOn' => 'desc'),
			),
		),

		'ItemSQLs' => Array (
			'' => ' SELECT %1$s.* %2$s
					FROM %1$s
					LEFT JOIN '.TABLE_PREFIX.'%3$sPrivateMessageBody pmb ON pmb.PMBodyId = %1$s.PMBodyId
					LEFT JOIN '.TABLE_PREFIX.'Users from_user ON from_user.PortalUserId = %1$s.FromId
					LEFT JOIN '.TABLE_PREFIX.'Users to_user ON to_user.PortalUserId = %1$s.ToId',
		),

		'SubItems' => Array('private-message-body'),

		'CalculatedFields' => Array (
			'' => Array (
				'Subject' => 'pmb.Subject',
				'Body' => 'pmb.Body',
				'Options' => 'pmb.Options',

				'FromName' => 'IF (ISNULL(from_user.Username), IF (%1$s.FromId = ' . USER_ROOT . ', "root", IF (%1$s.FromId = ' . USER_GUEST . ', "Guest", "n/a")), from_user.Username)',
				'ToName' => 'IF (ISNULL(to_user.Username), IF (%1$s.ToId = ' . USER_ROOT . ', "root", IF (%1$s.ToId = ' . USER_GUEST . ', "Guest", "n/a")), to_user.Username)',

				'FromFullName' => 'TRIM(CONCAT(from_user.FirstName, " ", from_user.LastName))',
				'ToFullName' => 'TRIM(CONCAT(to_user.FirstName, " ", to_user.LastName))',
			),
		),

		'Fields' => Array (
			'PmId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		    'FromId' => Array('type' => 'int', 'formatter' => 'kLEFTFormatter', 'error_msgs' => Array ('invalid_option' => '!lu_error_UserNotFound!'), 'left_sql' => 'SELECT %s FROM '.TABLE_PREFIX.'Users WHERE `%s` = \'%s\'', 'left_key_field' => 'PortalUserId', 'left_title_field' => 'Username', 'required' => 1, 'default' => null),
		    'ToId' => Array('type' => 'int', 'formatter' => 'kLEFTFormatter', 'error_msgs' => Array ('invalid_option' => '!lu_error_UserNotFound!'), 'left_sql' => 'SELECT %s FROM '.TABLE_PREFIX.'Users WHERE `%s` = \'%s\'', 'left_key_field' => 'PortalUserId', 'left_title_field' => 'Username', 'required' => 1, 'default' => null),
		    'FolderId' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (0 => 'lu_Inbox', 1 => 'lu_Sent'), 'use_phrases' => 1, 'not_null' => 1, 'default' => PM_FOLDER_SENT),
		    'Status' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (0 => 'lu_opt_MessageUnread', 1 => 'lu_opt_MessageViewed', 2 => 'lu_opt_MessageRead', 3 => 'lu_opt_MessageReplied', 4 => 'lu_opt_MessageSent'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 0),
		    'PMBodyId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		    'CreatedOn' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => '#NOW#'),
		),

		'VirtualFields' => Array (
			'FromName' => Array ('type' => 'string', 'default' => ''),
			'FromFullName' => Array ('type' => 'string', 'default' => ''),
			'ToName' => Array ('type' => 'string', 'default' => ''),
			'ToFullName' => Array ('type' => 'string', 'default' => ''),
			'Subject' => Array ('type' => 'string', 'default' => ''),
			'Body' => Array ('type' => 'string',  'required' => 1, 'default' => ''),
			'Options' => Array ('type' => 'string', 'default' => 0),

			'DisableBBCodes' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1, 'default' => 0),
			'DisableSmileys' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1, 'default' => 0),
			'ShowSignatures' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1, 'default' => 1),
		),


	);