<?php
/**
* @version	$Id: posts_config.php 14251 2011-03-16 21:21:42Z alex $
* @package	In-Bulletin
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix'			=>	'bb-post',
		'ItemClass'			=>	Array('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass'			=>	Array('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass'	=>	Array('class' => 'PostEventHandler', 'file' => 'post_eh.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' =>	Array('class' => 'PostTagProcessor', 'file' => 'post_tp.php', 'build_event' => 'OnBuild'),
		'AutoLoad'			=>	true,

		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'PerPage',
			4 => 'event',
		),

		'IDField' => 'PostingId',
		'StatusField' => Array('Pending'),

		'TitleField' => 'Subject',

		'TableName' => TABLE_PREFIX.'Posting',

		'ForeignKey' => 'TopicId',
		'ParentTableKey' => 'TopicId',
		'ParentPrefix' => 'bb',
		'AutoDelete' => true,
		'AutoClone' => true,

		'ListSQLs' => Array (
			'' => ' SELECT %1$s.* %2$s
					FROM %1$s
					LEFT JOIN '.TABLE_PREFIX.'PortalUser u ON %1$s.CreatedById = u.PortalUserId
					LEFT JOIN '.TABLE_PREFIX.'Images img ON (img.ResourceId = u.ResourceId) AND (img.DefaultImg = 1 OR img.Name = "avatar")',
		),

		'ItemSQLs' => Array (
			'' => ' SELECT %1$s.* %2$s
					FROM %1$s
					LEFT JOIN '.TABLE_PREFIX.'PortalUser u ON %1$s.CreatedById = u.PortalUserId
					LEFT JOIN '.TABLE_PREFIX.'Images img ON (img.ResourceId = u.ResourceId) AND (img.DefaultImg = 1 OR img.Name = "avatar")',
		),

		'ListSortings' => Array (
			'' => Array (
				'ForcedSorting' => Array ('CreatedOn' => 'asc',),
			),
		),

		'CalculatedFields' => Array (
			'' => Array (
				'UserName' => 'IF (ISNULL(u.Login), IF (%1$s.CreatedById = ' . USER_ROOT . ', "root", IF (%1$s.CreatedById = ' . USER_GUEST . ', "Guest", "n/a")), u.Login)',

				'AltName'		=>	'img.AltName',
				'SameImages'	=>	'img.SameImages',
				'LocalThumb'	=>	'img.LocalThumb',
				'ThumbPath'		=>	'img.ThumbPath',
				'ThumbUrl'		=>	'img.ThumbUrl',
				'LocalImage'	=>	'img.LocalImage',
				'LocalPath'		=>	'img.LocalPath',
				'FullUrl'		=>	'img.Url',
			),
		),

		'Fields' => Array (
			'PostingId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		    'IPAddress' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
		    'PosterAlias' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
		    'Pending' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		    'Subject' => Array ('type' => 'string', 'max_len' => 255, 'default' => NULL),
		    'PostingText' => Array ('type' => 'string', 'allow_html' => 1, 'default' => NULL),
		    'GraphicsUrl' => Array ('type' => 'string', 'max_len' => 255, 'default' => NULL),
		    'CreatedOn' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => '#NOW#'),
		    'Modified' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => NULL),
		    'ModifiedById' => Array ('type' => 'int', 'formatter' => 'kLEFTFormatter', 'error_msgs' => Array ('invalid_option' => '!la_error_UserNotFound!'), 'options' => Array(USER_ROOT => 'root', USER_GUEST => 'Guest'), 'left_sql' => 'SELECT %s FROM '.TABLE_PREFIX.'PortalUser WHERE `%s` = \'%s\'', 'left_key_field' => 'PortalUserId', 'left_title_field' => 'Login', 'default' => NULL),
		    'CreatedById' => Array ('type' => 'int', 'formatter' => 'kLEFTFormatter', 'error_msgs' => Array ('invalid_option' => '!la_error_UserNotFound!'), 'options' => Array(USER_ROOT => 'root', USER_GUEST => 'Guest'), 'left_sql' => 'SELECT %s FROM '.TABLE_PREFIX.'PortalUser WHERE `%s` = \'%s\'', 'left_key_field' => 'PortalUserId', 'left_title_field' => 'Login', 'default' => NULL),
		    'TopicId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		    'ResourceId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		    'ReplyTo' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		    'Options' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		),

		'VirtualFields' => Array (
			'DisableBBCodes' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1, 'default' => 0),
			'DisableSmileys' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1, 'default' => 0),
			'ShowSignatures' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1, 'default' => 1),
			'UserName'		 =>	Array ('type' => 'string', 'default' => ''),
			// for avatar image
			'AltName'		=>	Array('type' => 'string', 'default' => ''),
			'SameImages'	=>	Array('type' => 'string', 'default' => ''),
			'LocalThumb'	=>	Array('type' => 'string', 'default' => ''),
			'ThumbPath'		=>	Array('type' => 'string', 'default' => ''),
			'ThumbUrl'		=>	Array('type' => 'string', 'default' => ''),
			'LocalImage'	=>	Array('type' => 'string', 'default' => ''),
			'LocalPath'		=>	Array('type' => 'string', 'default' => ''),
			'FullUrl'		=>	Array('type' => 'string', 'default' => ''),
		),

		'ConfigMapping' => Array (
			'PerPage' => 'Perpage_Postings',
		),
	);