<?php
/**
* @version	$Id: prerequisites.php 14251 2011-03-16 21:21:42Z alex $
* @package	In-Bulletin
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/
	defined('FULL_PATH') or die('restricted access!');

	$prerequisite_class = 'InBulletinPrerequisites';

	/**
	 * Class, that holds all prerequisite scripts for "In-Bulletin" module
	 *
	 */
	class InBulletinPrerequisites extends kHelper {

		/**
		 * Install toolkit instance
		 *
		 * @var kInstallToolkit
		 */
		var $_toolkit = null;

		/**
		 * Sets common instance of installator toolkit
		 *
		 * @param kInstallToolkit $instance
		 */
		function setToolkit(&$instance)
		{
			$this->_toolkit =& $instance;
		}

		/**
		 * Checks minimal version, that could be upgradeable
		 *
		 * @param string $mode when called mode {install, standalone, upgrade)
		 */
		function CheckPrerequisites($versions, $mode)
		{
			$errors = Array ();

			if ($mode == 'standalone') {
				if (!$this->Application->isModuleEnabled('In-Portal')) {
					$errors[] = 'Please install or enable "In-Portal" module first';
				}
			}

			if ($mode == 'upgrade') {
				$sql = 'SELECT Version
						FROM ' . TABLE_PREFIX . 'Modules
						WHERE Name = "In-Portal"';
				$inportal_version = $this->Conn->GetOne($sql);

				if ($inportal_version === false) {
					// only, when In-Portal was installed
					return $errors;
				}

				$min_version = '4.3.1';

				$current_version = $this->_toolkit->ConvertModuleVersion($inportal_version);
				$needed_version = $this->_toolkit->ConvertModuleVersion($min_version);
				if ($current_version < $needed_version) {
					$errors[] = 'Please upgrade "In-Portal" to version ' . $min_version;
				}
			}

			return $errors;
		}
	}
