<?php
/**
* @version	$Id: emoticons_config.php 13237 2010-03-15 22:23:52Z dmitrya $
* @package	In-Bulletin
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'emoticon',
		'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'EmoticonEventHandler', 'file' => 'emoticon_eh.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'kDBTagProcessor', 'file' => '', 'build_event' => 'OnBuild'),

		'AutoLoad' => true,

		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'event',
			4 => 'mode',
		),

		'IDField' => 'EmoticonId',

		'TableName' => TABLE_PREFIX.'Emoticon',

		'TitleField' => 'Name',

		'TitlePresets' => Array (
			'default' => Array (
				'new_status_labels' => Array ('emoticon' => '!la_title_AddingSmiley!'),
				'edit_status_labels' => Array ('emoticon' => '!la_title_EditingSmiley!'),
			),

			'emoticon_list' => Array ('prefixes' => Array ('emoticon_List'), 'format' => "!la_tab_ConfigSmileys!"),
			'emoticon_edit' => Array ('prefixes' => Array ('emoticon'), 'format' => "#emoticon_status# '#emoticon_titlefield#'"),
		),

		'PermSection' => Array('main' => 'in-bulletin:configuration_emoticon'),

		'Sections' => Array (
			'in-bulletin:configuration_emoticon' => Array (
				'parent'		=>	'in-bulletin:setting_folder',
				'icon'			=>	'conf_smileys',
				'label'			=>	'la_tab_ConfigSmileys',
				'url'			=>	Array('t' => 'in-bulletin/emoticons/emoticon_list', 'pass' => 'm'),
				'permissions'	=>	Array('view', 'add', 'edit'),
				'priority'		=>	2,
				'type'			=>	stTREE,
			),
		),

		'ListSQLs' => Array (
			'' => '	SELECT %1$s.* %2$s FROM %1$s',
		),

		'ListSortings' => Array (
			'' => Array (
				'Sorting' => Array ('Name' => 'desc'),
			)
		),

		'Fields' => Array (
			'EmoticonId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'Name' => Array ('type' => 'string', 'max_len' => 20, 'not_null' => 1, 'required' => 1, 'default' => ''),
			'KeyStroke' => Array ('type' => 'string', 'max_len' => 20, 'not_null' => 1, 'required' => 1, 'default' => ''),
			'Enabled' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter',
				'options' => Array (0 => 'la_No', 1 => 'la_Yes',), 'use_phrases' => 1,
				'default' => 1, 'not_null' => 1,
			),
			'EmotionImage' => Array (
				'type' => 'string', 'max_len' => 255,
				'formatter' => 'kUploadFormatter', 'allowed_types' => Array ('image/jpeg', 'image/jpg', 'image/gif', 'image/png', 'image/pjpeg'),
				'upload_dir' => SMILEYS_PATH,
				'not_null' => 1, 'required' => 1, 'default' => '',
			),
		),

		'Grids' => Array (
			'Default' => Array (
				'Icons' => Array (
					'default' => 'icon16_item.png',
					0 => 'icon16_disabled.png',
					1 => 'icon16_item.png',
					'module' => 'core',
				),
				'Fields' => Array (
					'EmoticonId' => Array ('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 50, ),
					'Name' => Array ('title' => 'la_col_Name', 'filter_block' => 'grid_like_filter', 'width' => 150, ),
					'KeyStroke' => Array ('title' => 'la_col_KeyStroke', 'filter_block' => 'grid_like_filter', 'width' => 100, ),
					'EmotionImage' => Array ('title' => 'la_col_Image', 'filter_block' => 'grid_like_filter', 'width' => 150, ),
				),
			),
		),
	);