<?php
/**
* @version	$Id: private_message_tp.php 12740 2009-10-20 19:39:07Z alex $
* @package	In-Bulletin
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class PrivateMessageTagProcessor extends kDBTagProcessor {

		/**
		 * Checks if private message is unread
		 *
		 * @param Array $params
		 * @return bool
		 */
		function IsNew($params)
		{
			$object =& $this->getObject();
			/* @var $object kDBItem */

			return $object->GetDBField('Status') < PM_STATUS_READ;
		}

		/**
		 * Allows to check what folder is currently active
		 *
		 * @param Array $params
		 * @return bool
		 */
		function FolderSelected($params)
		{
			$folder_mapping = Array ('inbox' => PM_FOLDER_INBOX, 'sent' => PM_FOLDER_SENT);

			return (int)$this->Application->GetVar('folder_id') == $folder_mapping[ strtolower($params['folder']) ];
		}

		/**
		 * Creates link to specific private message folder
		 *
		 * @param Array $params
		 * @return string
		 */
		function FolderLink($params)
		{
			$folder_mapping = Array ('inbox' => PM_FOLDER_INBOX, 'sent' => PM_FOLDER_SENT);
			$params['folder_id'] = $folder_mapping[ strtolower($params['folder']) ];
			unset($params['folder']);

			return $this->Application->ProcessParsedTag('m', 'Link', $params);
		}

		function MessageSubject($params)
		{
			$object =& $this->getObject();
			/* @var $object kDBItem */

			$params['field'] = 'Subject';
			$value = $this->Field($params);

			if (!$value && isset($params['empty_title'])) {
				return '['.$this->Application->Phrase($params['empty_title']).']';
			}

			return $value;
		}

		function MessageBody($params)
		{
			$object =& $this->getObject($params);

			$post_helper =& $this->Application->recallObject('PostHelper');
			/* @var $post_helper PostHelper */

			// 2. parse post body
			$sub_blocks = Array (
				'smileys' => $params['smiley_render_as'],
				'bbcode' => $params['bbcode_render_as'],
			);

			return $post_helper->parsePostBody($object->GetDBField('Body'), $object->GetDBField('Options'), $sub_blocks);
		}

		function DeleteLink($params)
		{
			$params['pass'] = 'm,'.$this->getPrefixSpecial();
			$params[$this->getPrefixSpecial().'_event'] = 'OnDelete';
			return $this->Application->ProcessParsedTag('m', 'Link', $params);
		}

		function ReplyLink($params)
		{
			$params['reply_to'] = $this->Application->GetVar($this->getPrefixSpecial().'_id');
			return $this->Application->ProcessParsedTag('m', 'Link', $params);
		}

		/**
		 * User can reply message only in case, when it is not it's own message
		 *
		 * @param Array $params
		 * @return bool
		 */
		function CanReplyMessage($params)
		{
			$object =& $this->getObject();
			/* @var $object kDBItem */

			return $object->GetDBField('FromId') != $this->Application->RecallVar('user_id');
		}

		/**
		 * Marks private message as read
		 *
		 * @param Array $params
		 */
		function MarkAsRead($params)
		{
			$object =& $this->getObject();
			/* @var $object kDBItem */

			if ($object->GetDBField('Status') < PM_STATUS_READ) {
				$object->SetDBField('Status', PM_STATUS_READ);
				$object->Update();
			}
		}

		/**
		 * Returns link to private message sender/recipient public profile
		 *
		 * @param Array $params
		 * @return string
		 */
		function ProfileLink($params)
		{
			$user_field = strtolower($params['type']) == 'from' ? 'FromId' : 'ToId';
			unset($params['type']);

			$object =& $this->getObject($params);
			$params['user_id'] = $object->GetDBField($user_field);

			return $this->Application->ProcessParsedTag('m', 'Link', $params);
		}

		/**
		 * Returns link for sending private message from user's public profile page
		 *
		 * @param Array $params
		 * @return string
		 */
		function SendMessageLink($params)
		{
			$params['user_id'] = $this->Application->GetVar('user_id');
			return $this->Application->ProcessParsedTag('m', 'Link', $params);
		}

	}