CREATE TABLE Posting (
  PostingId int(11) NOT NULL auto_increment,
  IPAddress varchar(255) NOT NULL default '',
  PosterAlias varchar(255) NOT NULL default '',
  Pending tinyint(4) NOT NULL default '0',
  Subject varchar(255) default NULL,
  PostingText text,
  GraphicsUrl varchar(255) default NULL,
  CreatedOn int(11) NOT NULL default '0',
  Modified int(11) NOT NULL default '0',
  ModifiedById int(11) default NULL,
  CreatedById int(11) default NULL,
  TopicId int(11) NOT NULL default '0',
  ResourceId int(11) NOT NULL default '0',
  ReplyTo int(11) NOT NULL default '0',
  Options int(11) NOT NULL default '0',
  PRIMARY KEY  (PostingId),
  KEY TopicId (TopicId),
  KEY Pending (Pending),
  KEY CreatedById (CreatedById),
  KEY CreatedOn (CreatedOn),
  KEY ModifiedOn (Modified),
  KEY ModifiedById (ModifiedById)
);

CREATE TABLE Topic (
  TopicId int(11) NOT NULL auto_increment,
  NotifyOwnerOnChanges tinyint(4) NOT NULL default '0',
  Modified int(11) NOT NULL default '0',
  TopicText varchar(255) NOT NULL default '',
  AutomaticFilename tinyint(3) unsigned NOT NULL default '1',
  Posts int(11) NOT NULL default '0',
  Views double(20,6) NOT NULL default '0',
  EditorsPick tinyint(4) NOT NULL default '0',
  Status tinyint(4) unsigned NOT NULL default '2',
  Priority int(11) NOT NULL default '0',
  OwnerId int(11) NOT NULL default '-1',
  ModifiedById int(11) NOT NULL default '0',
  ResourceId int(11) default NULL,
  TopicType int(11) NOT NULL default '1',
  CreatedOn int(11) NOT NULL default '0',
  CachedReviewsQty int(11) NOT NULL default '0',
  CachedRating VARCHAR(10) NOT NULL DEFAULT '0',
  CachedVotesQty int(11) NOT NULL default '0',
  NewItem tinyint(4) NOT NULL default '2',
  PopItem tinyint(4) NOT NULL default '2',
  HotItem tinyint(4) NOT NULL default '2',
  PostedBy varchar(255) NOT NULL default '',
  OrgId INT(11) NULL DEFAULT NULL,
  LastPostId int(11) NOT NULL default '0',
  LastPostDate INT(11) NULL DEFAULT NULL,
  TodayDate DATE NULL DEFAULT NULL,
  TodayPosts int(11) NOT NULL default '0',
  MetaKeywords varchar(255) DEFAULT NULL,
  MetaDescription text NULL DEFAULT NULL,
  PRIMARY KEY  (TopicId),
  KEY OwnerId (OwnerId),
  UNIQUE KEY ResourceId (ResourceId),
  KEY ModifiedById (ModifiedById),
  KEY Posts (Posts),
  KEY Modified (Modified),
  KEY Views (Views),
  KEY EditorsPick (EditorsPick),
  KEY Status (Status),
  KEY Priority (Priority),
  KEY CreatedOn (CreatedOn),
  KEY NewItem (NewItem),
  KEY PopItem (PopItem),
  KEY HotItem (HotItem),
  KEY LastPostId (LastPostId)
);

CREATE TABLE Censorship (
  CensorshipId int(11) NOT NULL auto_increment,
  BadWord varchar(80) NOT NULL default '',
  Replacement varchar(80) NOT NULL default '',
  PRIMARY KEY  (CensorshipId)
);

CREATE TABLE Emoticon (
  EmoticonId int(11) NOT NULL auto_increment,
  Name varchar(20) NOT NULL default '',
  KeyStroke varchar(20) NOT NULL default '',
  Enabled int(11) NOT NULL default '1',
  EmotionImage VARCHAR(255) NOT NULL,
  PRIMARY KEY  (EmoticonId),
  KEY Enabled (Enabled),
  KEY EmotionImage (EmotionImage)
);

CREATE TABLE PrivateMessageBody (
  PMBodyId int(11) unsigned NOT NULL auto_increment,
  Subject varchar(255) NOT NULL default '',
  Body text NOT NULL,
  Options tinyint(3) unsigned NOT NULL default '0',
  ReferenceCount smallint(5) unsigned NOT NULL default '2',
  PRIMARY KEY  (PMBodyId),
  KEY ReferenceCount (ReferenceCount)
);

CREATE TABLE PrivateMessages (
  PmId int(11) unsigned NOT NULL auto_increment,
  FromId int(11) unsigned default NULL,
  ToId int(11) unsigned default NULL,
  FolderId tinyint(3) NOT NULL default '-1',
  `Status` tinyint(1) unsigned NOT NULL default '0',
  PMBodyId int(11) unsigned NOT NULL default '0',
  CreatedOn int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (PmId),
  KEY FromId (FromId),
  KEY CreatedOn (CreatedOn),
  KEY ToId (ToId),
  KEY FolderId (FolderId)
);

CREATE TABLE TopicCustomData (
  CustomDataId int(11) NOT NULL auto_increment,
  ResourceId int(10) unsigned NOT NULL default '0',
  KEY ResourceId (ResourceId),
  PRIMARY KEY  (CustomDataId)
);

CREATE TABLE Polls (
  PollId int(11) NOT NULL auto_increment,
  `Name` varchar(255) NOT NULL default '',
  l1_Question text,
  l2_Question text,
  l3_Question text,
  l4_Question text,
  l5_Question text,
  Image varchar(255) NOT NULL default '',
  CreatedOn int(11) unsigned NOT NULL,
  StartDate int(11) unsigned NOT NULL,
  EndDate int(11) unsigned default NULL,
  Priority tinyint(4) NOT NULL default '0',
  RequireLogin tinyint(4) NOT NULL default '0',
  AllowMultipleVotings tinyint(4) NOT NULL default '1',
  AllowComments tinyint(4) NOT NULL default '1',
  `Status` tinyint(4) NOT NULL default '1',
  CachedVotesQty int(11) NOT NULL,
  PRIMARY KEY  (PollId),
  KEY `Status` (`Status`),
  KEY Priority (Priority),
  KEY StartDate (StartDate),
  KEY EndDate (EndDate)
);

CREATE TABLE PollsAnswers (
  AnswerId int(11) NOT NULL auto_increment,
  PollId int(11) NOT NULL,
  l1_Answer text,
  l2_Answer text,
  l3_Answer text,
  l4_Answer text,
  l5_Answer text,
  VotesQty int(11) NOT NULL,
  Priority int(11) NOT NULL default '0',
  Status tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (AnswerId),
  KEY Status (Status),
  KEY Priority (Priority),
  KEY VoteCount (VotesQty),
  KEY PollId (PollId)
);

CREATE TABLE PollsComments (
  CommentId int(11) NOT NULL auto_increment,
  PollId int(11) NOT NULL,
  AnswerId int(11) default NULL,
  CreatedById int(11) NOT NULL default '-2',
  GuestName varchar(255) NOT NULL,
  GuestEmail varchar(255) NOT NULL,
  CommentBody text,
  CreatedOn int(11) NOT NULL,
  UserIP varchar(255) NOT NULL,
  Priority int(11) NOT NULL,
  `Status` tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (CommentId),
  KEY `Status` (`Status`),
  KEY Priority (Priority),
  KEY CreatedOn (CreatedOn),
  KEY AnswerId (AnswerId),
  KEY PollId (PollId),
  KEY CreatedById (CreatedById)
);

CREATE TABLE PollsStatistics (
  StatisticsId int(11) NOT NULL auto_increment,
  PollId int(11) NOT NULL default '0',
  AnswerId int(11) NOT NULL default '0',
  CreatedById int(11) NOT NULL default '-2',
  UserIP varchar(255) NOT NULL,
  AnswerDate int(10) unsigned default NULL,
  PRIMARY KEY  (StatisticsId),
  KEY AnswerId (AnswerId,PollId),
  KEY CreatedById (CreatedById),
  KEY UserIP (UserIP)
);