<?php
/**
* @version	$Id: topics_event_handler.php 11891 2009-07-01 08:08:17Z alex $
* @package	In-Bulletin
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

	class TopicsEventHandler extends kCatDBEventHandler {


		/**
		 * Checks topic lock permission
		 *
		 * @param kEvent $event
		 */
		function CheckPermission(&$event)
		{
			if ($event->Name == 'OnTopicLockToggle') {
				$object =& $event->getObject();
				/* @var $object kCatDBItem */

				if (!$object->isLoaded()) {
					$event->status = erPERM_FAIL;
					return false;
				}

				$category_id = $object->GetDBField('CategoryId');
				$perm_status = $this->Application->CheckPermission('TOPIC.LOCK', 0, $category_id);

				if (!$perm_status) {
					$event->status = erPERM_FAIL;
				}

				return $perm_status;
			}

			return parent::CheckPermission($event);
		}

		/**
		 * Created url part for this module
		 *
		 * @param kEvent $event
		 */
		function BuildEnv(&$event)
		{
			$prefix_special = $event->getPrefixSpecial();
			$url_params = $event->getEventParam('url_params');
			$pass_events = $event->getEventParam('pass_events');

			$query_vars = $this->Application->getUnitOption($event->Prefix, 'QueryString');

			$event_key = array_search('event', $query_vars);
			if ($event_key) {
				// pass through event of this prefix
				unset($query_vars[$event_key]);
			}

			if (!getArrayValue($url_params, $prefix_special.'_event')) {
				// if empty event, then remove it from url
				unset( $url_params[$prefix_special.'_event'] );
			}

			//if pass events is off and event is not implicity passed
			if ( !$pass_events && !isset($url_params[$prefix_special.'_event']) ) {
				unset($url_params[$prefix_special.'_event']); // remove event from url if requested
				//otherwise it will use value from get_var
			}

			if (!$query_vars) {
				return true;
			}

			$processed_params = Array();
			foreach($query_vars as $index => $var_name) {
				//if value passed in params use it, otherwise use current from application
				$var_name = $prefix_special.'_'.$var_name;
				$processed_params[$var_name] =  isset( $url_params[$var_name] ) ? $url_params[$var_name] : $this->Application->GetVar($var_name);
				if ( isset($url_params[$var_name]) ) unset( $url_params[$var_name] );
			}

			$ret = '';

			if (!$processed_params[$prefix_special.'_id']) {
				if ($processed_params[$prefix_special.'_Page'] == 1) {
					// when printing "items" from category, there is 1st page -> nothing from "item prefix" in url
					// and auto-guess pass_category will not be added to url
					$url_params['pass_category'] = 1;
				}
				else {
					$ret .= $processed_params[$prefix_special.'_Page'].'/';
				}
			}

			if ($processed_params[$prefix_special.'_id']) {
				// this allows to fill 3 cache records with one query (see this method for details)
				$category_id = isset($url_params['m_cat_id']) ? $url_params['m_cat_id'] : $this->Application->GetVar('m_cat_id');
				$category_filename = $this->Application->getFilename('c', $category_id);

				// if template is also item template of category, then remove template
				$template = getArrayValue($url_params, 't');

				$mod_rw_helper =& $this->Application->recallObject('ModRewriteHelper');
				/* @var $mod_rw_helper kModRewriteHelper */

				$item_template = $mod_rw_helper->GetItemTemplate($category_id, $event->Prefix);

				if ($template == $item_template || strtolower($template) == '__default__') {
					unset($url_params['t']);
				}

				// get item's filename
				$ret .= 'bb_' . $processed_params[$prefix_special.'_id'].'/';
			}

			$event->setEventParam('url_params', $url_params);
			$event->setEventParam('env_string', mb_strtolower($ret) );
		}

		/**
		 * Process mod_rewrite url part left after previous parser
		 *
		 * @param kEvent $event
		 */
		function ParseEnv(&$event)
		{
			// <module_page>/bb_<item_id>

			$url_parts = $event->getEventParam('url_parts');
			$vars = $event->getEventParam('vars');

			$defaults = Array('id' => 0, 'Page' => 1);
			foreach ($defaults as $var_name => $var_value) {
				$this->Application->SetVar($event->getPrefixSpecial().'_'.$var_name, $var_value);
				$vars[$event->getPrefixSpecial().'_'.$var_name] = $var_value;
			}

			if (!$url_parts) {
//				$event->status = erFAIL;
				return false;
			}

			$ret = '';
			$item_id = false;
			$url_part = end($url_parts);

			if ( is_numeric($url_part) ) {
				// match module page
				$this->Application->SetVar( $event->getPrefixSpecial() . '_Page', $url_part);
				$vars[$event->getPrefixSpecial() . '_Page'] = $url_part;
			}
			elseif (preg_match('/^bb_([\d]+)$/', $url_part, $regs)) {
				// match item's filename
				$item_id = $regs[1];
			}

			if ($item_id !== false) {
				$this->Application->SetVar($event->getPrefixSpecial().'_id', $item_id);
				$vars[$event->getPrefixSpecial().'_id'] = $item_id;
			}
			elseif ($url_part !== 'index') {
				// otherwise category/index.html is parsed as /index.tpl
				array_unshift($url_parts, $url_part);
				$event->status = erFAIL;
			}

			$event->setEventParam('url_parts', $url_parts);
			$event->setEventParam('vars', $vars);
		}

		/**
		 * Lock or unlock topic
		 *
		 * @param kEvent $event
		 */
		function OnToggleLock(&$event)
		{
			$object =& $event->getObject();

			$new_type = $object->GetDBField('TopicType') ? 0 : 1;
			$object->SetDBField('TopicType', $new_type);
			$object->Update();
		}

		/**
		 * Cache topic owner
		 *
		 * @param kEvent $event
		 */
		function OnBeforeItemUpdate(&$event)
		{
			parent::OnBeforeItemUpdate($event);

			$this->cacheItemOwner($event, 'OwnerId', 'PostedBy');
		}

		/**
		 * Cache topic owner
		 *
		 * @param kEvent $event
		 */
		function OnBeforeItemCreate(&$event)
		{
			parent::OnBeforeItemCreate($event);

			$this->cacheItemOwner($event, 'OwnerId', 'PostedBy');

			$object =& $event->getObject();
			/* @var $object kCatDBItem */

			if (!$object->GetDBField('TodayDate')) {
				$object->SetDBField('TodayDate', adodb_date('Y-m-d'));
			}

			$post_helper =& $this->Application->recallObject('PostHelper');
			/* @var $post_helper PostHelper */

			$object->SetDBField('TopicText', $post_helper->CensorText( $object->GetDBField('TopicText') ));
		}

		/**
		 * Creates 1st post when topic is created
		 *
		 * @param kEvent $event
		 */
		function OnAfterItemCreate(&$event)
		{
			parent::OnAfterItemCreate($event);

			if ($event->Special == '-item') {
				// don't create first post when cloning
				return ;
			}

			$object =& $event->getObject();
			/* @var $object kDBItem */

			$post =& $this->Application->recallObject($event->Prefix.'-post', null, Array ('skip_autoload' => true));
			/* @var $post kDBItem */

			$post->SetDBField('Pending', $object->GetDBField('Status') == STATUS_ACTIVE ? 0 : 1);
			$post->SetDBField('Subject', '');
			$post->SetDBField('PostingText', $object->GetDBField('PostingText'));

			$post->SetDBField('ShowSignatures', $object->GetDBField('ShowSignatures'));
			$post->SetDBField('DisableSmileys', $object->GetDBField('DisableSmileys'));
			$post->SetDBField('DisableBBCodes', $object->GetDBField('DisableBBCodes'));

			$post->Create();

			// need to update category topic count here
		}

		/**
		 * Approves 1st post when topic got approved
		 *
		 * @param kEvent $event
		 */
		function OnAfterItemUpdate(&$event)
		{
			if (!$this->Application->IsAdmin()) {
				return ;
			}

			$object =& $event->getObject();
			/* @var $object kCatDBItem */

			if ($object->GetDBField('Posts') == 1) {
				$post =& $this->Application->recallObject($event->Prefix.'-post', null, Array('skip_autoload' => true));
				/* @var $post kDBItem */

				$main_status = $object->GetDBField('Status');
				$post->Load($object->GetDBField('LastPostId'));
				if ($post->isLoaded()) {
					$post->SetDBField('Pending', $main_status == STATUS_ACTIVE ? 0 : 1);
					$post->Update();
				}
			}
		}

		/**
		 * Makes first post body field non-requered when topic has posts already
		 *
		 * @param kEvent $event
		 */
		function OnAfterItemLoad(&$event)
		{
			parent::OnAfterItemLoad($event);

			$object =& $event->getObject();
			/* @var $object kCatDBItem */

			if ($object->GetDBField('Posts') > 0 || !$this->Application->IsAdmin()) {
				$object->setRequired('PostingText', false);
			}
		}

		/**
		 * Locks or unlocks topic
		 *
		 * @param kEvent $event
		 */
		function OnTopicLockToggle(&$event)
		{
			$object =& $event->getObject();
			/* @var $object kCatDBItem */

			$topic_type = $object->GetDBField('TopicType');
			$object->SetDBField('TopicType', $topic_type == 1 ? 0 : 1);
			$object->Update();
		}

		/**
		 * Sets default values to posting options based on persistent session
		 *
		 * @param kEvent $event
		 */
		function OnAfterConfigRead(&$event)
		{
			parent::OnAfterConfigRead($event);

			$fields = $this->Application->getUnitOption($event->Prefix, 'Fields');
			$fields['NotifyOwnerOnChanges']['default'] = (int)$this->Application->RecallPersistentVar('owner_notify');
			$this->Application->setUnitOption($event->Prefix, 'Fields', $fields);

			$virtual_fields = $this->Application->getUnitOption($event->Prefix, 'VirtualFields');
			$virtual_fields['DisableBBCodes']['default'] = (int)!$this->Application->RecallPersistentVar('bbcode');
			$virtual_fields['DisableSmileys']['default'] = (int)!$this->Application->RecallPersistentVar('smileys');
			$virtual_fields['ShowSignatures']['default'] = (int)$this->Application->RecallPersistentVar('show_sig');
			$this->Application->setUnitOption($event->Prefix, 'VirtualFields', $virtual_fields);
		}
	}

?>