<?php

	defined('FULL_PATH') or die('restricted access!');

	/**
	 * Custom event handler class
	 *
	 */
	class CustomEventHandler extends kEventHandler {

		/**
		* Connection to database
		*
		* @var kDBConnection
		* @access public
		*/
		var $Conn;

		function CustomEventHandler()
		{
			parent::kBase();
			$this->Conn =& $this->Application->GetADODBConnection();
		}

		/**
		 * [HOOK] Override cloned sub-items (ie. register extended classes for clones from Reviews, Images)
		 *
		 * @param kEvent $event
		 */
		function OnOverrideClonedSubItems(&$event)
		{
			# register EReviewEventHandler class as extented from cloned ReviewEventHandler for article reviews ("n" prefix)
//			$this->Application->registerClass('EReviewEventHandler', dirname(__FILE__) . '/e_review_eh.php', 'n-rev_EventHandler');
		}

		/**
		 * [HOOK] Modify config stored in "categories_config.php" without extending CategoriesEventHandler class
		 *
		 * @param kEvent $event
		 */
		function OnModifyCategoriesConfig(&$event)
		{
			# get Fields configuration from /core/units/categories/categories_config.php
			$fields = $this->Application->getUnitOption($event->MasterEvent->Prefix, 'Fields');

			# set configuration fields
			$this->Application->setUnitOption($event->MasterEvent->Prefix, 'Fields', $fields);
		}

	}