<?php

	defined('FULL_PATH') or die('restricted access!');

	/**
	 * Custom event handler class
	 *
	 */
	class CustomEventHandler extends kEventHandler {

		/**
		* Connection to database
		*
		* @var kDBConnection
		* @access public
		*/
		var $Conn;

		function CustomEventHandler()
		{
			parent::kBase();
			$this->Conn =& $this->Application->GetADODBConnection();
		}

		/**
		 * [HOOK] Modify config stored in "categories_config.php" without extending CategoriesEventHandler class
		 *
		 * @param kEvent $event
		 */
		function OnModifyCategoriesConfig(&$event)
		{
			# get Fields configuration from /core/units/categories/categories_config.php
			$fields = $this->Application->getUnitOption($event->MasterEvent->Prefix, 'Fields');

			# set configuration fields
			$this->Application->setUnitOption($event->MasterEvent->Prefix, 'Fields', $fields);
		}

	}