<?php

	defined('FULL_PATH') or die('restricted access!');

	/**
	 * Extends/overrides methods of default ProductsEventHandler class
	 *
	 */
	class EProductEventHandler extends ProductsEventHandler {

		/**
		 * Allows to override standart permission mapping
		 *
		 */
		function mapPermissions()
		{
			parent::mapPermissions();

			$permissions = Array (
				# admin
				'OnCustomEvent1' => Array ('self' => true),

				# front
				'OnCustomEvent2' => Array ('self' => true),
			);

			$this->permMapping = array_merge($this->permMapping, $permissions);
		}

		/**
		 * Permission exceptions
		 *
		 * @param kEvent $event
		 */
		function CheckPermission(&$event)
		{
			$skip_permissions_check_events = Array (
				'OnAnotherCustomEvent',
			);

			if ( in_array($event->Name, $skip_permissions_check_events) ) {
				return true;
			}

			return parent::CheckPermission($event);
		}

		/**
		 * Updates structure config
		 *
		 * @param kEvent $event
		 */
		function OnAfterConfigRead(&$event)
		{
			parent::OnAfterConfigRead($event);

			# 1. Regular Fields from /in-commerce/units/products/products_config.php
			$fields = $this->Application->getUnitOption($event->Prefix, 'Fields'); #get regular fields
//			$fields['Status']['default'] = 1; #add/edit field configuration (make default = 1)
			$this->Application->setUnitOption($event->Prefix, 'Fields', $fields); #save regular fields


			# 2. Virtual Fields from /in-commerce/units/products/products_config.php
			$virtual_fields = $this->Application->getUnitOption($event->Prefix, 'VirtualFields'); #get virtual fields
//			$virtual_fields['Qty']['default'] = 1; #add/edit field configuration
			$this->Application->setUnitOption($event->Prefix, 'VirtualFields', $virtual_fields); # save virtual fields
		}

		/**
		 * Sets custom query for the list
		 *
		 * @param kEvent $event
		 */
		function SetCustomQuery(&$event)
		{
			parent::SetCustomQuery($event);

			$object =& $event->getObject();
			/* @var $object kDBList */

			# identifying event based on special and setting filter
			if ( $event->Special == 'custom-special' ) {
//				$object->addFilter('primary_filter', '%1$s.Status = '.STATUS_DISABLED);
			}

			# identifying event based not admin condition and setting filter
			if ( !$this->Application->IsAdmin() ) {
//				$object->addFilter('status_filter', '%1$s.Status = '.STATUS_ACTIVE);
			}
		}

		/**
		 * Before new item created
		 *
		 * @param kEvent $event
		 */
		function OnBeforeItemCreate(&$event)
		{
			parent::OnBeforeItemCreate($event);


		}

		/**
		 * Before existing item updated
		 *
		 * @param kEvent $event
		 */
		function OnBeforeItemUpdate(&$event)
		{
			parent::OnBeforeItemUpdate($event);


		}

		/**
		 * Before item deleted
		 *
		 * @param kEvent $event
		 */
		function OnBeforeItemDelete(&$event)
		{
			parent::OnBeforeItemDelete($event);


		}

		/**
		 * After item loaded
		 *
		 * @param kEvent $event
		 */
		function OnBeforeItemLoad(&$event)
		{
			parent::OnBeforeItemLoad($event);


		}


		/**
		 * After new item created
		 *
		 * @param kEvent $event
		 */
		function OnAfterItemCreate(&$event)
		{
			parent::OnAfterItemCreate($event);


		}

		/**
		 * After existing item updated
		 *
		 * @param kEvent $event
		 */
		function OnAfterItemUpdate(&$event)
		{
			parent::OnAfterItemUpdate($event);


		}

		/**
		 * After item deleted
		 *
		 * @param kEvent $event
		 */
		function OnAfterItemDelete(&$event)
		{
			parent::OnAfterItemDelete($event);


		}

		/**
		 * After item loaded
		 *
		 * @param kEvent $event
		 */
		function OnAfterItemLoad(&$event)
		{
			parent::OnAfterItemLoad($event);


		}

	}