<?php

	defined('FULL_PATH') or die('restricted access!');

	/**
	 * Extends default LinksEventHandler class
	 *
	 */
	class ELinkEventHandler extends LinksEventHandler {

		/**
		 * Allows to override standard permission mapping
		 *
		 * @return void
		 * @access protected
		 * @see kEventHandler::$permMapping
		 */
		function mapPermissions()
		{
			parent::mapPermissions();

			$permissions = Array (
				'OnCustomEvent1' => Array ('self' => true),
				'OnCustomEvent2' => Array ('self' => true),
			);

			$this->permMapping = array_merge($this->permMapping, $permissions);
		}

		/**
		 * Checks user permission to execute given $event
		 *
		 * @param kEvent $event
		 * @return bool
		 * @access public
		 */
		public function CheckPermission(kEvent $event)
		{
			$skip_permissions_check_events = Array (
				'OnAnotherCustomEvent',
			);

			if ( in_array($event->Name, $skip_permissions_check_events) ) {
				return true;
			}

			return parent::CheckPermission($event);
		}

		/**
		 * Occurs, when config was parsed, allows to change config data dynamically
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnAfterConfigRead(kEvent $event)
		{
			parent::OnAfterConfigRead($event);

			# 1. Regular Fields from /in-link/units/links/links_config.php
			$fields = $this->Application->getUnitOption($event->Prefix, 'Fields'); #get regular fields
//			$fields['Status']['default'] = STATUS_ACTIVE; #add/edit configuration (make default = STATUS_ACTIVE)
			$this->Application->setUnitOption($event->Prefix, 'Fields', $fields); #save fields

			# 2. Virtual Fields from /in-link/units/links/links_config.php
			$virtual_fields = $this->Application->getUnitOption($event->Prefix, 'VirtualFields'); #get virtual fields
//			$virtual_fields['UserName']['default'] = ''; #add/edit configuration
			$this->Application->setUnitOption($event->Prefix, 'VirtualFields', $virtual_fields); #save virtual fields
		}

		/**
		 * Apply any custom changes to list's sql query
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 * @see kDBEventHandler::OnListBuild()
		 */
		protected function SetCustomQuery(kEvent $event)
		{
			parent::SetCustomQuery($event);

			/** @var kDBList $object */
			$object = $event->getObject();

			# identifying event based on special and setting filter
			if ( $event->Special == 'custom-special' ) {
//				$object->addFilter('primary_filter', '%1$s.Status = ' . STATUS_DISABLED);
			}

			# identifying event based not admin condition and setting filter
			if ( !$this->Application->isAdminUser ) {
//				$object->addFilter('status_filter', '%1$s.Status = ' . STATUS_ACTIVE);
			}
		}

		/**
		 * Makes reciprocal check on link, when it is created
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnBeforeItemCreate(kEvent $event)
		{
			parent::OnBeforeItemCreate($event);


		}

		/**
		 * Makes reciprocal check on link, when it is updated
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnBeforeItemUpdate(kEvent $event)
		{
			parent::OnBeforeItemUpdate($event);


		}

		/**
		 * Occurs before deleting item, id of item being
		 * deleted is stored as 'id' event param
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnBeforeItemDelete(kEvent $event)
		{
			parent::OnBeforeItemDelete($event);


		}

		/**
		 * Occurs before loading item, 'id' parameter
		 * allows to get id of item being loaded
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnBeforeItemLoad(kEvent $event)
		{
			parent::OnBeforeItemLoad($event);


		}


		/**
		 * Sets values for import process
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnAfterItemCreate(kEvent $event)
		{
			parent::OnAfterItemCreate($event);


		}

		/**
		 * Occurs after updating item
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnAfterItemUpdate(kEvent $event)
		{
			parent::OnAfterItemUpdate($event);


		}

		/**
		 * Occurs after deleting item, id of deleted item
		 * is stored as 'id' param of event
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnAfterItemDelete(kEvent $event)
		{
			parent::OnAfterItemDelete($event);


		}

		/**
		 * Occurs after loading item, 'id' parameter
		 * allows to get id of item that was loaded
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnAfterItemLoad(kEvent $event)
		{
			parent::OnAfterItemLoad($event);


		}

	}