<?php
defined('FULL_PATH') or die('restricted access!');

/**
 * Widgets Event Handler (sample)
 *
 */
class WidgetEventHandler extends kDBEventHandler {

	/**
	 * Allows to override standard permission mapping
	 *
	 * @return void
	 * @access protected
	 * @see kEventHandler::$permMapping
	 */
	protected function mapPermissions()
	{
		parent::mapPermissions();

		$permissions = array(
			'OnItemBuild' => array('self' => true),
			'OnRecalculatePriorities' => array('self' => 'add|edit'),
			'OnCustomEvent' => array('self' => true),
		);

		$this->permMapping = array_merge($this->permMapping, $permissions);
	}

	/**
	 * Checks user permission to execute given $event
	 *
	 * @param kEvent $event
	 * @return bool
	 * @access public
	 */
	public function CheckPermission(kEvent $event)
	{
		$skip_permissions_check_events = Array (
			'OnAnotherCustomEvent',
		);

		if ( in_array($event->Name, $skip_permissions_check_events) ) {
			return true;
		}

		return parent::CheckPermission($event);
	}

	/**
	 * Define alternative event processing method names
	 *
	 * @return void
	 */
	protected function mapEvents()
	{
		parent::mapEvents();

		$events_map = array(
			'OnMassMoveUp' => 'OnChangePriority',
			'OnMassMoveDown' => 'OnChangePriority',
		);

		$this->eventMethods = array_merge($this->eventMethods, $events_map);
	}

	/**
	 * Processes OnMassMoveUp, OnMassMoveDown events
	 *
	 * @param kEvent $event Event.
	 *
	 * @return void
	 */
	protected function OnChangePriority(kEvent $event)
	{
		$this->Application->SetVar('priority_prefix', $event->getPrefixSpecial());
		$event->CallSubEvent('priority:' . $event->Name);
	}

	/**
	 * Completely recalculates priorities in current category
	 *
	 * @param kEvent $event Event.
	 *
	 * @return void
	 */
	protected function OnRecalculatePriorities(kEvent $event)
	{
		$this->Application->SetVar('priority_prefix', $event->getPrefixSpecial());
		$event->CallSubEvent('priority:' . $event->Name);
	}

	/**
	 * [HOOK] Connects to priority unit.
	 *
	 * @param kEvent $event Event.
	 *
	 * @return void
	 */
	protected function OnModifyPrioritiesConfig(kEvent $event)
	{
		$prefixes = $this->Application->getUnitOption($event->MasterEvent->Prefix, 'ProcessPrefixes');
		$prefixes[] = $event->Prefix;
		$this->Application->setUnitOption($event->MasterEvent->Prefix, 'ProcessPrefixes', $prefixes);
	}

	/**
	 * Set custom query for the list
	 *
	 * @param kEvent $event
	 */
	function OnCustomEvent($event)
	{
		$object = $event->getObject();
		/* @var $object kDBList */

	}

	/**
	 * Apply any custom changes to list's sql query
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 * @see kDBEventHandler::OnListBuild()
	 */
	protected function SetCustomQuery(kEvent $event)
	{
		parent::SetCustomQuery($event);

		$object = $event->getObject();
		/* @var $object kDBList */

		# identifying event based on special and setting filter
		if ( $event->Special == 'custom-special' ) {
//				$object->addFilter('primary_filter', '%1$s.Status = ' . STATUS_DISABLED);
		}
	}

	/**
	 * Occurs before creating item
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnBeforeItemCreate(kEvent $event)
	{
		parent::OnBeforeItemCreate($event);

	}

	/**
	 * Occurs before updating item
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnBeforeItemUpdate(kEvent $event)
	{
		parent::OnBeforeItemUpdate($event);

	}

	/**
	 * Occurs before deleting item, id of item being
	 * deleted is stored as 'id' event param
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnBeforeItemDelete(kEvent $event)
	{
		parent::OnBeforeItemDelete($event);


	}

	/**
	 * Occurs before loading item, 'id' parameter
	 * allows to get id of item being loaded
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnBeforeItemLoad(kEvent $event)
	{
		parent::OnBeforeItemLoad($event);


	}


	/**
	 * Occurs after creating item
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnAfterItemCreate(kEvent $event)
	{
		parent::OnAfterItemCreate($event);


	}

	/**
	 * Occurs after updating item
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnAfterItemUpdate(kEvent $event)
	{
		parent::OnAfterItemUpdate($event);


	}

	/**
	 * Occurs after deleting item, id of deleted item
	 * is stored as 'id' param of event
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnAfterItemDelete(kEvent $event)
	{
		parent::OnAfterItemDelete($event);


	}

	/**
	 * Loads user images
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnAfterItemLoad(kEvent $event)
	{
		parent::OnAfterItemLoad($event);


	}

	/**
	 * Builds/parses widget part of url
	 *
	 * @param int $rewrite_mode Mode in what rewrite listener was called. Possbile two modes: REWRITE_MODE_BUILD, REWRITE_MODE_PARSE.
	 * @param string $prefix Prefix, that listener uses for system integration
	 * @param Array $params Params, that are used for url building or created during url parsing.
	 * @param Array $url_parts Url parts to parse (only for parsing).
	 * @param bool $keep_events Keep event names in resulting url (only for building).
	 * @return bool Return true to continue to next listener; return false (when building) not to rewrite given prefix; return false (when parsing) to stop processing at this listener.
	 */
	function WidgetRewriteListener($rewrite_mode = REWRITE_MODE_BUILD, $prefix, &$params, &$url_parts, $keep_events = false)
	{
		if ($rewrite_mode == REWRITE_MODE_BUILD) {
			return $this->WidgetRewriteBuilder($rewrite_mode, $prefix, $params, $url_parts, $keep_events);
		}

		if ($rewrite_mode == REWRITE_MODE_PARSE) {
			return $this->WidgetRewriteParser($rewrite_mode, $prefix, $params, $url_parts);
		}

		return true;
	}

	/**
	 * Builds/parses widget part of url
	 *
	 * @param int $rewrite_mode Mode in what rewrite listener was called. Possbile two modes: REWRITE_MODE_BUILD, REWRITE_MODE_PARSE.
	 * @param string $prefix Prefix, that listener uses for system integration
	 * @param Array $params Params, that are used for url building or created during url parsing.
	 * @param Array $url_parts Url parts to parse (only for parsing).
	 * @param bool $keep_events Keep event names in resulting url (only for building).
	 * @return bool Return true to continue to next listener; return false (when building) not to rewrite given prefix; return false (when parsing) to stop processing at this listener.
	 */
	function WidgetRewriteBuilder($rewrite_mode = REWRITE_MODE_BUILD, $prefix, &$params, &$url_parts, $keep_events = false)
	{
		$template = $this->Application->getPhysicalTemplate($params['t']);

		if ( $template == 'widgets/widget_detail' ) {
			// this is default template for this prefix, so don't add it to resulting url
			$params['pass_template'] = false;
		}

		$rewrite_processor = $this->Application->recallObject('kRewriteUrlProcessor');
		/* @var $rewrite_processor kRewriteUrlProcessor */

		$processed_params = $rewrite_processor->getProcessedParams($prefix, $params, $keep_events);

		if ( $processed_params === false ) {
			return '';
		}

		$ret = Array ('', '');

		$filename = isset($params[$prefix . '_filename']) ? $params[$prefix . '_filename'] : $this->Application->GetVar($prefix . '_filename');
		unset($params[$prefix . '_filename']);

		if ( $processed_params[$prefix . '_id'] > 0 ) {
			// add id
			if ( !$filename ) {
				$sql = 'SELECT Title
						FROM ' . TABLE_PREFIX . 'Widgets
						WHERE WidgetId = ' . $processed_params[$prefix . '_id'];
				$filename = $this->Conn->GetOne($sql);
			}

			$ret[0] .= 'widgets/' . $filename . '/';
		}
		elseif ( $processed_params[$prefix . '_Page'] > 1 ) {
			// add page, only when ID is missing
			$ret[1] .= $processed_params[$prefix . '_Page'] . '/';
		}

		$ret[0] = rtrim($ret[0], '/');
		$ret[1] = rtrim($ret[1], '/');

		return array_map('mb_strtolower', $ret);
	}

	/**
	 * Builds/parses widget part of url
	 *
	 * @param int $rewrite_mode Mode in what rewrite listener was called. Possbile two modes: REWRITE_MODE_BUILD, REWRITE_MODE_PARSE.
	 * @param string $prefix Prefix, that listener uses for system integration
	 * @param Array $params Params, that are used for url building or created during url parsing.
	 * @param Array $url_parts Url parts to parse (only for parsing).
	 * @return bool Return true to continue to next listener; return false (when building) not to rewrite given prefix; return false (when parsing) to stop processing at this listener.
	 */
	function WidgetRewriteParser($rewrite_mode = REWRITE_MODE_BUILD, $prefix, &$params, &$url_parts)
	{
		$widget_id = 0;
		$widget_filename = '';
		$widget_index = array_search('widgets', $url_parts);

		if ( $widget_index !== false && isset($url_parts[$widget_index + 1]) ) {
			$widget_filename = $url_parts[$widget_index + 1];
		}

		$rewrite_processor = $this->Application->recallObject('kRewriteUrlProcessor');
		/* @var $rewrite_processor kRewriteUrlProcessor */

		if ( $widget_filename ) {
			$sql = 'SELECT WidgetId
					FROM ' . TABLE_PREFIX . 'Widgets
					WHERE Title = ' . $this->Conn->qstr($widget_filename);
			$widget_id = $this->Conn->GetOne($sql);

			if ( $widget_id ) {
				$params[$this->Prefix . '_id'] = $widget_id;
				$params[$this->Prefix . '_filename'] = $widget_filename;
				$params['pass'][] = $this->Prefix;

				$rewrite_processor->partParsed('widgets');
				$rewrite_processor->partParsed($widget_filename);
			}
		}

		if ( $widget_id && !$rewrite_processor->moreToParse() ) {
			// widget was last url part - use default template
			$params['t'] = 'widgets/widget_detail';
		}

		return true;
	}
}
