<?php
/**
* @version	$Id: compiler.php 15420 2012-06-28 10:18:07Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class NParserCompiler extends kHelper {

	var $Errors = array();
	var $Templates = array();

	function CompileTemplatesStep()
	{
		$templates = $this->Application->RecallVar('templates_to_compile');
		if ( !$templates ) {
			// build $templates
			$templates = $this->FindTemplates();
		}
		else {
			$templates = unserialize($templates);
		}

		$total = count($templates);
		$current = $this->Application->RecallVar('current_template_to_compile');
		if ( !$current ) {
			$current = 0;
		}

		$errors = $this->Application->RecallVar('compile_errors');
		if ( $errors ) {
			$this->Errors = unserialize($errors);
		}

		kUtil::safeDefine('DBG_NPARSER_FORCE_COMPILE', 1);

		$i = $current;
		$this->Application->InitParser(true);

		while ( $i < $total && $i < ($current + 20) ) {
			$a_template = $templates[$i];

			try {
				$this->Application->Parser->CheckTemplate($a_template['module'] . '/' . $a_template['path']);
			} catch ( Exception $e ) {
				$this->Errors[] = Array ('message' => $e->getMessage(), 'exception_class' => get_class($e), 'file' => $e->getFile(), 'line' => $e->getLine());
			}

			$i++;
		}

		$this->Application->StoreVar('current_template_to_compile', $i);
		$this->Application->StoreVar('templates_to_compile', serialize($templates));
		$this->Application->StoreVar('compile_errors', serialize($this->Errors));
		$res = floor(($current / $total) * 100);

		if ( $res == 100 || $current >= $total ) {
			$this->Application->RemoveVar('templates_to_compile');
			$this->Application->RemoveVar('current_template_to_compile');
			$this->Application->Redirect($this->Application->GetVar('finish_template'));
		}

		echo $res;
	}

	function FindTemplates()
	{
		$this->Templates = Array ();

		// find admin templates
		foreach ($this->Application->ModuleInfo as $module => $options) {
			if ($module == 'In-Portal') {
				// don't check In-Portal admin templates, because it doesn't have them
				continue;
			}

			$template_path = '/' . $options['Path'] . 'admin_templates';
			$options['Path'] = $template_path;

			$this->FindTemplateFiles($template_path, $options);
		}

		// find Front-End templates (from enabled themes only)
		$sql = 'SELECT Name
				FROM ' . $this->Application->getUnitOption('theme', 'TableName') . '
				WHERE Enabled = 1';
		$themes = $this->Conn->GetCol($sql);

		$options = Array ();
		foreach ($themes as $theme_name) {
			$template_path = '/themes/' . $theme_name;
			$options['Name'] = 'theme:' . $theme_name;
			$options['Path'] = $template_path;

			$this->FindTemplateFiles($template_path, $options);
		}

		return $this->Templates;
	}

	/**
	 * Recursively collects all TPL file across whole installation
	 *
	 * @param string $folder_path
	 * @param Array $options
	 * @return void
	 */
	function FindTemplateFiles($folder_path, $options)
	{
		// if FULL_PATH = "/" ensure, that all "/" in $folderPath are not deleted
		$reg_exp = '/^' . preg_quote(FULL_PATH, '/') . '/';
		$folder_path = preg_replace($reg_exp, '', $folder_path, 1); // this make sense, since $folderPath may NOT contain FULL_PATH

		$iterator = new DirectoryIterator(FULL_PATH . $folder_path);
		/* @var $file_info DirectoryIterator */

		foreach ($iterator as $file_info) {
			$filename = $file_info->getFilename();
			$full_path = $file_info->getPathname();

			if ( $file_info->isDir() && !$file_info->isDot() && $filename != '.svn' && $filename != 'CVS' ) {
				$this->FindTemplateFiles($full_path, $options);
			}
			elseif ( pathinfo($full_path, PATHINFO_EXTENSION) == 'tpl' ) {
				$this->Templates[] = Array (
					'module' => mb_strtolower( $options['Name'] ),
					'path' => str_replace(FULL_PATH . $options['Path'] . '/', '', preg_replace('/\.tpl$/', '', $full_path))
				);
			}
		}
	}

}