<?php
	ob_start();
?>
<tr class="table-color2">
	<td class="text" colspan="2" valign="middle">
		<table cellpadding="0" cellspacing="0">
			<tr>
				<td valign="top">
					<input type="checkbox" %3$s name="modules[]" id="module_%1$s" value="%1$s" style="margin-top: 8px;"/>
				</td>
				<td valign="top">
					<label for="module_%1$s" style="">%2$s</label>
					<div style="font-weight: bold; color: red;">%4$s</div>
				</td>
			</tr>
		</table>
	</td>
</tr>
<?php
	$module_tpl = ob_get_clean();
	echo '<br/><p>&nbsp;<strong>Please select Modules you would like to install:</strong></p>';
	$first_time = $this->GetVar('step') != $this->currentStep; // data from this step was not submitted yet
	$selected = $this->GetVar('modules');
	if (!$selected) {
		// preselect interface modules
		$selected = Array ('core');
	}

	$modules_helper = $this->Application->recallObject('ModulesHelper');
	/* @var $modules_helper kModulesHelper */

	$licensed_modules = array_map('strtolower', $modules_helper->_GetModules());

	$modules = $this->ScanModules();
	foreach ($modules as $module) {
		$module_version = $this->toolkit->GetMaxModuleVersion('modules/' . $module . '/');
		$prerequisites_errors = $this->toolkit->CheckPrerequisites('modules/' . $module . '/', Array ($module_version), 'install');

		$license_module = $module;

		if (!in_array(strtolower($license_module), $licensed_modules)) {
			// when module isn't licensed user can't install it
			continue; // option #1: don't show non-licensed modules
			array_unshift($prerequisites_errors, 'Module not licensed'); // option #2: show warning under module name
		}

		if ($prerequisites_errors) {
			// disable checkbox, when some of prerequisites not passed
			$checked = 'disabled';
		}
		else {
			// preserve user selected checked status
			$checked = in_array($module, $selected) || $first_time ? 'checked="checked"' : '';
		}

		$error_msg = $prerequisites_errors ? implode('<br />', $prerequisites_errors) : '';
		$module_string = $this->toolkit->getModuleString($module, $module_version);

		echo sprintf($module_tpl, $module, $module_string, $checked, $error_msg);
	}
?>