	// color Selector

	var aColors = '000000,993300,333300,003300,003366,000080,333399,333333,800000,FF6600,808000,808080,008080,0000FF,666699,808080,FF0000,FF9900,99CC00,339966,33CCCC,3366FF,800080,999999,FF00FF,FFCC00,FFFF00,00FF00,00FFFF,00CCFF,993366,C0C0C0,FF99CC,FFCC99,FFFF99,CCFFCC,CCFFFF,99CCFF,CC99FF,FFFFFF';
	var $color_selector_field = '';
	
	function InitColorSelector()
	{
		var $selector = document.getElementById('colorSelector_div');
		
		if( !isset($selector) )
		{
			var $selector = document.createElement('DIV');
			$selector.id = 'colorSelector_div';
			$selector.className = 'table_color1';
			$selector.style.width = '178px';
			$selector.style.borderWidth = '1px';
			$selector.style.borderColor = '#000000';
			$selector.style.display = 'none';
			$selector.style.position = 'absolute';
			$selector.style.borderStyle = 'solid';
			
			var $s_table = document.createElement('TABLE');
			$s_table.id = 'colorSelector';
			$selector.appendChild($s_table);
			document.body.appendChild($selector);

			var oTable = document.getElementById('colorSelector');
			var iCounter = 0;
			aColors = aColors.split(',');

			while(iCounter < aColors.length)
			{
				var oRow = oTable.insertRow(-1);
				for(var i = 0; i < 8 && iCounter < aColors.length; i++, iCounter++)
				{
					var $cell = document.createElement('TD');
					$cell.innerHTML = '<div class="ColorBox" style="background-color: #'+aColors[iCounter]+'"></div>';
					$cell.onmouseover = this.colorMouseOver;
					$cell.onmouseout = this.colorMouseOut;
					$cell.onclick = this.colorClick;
					$cell.setAttribute('ColorIndex', iCounter);
					var oDiv=oRow.insertCell(-1).appendChild($cell);
				};
			}
		}
	}
	
	function updateColor($event,$color_id)
	{
		document.getElementById('color_'+$color_id).style.backgroundColor = document.getElementById($color_id).value;
	}
	
	function colorMouseOver($e)
	{
		if(!$e) $e = window.event;
		//print_pre(this);
		this.parentNode.style.backgroundColor = '#C8D3E2';
		this.parentNode.style.borderColor = '#7196CC';
		
	}
	
	function colorMouseOut($e, $element)
	{
		if(!$e) $e = window.event;
		if(!$element) $element = this;
		$element.parentNode.style.backgroundColor = '#F6F6F6';
		$element.parentNode.style.borderColor = '#F6F6F6';
	}
	
	function colorClick($e)
	{
		if(!$e) $e = window.event;
		var $color = aColors[ this.getAttribute('ColorIndex') ];
		
		document.getElementById('color_'+$color_selector_field).style.backgroundColor = $color;
		document.getElementById($color_selector_field).value = '#' + $color;
		document.getElementById('colorSelector_div').style.display = 'none';
		
		colorMouseOut($e, this);
	}
	
	function openColorSelector($e, $field)
	{
		$color_selector_field = $field;
		var $div = document.getElementById('colorSelector_div');

		var posx = 0;
		var posy = 0;
		if (!$e) var $e = window.event;
		if ($e.pageX || $e.pageY)
		{
			posx = $e.pageX;
			posy = $e.pageY;
		}
		else if ($e.clientX || $e.clientY)
		{
			posx = $e.clientX + document.body.scrollLeft;
			posy = $e.clientY + document.body.scrollTop;
		}

		$div.style.left = posx;
		$div.style.top = posy;
		$div.style.display = 'block';
	}
