<?php
/**
* @version	$Id: email_events_config.php 14537 2011-09-18 14:19:48Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'emailevents',
		'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'EmailEventsEventsHandler', 'file' => 'email_events_event_handler.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'EmailEventTagProcessor', 'file' => 'email_event_tp.php', 'build_event' => 'OnBuild'),

		'AutoLoad' => true,

		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'PerPage',
			4 => 'event',
			5 => 'mode',
		),

		'IDField' => 'EventId',
		'StatusField' => Array ('Enabled'),
		'TitleField' => 'Event',

		'TitlePresets' => Array (
			'default' => Array (
				'new_status_labels' => Array ('emailevents' => '!la_title_Adding_E-mail!'),
				'edit_status_labels' => Array ('emailevents' => '!la_title_EditingEmailEvent!' /*'!la_title_Editing_E-mail!'*/),
				'new_titlefield' => Array ('emailevents' => '!la_title_NewEmailEvent!'),
			),

			// for separate grid with email editing
			'email_message_list' => Array (
				'prefixes' => Array ('emailevents_List'), 'format' => "!la_title_EmailMessages!",
				'toolbar_buttons' => Array ('new_item', 'edit', 'delete', 'approve', 'decline', 'frontend_mail', 'view', 'dbl-click'),
			),

			'email_message_edit' => Array (
				'prefixes' => Array ('emailevents'),
				'format' => '#emailevents_status# - #emailevents_titlefield# - !la_section_General!',
				'toolbar_buttons' => Array ('select', 'cancel', 'reset_edit', 'prev', 'next'),
			),

			'email_message_edit_settings' => Array (
				'prefixes' => Array ('emailevents'),
				'format' => '#emailevents_status# - #emailevents_titlefield# - !la_section_Settings!',
				'toolbar_buttons' => Array ('select', 'cancel', 'reset_edit', 'prev', 'next'),
			),

			// for mass mailing
			'email_send_form' => Array ('prefixes' => Array (), 'format' => '!la_title_SendEmail!'),
			'email_send' => Array ('prefixes' => Array (), 'format' => '!la_title_SendingPreparedEmails!. !la_title_PleaseWait!'),
			'email_send_complete' => Array ('prefixes' => Array (), 'format' => '!la_title_SendMailComplete!'),
		),

		'EditTabPresets' => Array (
			'Default' => Array (
				'general' => Array ('title' => 'la_tab_General', 't' => 'languages/email_message_edit', 'priority' => 1),
				'settings' => Array ('title' => 'la_tab_Settings', 't' => 'languages/email_message_settings', 'priority' => 2),
			),
		),

		'PermSection' => Array ('main' => 'in-portal:configemail'),

		'Sections' => Array (
			'in-portal:configemail'	=>	Array (
				'parent'		=>	'in-portal:site',
				'icon'			=>	'email_templates',
				'label'			=>	'la_tab_E-mails',
				'url'			=>	Array ('t' => 'languages/email_message_list', 'pass' => 'm'),
				'permissions'	=>	Array ('view', 'add', 'edit', 'delete'),
				'priority'		=>	5,
				'type'			=>	stTREE,
			),
		),

		'TableName' => TABLE_PREFIX . 'Events',

		'ListSQLs' => Array (
			'' => '	SELECT %1$s.* %2$s FROM %1$s',
		),

		'ListSortings' => Array (
			'' => Array (
				'ForcedSorting' => Array ('Enabled' => 'desc'),
				'Sorting' => Array ('Event' => 'asc'),
			),
			'module' => Array (
				'ForcedSorting' => Array ('Enabled' => 'desc'),
				'Sorting' => Array ('Description' => 'asc')
			),
		),

		'Fields' => Array (
			'EventId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
            'Event' => Array ('type' => 'string', 'not_null' => 1, 'unique' => Array ('Type'), 'required' => 1, 'default' => ''),
			'Headers' => Array ('type' => 'string', 'default' => NULL),
            'ReplacementTags' => Array ('type' => 'string', 'default' => NULL),

			'AllowChangingSender' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter',
				'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
				'not_null' => 1, 'default' => 0
			),
			'CustomSender' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (0 => 'la_opt_DefaultAddress', 1 => 'la_opt_CustomSender'), 'use_phrases' => 1,
				'not_null' => 1, 'default' => 0
			),
			'SenderName' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
			'SenderAddressType' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_opt_Email', 2 => 'la_opt_User'), 'use_phrases' => 1,
				'not_null' => 1, 'error_field' => 'SenderAddress', 'default' => 0
			),
			'SenderAddress' => Array (
				'type' => 'string', 'max_len' => 255,
				'error_msgs' => Array (
					'invalid_email' => '!la_err_invalid_format!',
					'invalid_user' => '!la_error_UserNotFound!',
				),
				'not_null' => 1, 'default' => ''
			),
			'AllowChangingRecipient' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
				'not_null' => 1, 'default' => 0
			),
			'CustomRecipient' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (0 => 'la_opt_DefaultAddress', 1 => 'la_opt_CustomRecipients'), 'use_phrases' => 1,
				'not_null' => 1, 'default' => 0
			),
			'Recipients' => Array ('type' => 'string', 'default' => NULL),

            'Subject' => Array (
				'type' => 'string',
				'formatter' => 'kMultiLanguage', 'db_type' => 'text',
				'error_msgs' => Array ('parsing_error' => '!la_error_ParsingError!'),
				'required' => 1, 'default' => null
			),

			'Body' => Array (
				'type' => 'string',
				'formatter' => 'kMultiLanguage', 'db_type' => 'longtext',
				'error_msgs' => Array ('parsing_error' => '!la_error_ParsingError!'),
				'required' => 1, 'default' => null
			),

			'MessageType' => Array (
				'type' => 'string',
				'formatter' => 'kOptionsFormatter', 'options' => Array ('text' => 'la_Text', 'html' => 'la_Html'), 'use_phrases' => 1,
				'not_null' => 1, 'required' => 1, 'default' => 'text'
			),

            'Enabled' => Array (
            	'type' => 'int',
            	'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
            	'not_null' => 1, 'default' => 1
            ),

            'FrontEndOnly' => Array (
            	'type' => 'int',
            	'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
            	'not_null' => 1, 'default' => 0
            ),

            'Module' => Array (
            	'type' => 'string',
            	'formatter' => 'kOptionsFormatter', 'options' => Array (),
            	'not_null' => 1, 'required' => 1, 'default' => 'Core'
            ),

            'Description' => Array ('type' => 'string', 'default' => NULL),

            'Type' => Array (
            	'type' => 'int',
            	'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Text_Admin', 0 => 'la_Text_User'), 'use_phrases' => 1,
            	'not_null' => 1, 'unique' => Array ('Event'), 'required' => 1, 'default' => 0
            ),
    	),

		'VirtualFields' => Array (
			'RecipientType' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'To', 2 => 'Cc', 3 => 'Bcc'),
				'default' => 1
			),
			'RecipientName' => Array ('type' => 'string', 'max_len' => 255, 'default' => ''),
			'RecipientAddressType' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_opt_Email', 2 => 'la_opt_User', 3 => 'la_opt_Group'), 'use_phrases' => 1,
				'error_field' => 'RecipientAddress', 'default' => 0
			),
			'RecipientAddress' => Array (
				'type' => 'string', 'max_len' => 255,
				'error_msgs' => Array (
					'invalid_email' => '!la_err_invalid_format!',
					'invalid_user' => '!la_error_UserNotFound!',
					'invalid_group' => '!la_error_GroupNotFound!',
				),
				'default' => ''
			),

			'Tag' => Array ('type' => 'string', 'default' => ''),
			'Replacement' => Array ('type' => 'string', 'default' => ''),
			'ReplacementTagsXML' => Array ('type' => 'string', 'default' => ''),
		),

		'Grids'	=> Array (
			// used on "Email Events" tab in language editing in "Regional" section
			'Default' => Array (
				'Icons' => Array (
					'default' => 'icon16_item.png',
					0 => 'icon16_disabled.png',
					1 => 'icon16_item.png',
				),
				'Fields' => Array (
					'EventId' 		=>	Array ('title' => 'column:la_fld_Id', 'filter_block' => 'grid_range_filter', 'width' => 70, ),
					'Description'	=>	Array ('filter_block' => 'grid_like_filter', 'width' => 250, ),
					'Event'			=>	Array ('filter_block' => 'grid_like_filter', 'width' => 250, ),
					'Module'		=>	Array ('filter_block' => 'grid_options_filter', 'width' => 100, ),
					'Type'			=>	Array ('filter_block' => 'grid_options_filter', 'width' => 120, ),
					'Enabled'		=>	Array ('title' => 'column:la_fld_Status', 'filter_block' => 'grid_options_filter', 'width' => 80, ),
				),
			),

			// used on "Email Templates" section
			'Emails' => Array (
				'Icons' => Array (
					'default' => 'icon16_item.png',
					0 => 'icon16_disabled.png',
					1 => 'icon16_item.png',
				),
				'Fields' => Array (
					'EventId' => Array ('title' => 'column:la_fld_Id', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
					'Event' => Array ('filter_block' => 'grid_like_filter', 'width' => 250, ),
					'Subject' => Array ('filter_block' => 'grid_like_filter', 'no_special' => 0, 'width' => 300, ),
					'Description' => Array ('filter_block' => 'grid_like_filter', 'width' => 250, ),
					'Type' => Array ('filter_block' => 'grid_options_filter', 'width' => 60, ),
					'Enabled' => Array ('filter_block' => 'grid_options_filter', 'width' => 70, ),
					'Module' => Array ('filter_block' => 'grid_options_filter', 'width' => 100, ),
					'FrontEndOnly' => Array ('filter_block' => 'grid_options_filter', 'width' => 120, 'hidden' => 1),
				),
			),
		),
	);