<?php
/**
* @version	$Id: modules_tag_processor.php 12734 2009-10-20 19:28:11Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class ModulesTagProcessor extends kDBTagProcessor  {

		function ModuleInstalled($params)
		{
			return $this->Application->isModuleEnabled($params['name']);
		}

		function _hasPrivileges()
		{
			return $this->Application->RecallVar('user_id') == -1;
		}

		function AlreadyInstalled($params)
		{
			if (!$this->_hasPrivileges()) {
				// don't show licenses status for non-privileged users
				return true;
			}

			$object =& $this->getObject($params);
			/* @var $object kDBList */

			$modules_helper =& $this->Application->recallObject('ModulesHelper');
			/* @var $modules_helper kModulesHelper */

			return $modules_helper->moduleInstalled( $object->GetDBField('Name') );
		}

		function ModuleLicensed($params)
		{
			if (!$this->_hasPrivileges()) {
				// don't show licenses status for non-privileged users
				return true;
			}

			$object =& $this->getObject($params);
			/* @var $object kDBList */

			$modules_helper =& $this->Application->recallObject('ModulesHelper');
			/* @var $modules_helper kModulesHelper */

			$licensed_modules = array_map('strtolower', $modules_helper->_GetModules());

			return in_array(strtolower($object->GetDBField('Name')), $licensed_modules);
		}

		function PrerequisitesMet($params)
		{
			return !$this->_getPrerequisitesErrors($params);
		}

		function _getPrerequisitesErrors($params)
		{
			static $errors = Array ();

			$object =& $this->getObject($params);
			/* @var $object kDBList */

			$module_path = strtolower( $object->GetDBField('Name') );

			if (!array_key_exists($module_path, $errors)) {
				require_once FULL_PATH . '/core/install/install_toolkit.php';

				$toolkit = new kInstallToolkit();

				$module_version = $toolkit->GetMaxModuleVersion($module_path);

				$errors[$module_path] = $toolkit->CheckPrerequisites($module_path . '/', Array ($module_version), 'standalone');
			}

			return $errors[$module_path];
		}

		function ListPrerequisites($params)
		{
			$errors = $this->_getPrerequisitesErrors($params);

			$ret = '';
			$block_params = $this->prepareTagParams($params);
			$block_params['name'] = $params['render_as'];

			foreach ($errors as $error) {
				$block_params['error'] = $error;
				$ret .= $this->Application->ParseBlock($block_params);
			}

			return $ret;
		}

		function InstallLink($params)
		{
			$object =& $this->getObject($params);
			/* @var $object kDBList */

			$module_path = strtolower( $object->GetDBField('Name') );
			$url_params = Array ('redirect' => 1, 'admin' => 1);

			return $this->Application->HREF('dummy', '_FRONT_END_', $url_params, $module_path . '/install.php');
		}

	}