<?php
/**
* @version	$Id: structure_config.php 11897 2009-07-08 16:50:24Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

	$config = Array (
		'Prefix'			=>	'st',
		'ItemClass'			=>	Array('class'=>'CategoriesItem','file'=>'structure_item.php', 'build_event'=>'OnItemBuild'),
		'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
		'EventHandlerClass'	=>	Array('class'=>'CategoriesEventHandler','file'=>'structure_eh.php', 'build_event'=>'OnBuild'),
		'TagProcessorClass' =>	Array('class'=>'CategoriesTagProcessor','file'=>'structure_tp.php', 'build_event'=>'OnBuild'),

		'AutoLoad'				=>	true,

		'QueryString'		=>	Array(
			1	=>	'id',
			2	=>	'page',
			3	=>	'event',
			4	=>	'mode',
		),
		'ConfigPriority' => 0,
		'Hooks' => Array(
			Array (
				'Mode' => hBEFORE,
				'Conditional' => false,
				'HookToPrefix' => '',
				'HookToSpecial' => '*',
				'HookToEvent' => Array('OnAfterConfigRead'),
				'DoPrefix' => 'cdata',
				'DoSpecial' => '*',
				'DoEvent' => 'OnDefineCustomFields',
			),
		),

		'IDField' 			=> 	'CategoryId',

		'StatusField'		=>	Array('IsMenu'),

		'TitleField'		=>	'Name',		// field, used in bluebar when editing existing item

		'TableName'			=>	TABLE_PREFIX.'Category',

		'TitlePresets'		=>	Array(
			'default'		=>	Array(	'new_status_labels'		=> Array('st'=>'!la_title_Adding_Category!'),
										'edit_status_labels'	=> Array('st'=>'!la_title_Editing_Category!'),
										'new_titlefield'		=> Array('st'=>'!la_title_New_Category!'),
								),
			'structure_list'	=>	Array(
				'prefixes' =>	Array('st_List', 'st.current'),
				'format' => "!la_title_Structure! - '#st.current_Name#'"
			),
			'structure_edit'	=>	Array(
				'prefixes' => Array('st'),
				'format' => "#st_status# '#st_titlefield#'",
			),

			'all_pages_list'	=>	Array('prefixes' =>	Array('st.all_List'), 'format' => "!la_title_AllPages!"),

			'edit_content' => array('format' => '!la_EditingContent!'),

/*			'categories_edit'		=>	Array('prefixes' => Array('c'), 'format' => "#c_status# '#c_titlefield#' - !la_title_General!"),*/

		),

		'PermItemPrefix'	=>	'CATEGORY',
		'PermSection'		=>	Array('main' => 'CATEGORY:in-portal:structure', 'email' => 'in-portal:configemail'),

		'ListSQLs'			=>	Array(	''=>	'	SELECT %1$s.* %2$s
													FROM %1$s
												 	LEFT JOIN '.TABLE_PREFIX.'PermCache ON '.TABLE_PREFIX.'PermCache.CategoryId = %1$s.CategoryId'),

		'ItemSQLs'			=>	Array(	''=>	'	SELECT %1$s.* %2$s
													FROM %1$s
													LEFT JOIN '.TABLE_PREFIX.'PermCache ON '.TABLE_PREFIX.'PermCache.CategoryId = %1$s.CategoryId'),

		'SubItems'			=>	Array('content'),

		'ListSortings'	=> 	Array(
			'' => Array(
							'ForcedSorting' => Array('Priority' => 'desc'),
							'Sorting' => Array('Name' => 'asc'),
					)
		),

		'CalculatedFields'	=>	Array(
			''	=>	Array(
					'CurrentSort'	=>	"REPLACE(ParentPath, CONCAT('|', ".'%1$s'.".CategoryId, '|'), '')",
				)
		),

		'Fields' 			=> 	Array (
            'CategoryId'				=>	Array('type' => 'int', 'not_null' => 1,'default' => 0),
            'Type'						=>	Array('type' => 'int','not_null' => 1,'default' => 0),
		    'SymLinkCategoryId'			=>	Array ('type' => 'int', 'default' => NULL),
            'ParentId'					=>	Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (), 'not_null' => 1,'default' => 0, 'required'=>1),
            'Name'						=>	Array('type' => 'string', 'formatter' => 'kMultiLanguage', 'not_null' => 1, 'required' => 1, 'default' => ''),
            'Filename'					=>	Array('type' => 'string', 'not_null' => 1, 'default' => '', 'required' => 1),
			'AutomaticFilename'			=>	Array('type' => 'int', 'not_null' => 1, 'default' => 1),
            'Description'				=>	Array('type' => 'string', 'formatter' => 'kMultiLanguage', 'default' => null),
            'CreatedOn'					=>	Array('type' => 'int', 'formatter' => 'kDateFormatter', 'default'=>'#NOW#', 'required' => 1, 'not_null' => 1),
            'EditorsPick'				=>	Array('type' => 'int', 'not_null' => 1, 'default' => 0),
            'Status'					=>	Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Active', 2 => 'la_Pending', 0 => 'la_Disabled' ), 'use_phrases' => 1, 'not_null' => 1,'default' => 1),
            'Priority'					=>	Array('type' => 'int', 'not_null' => 1, 'formatter' => 'kOptionsFormatter', 'options' => array(), 'required' => 1, 'default' => 0),
            'MetaKeywords'				=>	Array('type' => 'string', 'default' => null),
            'CachedDescendantCatsQty'	=>	Array('type' => 'int', 'default' => 0),
            'CachedNavbar'				=>	Array('type' => 'string', 'formatter' => 'kMultiLanguage', 'default' => null),
            'CreatedById'				=>	Array('type' => 'int', 'formatter' => 'kLEFTFormatter', 'options' => Array(-1 => 'root', -2 => 'Guest'),'left_sql'=>'SELECT %s FROM '.TABLE_PREFIX.'PortalUser WHERE `%s` = \'%s\'', 'left_key_field' => 'PortalUserId', 'left_title_field' => 'Login', 'not_null' => 1,'default' => 0),
            'ResourceId'				=>	Array('type' => 'int', 'default' => null),
            'ParentPath'				=>	Array('type' => 'string', 'default' => null),
		    'TreeLeft'					=>	Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'TreeRight'					=>	Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
            'NamedParentPath'			=>	Array('type' => 'string', 'default' => null),
            'MetaDescription'			=>	Array('type' => 'string', 'default' => null),
            'HotItem'					=>	Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (2 => 'la_Auto', 1 => 'la_Always', 0 => 'la_Never'), 'use_phrases' => 1,  'not_null' => 1, 'default' => 2),
            'NewItem'					=>	Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (2 => 'la_Auto', 1 => 'la_Always', 0 => 'la_Never'), 'use_phrases' => 1,  'not_null' => 1, 'default' => 2),
            'PopItem'					=>	Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (2 => 'la_Auto', 1 => 'la_Always', 0 => 'la_Never'), 'use_phrases' => 1,  'not_null' => 1, 'default' => 2),
            'Modified'					=>	Array('type' => 'int', 'formatter' => 'kDateFormatter', 'not_null' => 1,'default' => '#NOW#'),
            'ModifiedById'				=>	Array('type' => 'int', 'formatter' => 'kLEFTFormatter', 'options' => Array(-1 => 'root', -2 => 'Guest'),'left_sql'=>'SELECT %s FROM '.TABLE_PREFIX.'PortalUser WHERE `%s` = \'%s\'', 'left_key_field' => 'PortalUserId', 'left_title_field' => 'Login', 'not_null' => 1,'default' => 0),
            'CachedTemplate'			=>	Array('type' => 'string', 'not_null' => 1, 'default' => ''),


            // fields from Pages
		    'Template'			=>	Array (
		    	'type' => 'string',
		    	'formatter' => 'kOptionsFormatter', 'options_sql' => '	SELECT	CONCAT(tf.Description, " (", TRIM(TRAILING ".des" FROM TRIM(TRAILING ".tpl" FROM FileName) ), ")") AS Title,
																					 	CONCAT(FilePath, "/", TRIM(TRAILING ".tpl" FROM FileName)) AS Value
																		FROM ' . TABLE_PREFIX . 'ThemeFiles AS tf
																		LEFT JOIN ' . TABLE_PREFIX . 'Theme AS t ON t.ThemeId = tf.ThemeId
																		WHERE (t.Enabled = 1) AND (tf.FileName NOT LIKE "%%.elm.tpl") AND (tf.FileName NOT LIKE "%%.des.tpl") AND (tf.FilePath = "/designs")',
				'option_key_field' => 'Value', 'option_title_field' => 'Title',
				/*'required' => 1,*/ 'default' => null
			),

			'UseExternalUrl'	=>	Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1,
				'not_null' => 1, 'default' => 0
			),
			'ExternalUrl'		=>	Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
			'UseMenuIconUrl'	=>	Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1,
				'not_null' => 1, 'default' => 0
			),
			'MenuIconUrl'		=>	Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
			'Title'				=>	Array('type' => 'string', 'formatter' => 'kMultiLanguage', 'default' => '', 'not_null'=>1),
			'MenuTitle'			=>	Array('type' => 'string', 'formatter' => 'kMultiLanguage', 'not_null' => 1, 'default' => ''),
			'MetaTitle'			=>	Array('type' => 'string', 'default' => null),
			'IndexTools'		=>	Array('type' => 'string','default' => null),
			'IsIndex'			=>
				Array(
					'type' => 'int','not_null' => 1, 'default' => 0,
					'formatter' => 'kOptionsFormatter', 'options' => Array (0 => 'la_Regular', 1 => 'la_CategoryIndex', 2=>'la_Container'), 'use_phrases' => 1,
				),
			'IsMenu'			=>	Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Show', 0 => 'la_Hide'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 1),
			'IsSystem'			=>	Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_System', 0 => 'la_Regular'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 0),
	    	'FormId'			=>	Array('type' => 'int', 'formatter' => 'kOptionsFormatter',
		    												'options' => array('' => ''),
															'options_sql' => 'SELECT Title, FormId FROM '.TABLE_PREFIX.'Forms ORDER BY Title',
															'option_key_field' => 'FormId', 'option_title_field' => 'Title', 'default' => 0),
			'FormSubmittedTemplate'	=>	Array('type' => 'string', 'default' => null),
			'Translated'		=>	Array ('type' => 'int', 'formatter' => 'kMultiLanguage', 'not_null' => 1, 'default' => 0, 'db_type' => 'tinyint', 'index_type' => 'int'),
			'FriendlyURL'		=>	Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
			'ThemeId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
        ),

		'VirtualFields'		=>	Array(
			'CurrentSort'	=>	Array('type' => 'string', 'default' => ''),
			'IsNew'			=>	Array('type' => 'int', 'default' => 0),
			'OldPriority'	=>	Array('type' => 'int', 'default' => 0),
		),

		'Grids'	=> Array(
			'Default'		=>	Array(
				'Icons' => Array(1 => 'icon16_folder.gif', 0 => 'icon16_folder-red.gif'),
				'Fields' => Array(
					'CategoryId' => Array( 'title'=>'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'filter_width' => '20' ),
					'Name' => Array( 'title'=>'la_col_PageTitle', 'data_block' => 'page_browse_td', 'filter_block' => 'grid_like_filter'),
					'Modified' => Array( 'title'=>'la_col_Modified', 'filter_block' => 'grid_date_range_filter' ),
					'Template' => Array( 'title'=>'la_col_TemplateType', 'filter_block' => 'grid_options_filter' ),
					'IsMenu' => Array( 'title'=>'la_col_Visible', 'filter_block' => 'grid_options_filter' ),
					'Path' => Array( 'title'=>'la_col_Path', 'data_block' => 'page_entercat_td', 'filter_block' => 'grid_like_filter' ),
					'IsSystem' => Array( 'title'=>'la_col_System', 'filter_block' => 'grid_options_filter', 'use_phrases'=>1 ),
				),
			),

			'Radio'		=>	Array(
				'Icons' => Array(1 => 'icon16_folder.gif', 0 => 'icon16_folder-red.gif'),
				'Selector' => 'radio',
				'Fields' => Array(
					'CategoryId' => Array( 'title'=>'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'filter_width' => '20' ),
					'Name' => Array( 'title'=>'la_col_PageTitle', 'data_block' => 'page_browse_td', 'filter_block' => 'grid_like_filter'),
					'Modified' => Array( 'title'=>'la_col_Modified', 'filter_block' => 'grid_date_range_filter' ),
					'Template' => Array( 'title'=>'la_col_TemplateType', 'filter_block' => 'grid_options_filter' ),
					'IsMenu' => Array( 'title'=>'la_col_Visible', 'filter_block' => 'grid_options_filter' ),
					'Path' => Array( 'title'=>'la_col_Path', 'data_block' => 'page_entercat_td', 'filter_block' => 'grid_like_filter' ),
					'IsSystem' => Array( 'title'=>'la_col_System', 'filter_block' => 'grid_options_filter', 'use_phrases'=>1 ),
				),
			),

			'AllPages'		=>	Array(
				'Icons' => Array(1 => 'icon16_folder.gif', 0 => 'icon16_folder-red.gif'),
				'Fields' => Array(
					'CategoryId' => Array( 'title'=>'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'filter_width' => '20' ),
					'Name' => Array( 'title'=>'la_col_PageTitle', 'data_block' => 'page_browse_td', 'filter_block' => 'grid_like_filter' ),
					'Path' => Array( 'title'=>'la_col_Path', 'data_block'=>'page_path_td', 'sort_field' => 'CachedNavbar', 'filter_block' => 'grid_like_filter' ),
					'Modified' => Array( 'title'=>'la_col_Modified', 'filter_block' => 'grid_date_range_filter' ),
					'Template' => Array( 'title'=>'la_col_TemplateType', 'filter_block' => 'grid_options_filter', 'hidden' => true ),
					'IsMenu' => Array( 'title'=>'la_col_Visible', 'filter_block' => 'grid_options_filter' ),
					'IsSystem' => Array( 'title'=>'la_col_System', 'filter_block' => 'grid_options_filter', 'use_phrases'=>1 ),
				),
			),
		),

		'ConfigMapping' => 	Array(
			'PerPage'				=>	'Perpage_Category',
			'ShortListPerPage'		=>	'Perpage_Category_Short',
			'DefaultSorting1Field'	=>	'Category_Sortfield',
			'DefaultSorting2Field'	=>	'Category_Sortfield2',
			'DefaultSorting1Dir'	=>	'Category_Sortorder',
			'DefaultSorting2Dir'	=>	'Category_Sortorder2',
		),
	);