<?php
/**
* @version	$Id: skin_eh.php 11892 2009-07-01 08:35:06Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

class SkinEventHandler extends kDBEventHandler {

	function mapPermissions()
	{
		parent::mapPermissions();
		$permissions = Array (
			'OnItemBuild' => Array ('self' => true),
		);

		$this->permMapping = array_merge($this->permMapping, $permissions);
	}

	/**
	 * With "primary" special loads primary skin
	 *
	 * @param kEvent $event
	 * @return int
	 */
	function getPassedID(&$event)
	{
		if ($event->Special == 'primary') {
			return Array ('IsPrimary' => 1);
		}

		return parent::getPassedID($event);
	}

	/**
	 * Allows to set selected theme as primary
	 *
	 * @param kEvent $event
	 */
	function OnSetPrimary(&$event)
	{
		if ($this->Application->CheckPermission('SYSTEM_ACCESS.READONLY', 1)) {
			return;
		}

		$ids = $this->StoreSelectedIDs($event);
		if ($ids) {
			$id = array_shift($ids);
			$this->setPrimary($id);
		}

		$this->clearSelectedIDs($event);
	}

	function setPrimary($id)
	{
		$id_field = $this->Application->getUnitOption($this->Prefix, 'IDField');
		$table_name = $this->Application->getUnitOption($this->Prefix, 'TableName');

		$sql = 'UPDATE '.$table_name.'
				SET IsPrimary = 0';
		$this->Conn->Query($sql);


		$sql = 'UPDATE '.$table_name.'
				SET IsPrimary = 1
				WHERE '.$id_field.' = '.$id;
		$this->Conn->Query($sql);
	}


	/**
	 * [HOOK] Compile stylesheet file based on theme definitions
	 *
	 * @param kEvent $event
	 */
	function OnCompileStylesheet(&$event)
	{
		$object =& $event->getObject( Array('skip_autoload' => true) );
		$object->SwitchToLive();

		$ids = $event->MasterEvent->getEventParam('ids');
		if (!is_array($ids)) $ids = explode(',',  $ids);

		if(!$ids) return false;
		foreach($ids as $id)
		{
			$object->Load($id);
			$this->Compile($object);
		}
	}

	function Compile(&$object)
	{
		$ret = $object->GetDBField('CSS');
		$options = $object->GetDBField('Options');
		$options = unserialize($options);
		$options['base_url'] = array('Value'=>rtrim($this->Application->BaseURL(), '/'));
		foreach ($options as $key => $row) {
			$ret = str_replace('@@'.$key.'@@', $row['Value'], $ret);
		}

		$compile_ts = adodb_mktime();
		$css_path = (defined('WRITEABLE') ? WRITEABLE : FULL_PATH.'/kernel').'/user_files/';

		$css_file = $css_path.'admin-'.mb_strtolower($object->GetDBField('Name')).'-'.$compile_ts.'.css';

		$fp = fopen($css_file,'w');
		if($fp)
		{
			$prev_css = $css_path.'admin-'.mb_strtolower($object->GetDBField('Name')).'-'.$object->GetDBField('LastCompiled').'.css';
			if( file_exists($prev_css) ) unlink($prev_css);

			fwrite($fp, $ret);
			fclose($fp);

			$sql = 'UPDATE '.$object->TableName.' SET LastCompiled = '.$compile_ts.' WHERE '.$object->IDField.' = '.$object->GetID();
			$this->Conn->Query($sql);
		}
	}
}