<?php
/**
* @version	$Id: site_config_eh.php 11949 2009-07-21 08:16:18Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

	class SiteConfigEventHandler extends kEventHandler {

		/**
		 * [HOOK] Universal hook to modify all configs
		 *
		 * @param kEvent $event
		 */
		function OnApplySiteConfigChanges(&$event)
		{
			static $base_path = null;

			if (!isset($base_path)) {
				$base_path = FULL_PATH . dirname( $this->Application->UnitConfigReader->getPrefixFile('custom-sections') ) . '/../site_configs';
			}

			$prefix_file = basename( $this->Application->UnitConfigReader->getPrefixFile($event->MasterEvent->Prefix) );

			$cut_pos = strrpos($prefix_file, '_config.php');
			$prefix_file = substr($prefix_file, 0, $cut_pos) . '_' . $event->MasterEvent->Prefix . '.php';

			if (file_exists($base_path . '/' . $prefix_file)) {
				/*if ($this->Application->isDebugMode()) {
					$this->Application->Debugger->appendHTML('Using site config: ' . $prefix_file);
				}*/
				require $base_path . '/' . $prefix_file;
			}
			else {
				/*if ($this->Application->isDebugMode()) {
					$this->Application->Debugger->appendHTML('Site config missing: ' . $prefix_file);
				}*/

				return ;
			}

			$change_names = Array (
				'remove_sections', 'debug_only_sections', 'remove_buttons',
				'hidden_fields', 'virtual_hidden_fields', 'debug_only_fields', 'debug_only_virtual_fields',
				'required_fields', 'virtual_required_fields', 'hide_edit_tabs', 'hide_columns'
			);

			$changes = Array ();
			foreach ($change_names as $change_name) {
				if (isset($$change_name)) {
					$changes[$change_name] = $$change_name;
				}
			}

			// apply changes
			$this->_processConfigChanges($event->MasterEvent->Prefix, $changes);
		}

		/**
		 * Applies given changes to given prefix unit config
		 *
		 * @param string $prefix
		 * @param Array $changes
		 */
		function _processConfigChanges($prefix, $changes)
		{
			extract($changes);

			$section_adjustments = $this->Application->getUnitOption($this->Prefix, 'SectionAdjustments', Array ());
			$title_presets = $this->Application->getUnitOption($prefix, 'TitlePresets', Array ());
			$fields = $this->Application->getUnitOption($prefix, 'Fields', Array ());
			$virtual_fields = $this->Application->getUnitOption($prefix, 'VirtualFields', Array ());
			$edit_tab_presets = $this->Application->getUnitOption($prefix, 'EditTabPresets', Array ());
			$grids = $this->Application->getUnitOption($prefix, 'Grids', Array ());

			$field_names = array_keys($fields);
			$virtual_field_names = array_keys($virtual_fields);

			if (isset($remove_sections)) {
				// process sections
				foreach ($remove_sections as $remove_section) {
					$section_adjustments[$remove_section]['show_mode'] = smHIDE;
				}
			}

			if (isset($debug_only_sections)) {
				// process sections
				foreach ($debug_only_sections as $debug_only_section) {
					$section_adjustments[$debug_only_section]['show_mode'] = smDEBUG;
				}
			}

			if (isset($remove_buttons)) {
				// process toolbar buttons
				foreach ($remove_buttons as $title_preset => $toolbar_buttons) {
					$title_presets[$title_preset]['toolbar_buttons'] = array_diff($title_presets[$title_preset]['toolbar_buttons'], $toolbar_buttons);
				}
			}

			$reset_fields = true;
			$reset_virtual_fields = true;

			// process hidden fields
			if (isset($hidden_fields)) {
				$fields = $this->_setFieldOption($fields, $hidden_fields, 'show_mode', false, $reset_fields);
				$reset_fields = false;
			}

			if (isset($virtual_hidden_fields)) {
				$virtual_fields = $this->_setFieldOption($virtual_fields, $virtual_hidden_fields, 'show_mode', false, $reset_virtual_fields);
				$reset_virtual_fields = false;
			}

			// process debug only fields
			if (isset($debug_only_fields)) {
				$fields = $this->_setFieldOption($fields, $debug_only_fields, 'show_mode', smDEBUG, $reset_fields);
				$reset_fields = false;
			}

			if (isset($debug_only_virtual_fields)) {
				$virtual_fields = $this->_setFieldOption($virtual_fields, $debug_only_virtual_fields, 'show_mode', smDEBUG, $reset_virtual_fields);
				$reset_virtual_fields = false;
			}

			// process required fields
			if (isset($required_fields)) {
				$fields = $this->_setFieldOption($fields, $required_fields, 'required', 1);
			}

			if (isset($virtual_required_fields)) {
				$virtual_fields = $this->_setFieldOption($virtual_fields, $virtual_required_fields, 'required', 1);
			}

			if (isset($hide_edit_tabs)) {
				// hide edit tabs
				foreach ($hide_edit_tabs as $preset_name => $edit_tabs) {
					foreach ($edit_tabs as $edit_tab) {
						unset($edit_tab_presets[$preset_name][$edit_tab]);
					}
				}
			}

			if (isset($hide_columns)) {
				// hide columns in grids
				foreach ($hide_columns as $grid_name => $columns) {
					foreach ($columns as $column) {
						unset($grids[$grid_name]['Fields'][$column]);
					}
				}
			}

			// save changes
			$this->Application->setUnitOption($this->Prefix, 'SectionAdjustments', $section_adjustments);
			$this->Application->setUnitOption($prefix, 'TitlePresets', $title_presets);
			$this->Application->setUnitOption($prefix, 'Fields', $fields);
			$this->Application->setUnitOption($prefix, 'VirtualFields', $virtual_fields);
			$this->Application->setUnitOption($prefix, 'EditTabPresets', $edit_tab_presets);
			$this->Application->setUnitOption($prefix, 'Grids', $grids);
		}

		/**
		 * Sets given option for given fields and unsets it for all other fields
		 *
		 * @param Array $fields
		 * @param Array $set_fields
		 * @param string $option_name
		 * @param mixed $option_value
		 * @param bool $reset
		 */
		function _setFieldOption($fields, $set_fields, $option_name, $option_value, $reset = true)
		{
			if ($reset) {
				// unset given option for rest of fields (all except $set_fields)
				$unset_fields = array_diff(array_keys($fields), $set_fields);
				foreach ($unset_fields as $unset_field) {
					if (array_key_exists($option_name, $fields[$unset_field])) {
						unset($fields[$unset_field][$option_name]);
					}
				}
			}

			// set given option to given fields
			foreach ($set_fields as $set_field) {
				$fields[$set_field][$option_name] = $option_value;
			}

			return $fields;
		}
	}