<?php
/**
* @version	$Id: pdf_image.php 11892 2009-07-01 08:35:06Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

class kPDFImage extends kPDFElement {
	public $ImageFile = null;
	public $ImageInfo = null;
	
	function Closed()
	{
		$src = $this->Node->Attributes['SRC'];
		if ($tmp = preg_replace('/^'.preg_quote(PROTOCOL.SERVER_NAME.(defined('PORT')?':'.PORT : '').rtrim(BASE_PATH, '/'), '/').'/', FULL_PATH, $src)) {
			$this->ImageFile = $tmp;
			$this->ImageInfo = getimagesize($this->ImageFile);
			$this->ImageInfo[0] *= 72 / 96;
			$this->ImageInfo[1] *= 72 / 96;
		}
		else {
			
		}
		parent::Closed();
	}
	
	function CheckDimensions()
	{
		$elem = $this;
		do {
			$elem->SetCSSProperty('width', $elem->GetCSSProperty('width') + $this->ImageInfo[0]);
			$elem->SetCSSProperty('height', $this->ImageInfo[1]);
			$elem = $elem->Parent;
		} while ($elem && $elem->GetDisplayLevel() == 'inline');
		$this->GetLineBox()->CurX += $this->ImageInfo[0];
	}
	
	function CalcMinMaxContentWidth()
	{
		$this->MinContentWidth = $this->ImageInfo[0];
		$this->MaxContentWidth = $this->ImageInfo[0];
		parent::CalcMinMaxContentWidth();
	}
	
	function DrawAt($page, $x=0, $y=0, $spacer_w=0)
	{
		if ($this->ImageFile) {
			if (defined('PDF_DEBUG_NO_TEXT')) return ;
			$page->DrawImage($this->ImageFile, $x, $y, $this->GetCSSProperty('width'), $this->GetCSSProperty('height'));
		}
	}
		
}