<?php
/**
* @version	$Id: help_tag_processor.php 11892 2009-07-01 08:35:06Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

	class HelpTagProcessor extends kDBTagProcessor
	{

		function SectionTitle($params)
		{
			$rets = explode('.', $this->Application->GetVar('h_prefix') );
			$this->Prefix = $rets[0];
			$this->Special = isset($rets[1]) ? $rets[1] : '';
			//$this->Prefix = $this->Application->GetVar('h_prefix');

			$title_preset_name = replaceModuleSection($this->Application->GetVar('h_title_preset'));
			$this->Application->SetVar('h_title_preset', $title_preset_name);
			$title_presets = $this->Application->getUnitOption($this->Prefix,'TitlePresets');

			$format = $title_presets[$title_preset_name]['format'];
			$format = preg_replace('/[ ]*( ([\'"]{1}) | ([\(]{1}) ) \#.*\# (?(2) \1 | \) )[ ]*/Ux', ' ', $format);
			$title_presets[$title_preset_name]['format'] = $format;
			$this->Application->setUnitOption($this->Prefix,'TitlePresets',$title_presets);

			$params['title_preset'] = $title_preset_name;
			return parent::SectionTitle($params);
		}

		function getModule()
		{
			$module = $this->Application->GetVar('h_module');
			if (!$module) {
				$module = $this->Application->RecallVar('module');
			}
			return $module;
		}

		function ShowHelp($params)
		{
			$module = $this->getModule();

			$module = explode(':', $module);
			$module = $module[0];

			$title_preset = $this->Application->GetVar('h_title_preset');

			$module_path = $this->Application->findModule('Name', $module, 'Path');
			$help_file = FULL_PATH.'/'.$module_path.'module_help/'.$title_preset.'.txt';

			if ($this->Application->isDebugMode() && constOn('DBG_EDIT_HELP')) {
				global $debugger;
				$ret = 'Help file: <b>'.$debugger->getLocalFile($help_file).'</b><hr>';
			}
			else {
				$ret = '';
			}

			$help_data = file_exists($help_file) ? file_get_contents($help_file) : false;

			if( $this->Application->isDebugMode() && constOn('DBG_HELP') )
			{
				$this->Application->Factory->includeClassFile('FCKeditor');
				$oFCKeditor = new FCKeditor('HelpContent');

				$oFCKeditor->BasePath	= $this->Application->BaseURL('/admin/editor/cmseditor');
				$oFCKeditor->Width		= '100%';
				$oFCKeditor->Height		= '300';
				$oFCKeditor->ToolbarSet	= 'Advanced';
				$oFCKeditor->Value		= $help_data;

				$oFCKeditor->Config = Array(
					'UserFilesPath' =>	(defined('WRITEABLE') ? WRITEABLE : FULL_PATH.'/kernel') . '/user_files',
					'ProjectPath' 	=> 	$this->Application->ConfigValue('Site_Path'),
					'CustomConfigurationsPath' => rtrim( $this->Application->BaseURL('/admin/editor/inp_fckconfig.js'), '/'),
				);

  				$ret .= $oFCKeditor->CreateHtml();
			}
			else
			{
				$ret .= $help_data ? $help_data : $this->Application->Phrase('la_section_help_file_missing');
			}

			return $ret;
		}

		function GetIcon($params)
		{
			$icon_var = getArrayValue($params,'var_name');
			$icon = replaceModuleSection($this->Application->GetVar($icon_var));

			if(!$icon) $icon = getArrayValue($params,'default_icon');
			return $icon;
		}

		/**
		 * Returns templates path for module, which is gathered from prefix module
		 *
		 * @param Array $params
		 * @return string
		 * @author Alex
		 */
		function ModulePath($params)
		{
			$module_folder = trim( $this->Application->findModule('Name', $this->getModule(), 'Path'), '/');
			return '../../'.$module_folder.'/admin_templates/';
		}
	}

?>