<?php
/**
* @version	$Id: inp1_parser.php 11892 2009-07-01 08:35:06Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

class Inp1Parser extends kHelper {

	var $InportalInited = false;

	var $InpParsetInited = false;

	function Parse($tname, $template_body)
	{
		global $objTemplate, $var_list, $var_list_update;

		if ($tname == 'email_template') {
			if ( !$this->InportalInited) {
				$this->InitInPortal();
			}
			// in case Parsing was called through InitInPortal -> moudles -> frontaction -> emailevent
			// we need to make sure old parser is initialized
			$this->InitParser();
			$template_body = $objTemplate->ParseTemplateFromBuffer($tname, $template_body);
			return $template_body;
		}

		if (!$this->InportalInited) {
			//$save_t = $this->Application->GetVar('t');
			$this->InitInPortal();
			$var_list['t'] = $this->cutTPL($var_list['t']);
			if($var_list['t'] != $this->Application->GetVar('t'))
			{
				$get = $_GET;
				unset($get['env'], $get['Action'], $get['_mod_rw_url_'], $get['rewrite']);
				$this->Application->StoreVar('K4_Template_Referer', $this->Application->GetVar('t') );

				$this->Application->Redirect($var_list['t'], $get);
			}
		}

		$var_list['t'] = $this->cutTPL($var_list['t']);

		if ($var_list['t'] != $this->Application->GetVar('t')) {
			//$var_list['t'] = rtrim($var_list['t'],'.tpl');
			$t = $var_list['t'];
			$this->Application->SetVar('t', $t);
			$template_cache =& $this->Application->recallObject('TemplatesCache');
			$template_body = $this->Application->Parser->Parse( $template_cache->GetTemplateBody($t), $t, 0 );
		}
		else {
			$this->InitParser();
			$template_body = $objTemplate->ParseTemplateFromBuffer($tname, $template_body);
		}
		return $template_body;
	}

	function cutTPL($tname)
	{
		if( substr($tname,-4) == '.tpl' )
		{
			return substr($tname, 0, strlen($tname)-4 );
		}
		return $tname;
	}

	function InitParser()
	{
		global $objTemplate, $CurrentTheme, $objThemes, $var_list;
		if ($this->InpParsetInited) return true;

		$theme_id = $this->Application->IsAdmin() ? 1 : $this->Application->GetVar('m_theme');
		if ($theme_id) {
			$CurrentTheme = $objThemes->GetItem($theme_id);

			$timeout = $CurrentTheme->Get('CacheTimeout');

			$objTemplate = new clsTemplateList(FULL_PATH.THEMES_PATH.'/');
	    }

		$this->InpParsetInited = true;
	}

	function InitInPortal()
	{
		$this->InportalInited = true;
		/*global 	$pathtoroot, $FrontEnd, $indexURL, $rootURL, $secureURL, $var_list, $CurrentTheme,
						$objThemes, $objConfig, $m_var_list, $timeout, $objLanguages,
						$TemplateRoot, $objTemplate, $html, $objSession, $Errors, $objCatList, $objUsers,
						$env, $mod_prefix, $ExtraVars, $timestart, $timeend, $timeout, $sqlcount, $totalsql,
						$template_path, $modules_loaded, $mod_root_cats, $objModules, $objItemTypes;*/


		global $sec, $usec, $timestart, $pathtoroot, $FrontEnd, $indexURL, $kernel_version, $FormError,
		$FormValues, $ItemTables, $KeywordIgnore, $debuglevel,
		$LogLevel, $LogFile, $rq_value, $rq_name, $dbg_constMap, $dbg_constValue, $dbg_constName,
		$debugger, $g_LogFile, $LogData, $Errors,
		$g_DebugMode, $totalsql, $sqlcount, $objConfig, $ItemTypePrefixes, $ItemTagFiles, $objModules,
		$objSystemCache, $objBanList, $objItemTypes, $objThemes, $objLanguages, $objImageList, $objFavorites,
		$objUsers, $objGroups, $DownloadId, $objPermissions, $objPermCache, $m_var_list, $objCatList,
		$objCustomFieldList, $objCustomDataList, $objCountCache, $CRLF, $objMessageList, $objEmailQueue,
		$ExtraVars, $adodbConnection, $sql, $rs, $mod_prefix, $modules_loaded, $name,
		$template_path, $mod_root_cats, $value, $mod, $ItemTypes,
		$ParserFiles, $SessionQueryString, $var_list, $objSession,
		$orderByClause, $TemplateRoot, $ip, $UseSession, $Action, $CookieTest, $sessionId,
		$var_list_update, $CurrentTheme, $UserID, $objCurrentUser,
		$folder_name, $objLinkList, $tag_override, $timeZones, $siteZone, $serverZone,
		$lastExpire, $diffZone, $date, $nowDate, $lastExpireDate, $SearchPerformed,
		$TotalMessagesSent, $ado, $adminDir, $rootURL, $secureURL, $html, $timeout,
		$pathchar, $objTemplate, $objTopicList, $objArticleList, $objPostingList, $objCensorList,
		$objSmileys, $objPMList, $SubscribeAddress, $SubscribeError, $SubscribeResult, $application,
		$FCKeditorBasePath;

		$pathtoroot = FULL_PATH.'/';

		if (!file_exists(FULL_PATH.'/config.php')) {
			echo "In-Portal is probably not installed, or configuration file is missing.<br>";
			echo "Please use the installation script to fix the problem.<br><br>";
			echo "<a href='admin/install.php'>Go to installation script</a><br><br>";
			flush();
			$this->Application->ApplicationDie();
		}

		//ob_start();
		$FrontEnd = 1;

		$indexURL="../../index.php"; //Set to relative URL from the theme directory

		/* initalize the in-portal system */
		include_once(FULL_PATH."/kernel/startup.php");

		$rootURL="http://".ThisDomain().$objConfig->Get("Site_Path");
		$secureURL = $rootURL;

		if( !$var_list['t'] ) $var_list['t'] = 'index';

		$this->InitParser();

		// process referer in session: begin
		if (is_object($objSession)) {
			$k4_referer = $objSession->GetVariable('K4_Template_Referer');
			if ($k4_referer) {
				$_local_t = $k4_referer;
				$this->Application->RemoveVar('K4_Template_Referer');
			}
			$objSession->SetVariable('Template_Referer', isset($_local_t) ? $_local_t : '');
		}
		// process referer in session: end

		if ($this->Application->isDebugMode() && $Action) {
			$this->Application->Debugger->setHTMLByIndex(1, 'Front Action: <b>'.$Action.'</b>', 'append');
		}

		LogEntry("Output Complete\n");

		$timeend = getmicrotime();
		$diff = $timeend - $timestart;

		LogEntry("\nTotal Queries Executed: $sqlcount in $totalsql seconds\n");
		LogEntry("\nPage Execution Time: $diff seconds\n", true);
		if ($LogFile) {
		  fclose($LogFile);
		}
	}
}

?>