<?php
/**
* @version	$Id: template.php 11892 2009-07-01 08:35:06Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

class Template {
	var $Body = '';
	var $BasePath = '';
	var $Filename = '';

	function Template($base_path=null, $filename=null, $silent=0)
	{
		if ($this->SetBasePath($base_path)) {
			if (isset($filename)) {
				$this->Filename = $filename;
				$this->LoadTemplate($silent);
			}
		}
	}

	function SetBasePath($base_path=null)
	{
		if (isset($base_path)) {
			$base_path = eregi_replace("/$", '', $base_path); //Cutting possible last slash
			$this->BasePath = $base_path;
			return true;
		}
		return false;
	}

	function GetFullPath()
	{
		return $this->BasePath.'/'.ltrim($this->Filename, '/').'.tpl';
	}

	/**
	 * Enter description here...
	 *
	 * @param int $silent template not found {0 - fatal error, 1 - warning, 2 - nothing}
	 * @return bool
	 */
	function LoadTemplate($silent = 0)
	{
		$filename = $this->GetFullPath();
		if (file_exists($filename)) {
			if (filesize ($filename)  == 0) {
				trigger_error("Template file size is 0: <b>$filename</b>", ($silent ? E_USER_NOTICE : E_USER_ERROR) );
			}

			// stripping out special comments
			$this->SetBody(preg_replace('/<!--##.*##-->/sU', '', file_get_contents($filename)));
			/*$handle = fopen ($filename, "r");
			$contents = fread ($handle, filesize ($filename));
			$this->SetBody($contents);
			fclose ($handle);*/
			return true;
		}
		else {
			if (($silent != 2) && !$silent) {
				$application =& kApplication::Instance();
				if ($application->isDebugMode()) {
					$application->Debugger->appendTrace();
				}
				trigger_error('File or block not found: <b>'.$filename.'</b> at '.$application->Parser->TemplateName, E_USER_ERROR);
			}
			return false;
		}
	}

	function SetBody($body)
	{
		$this->Body = $body;
	}

	function GetBody()
	{
		return $this->Body;
	}
}

class TemplatesCache extends kBase {
	var $Templates = Array();
	var $BasePath;
	var $FileNames = Array();

	/**
	 * Force templates cache to search templates on front-end:
	 * true - search for theme name in template name
	 * false - don't search anywhere
	 * name - theme name to prepend for each template name
	 *
	 * @var mixed
	 */
	var $forceThemeName = false;

	function TemplatesCache()
	{
		parent::kBase();
		$this->BasePath = FULL_PATH.THEMES_PATH;

		$conn =& $this->Application->GetADODBConnection();
	}

	/**
	 * Based on template name gets it's location on disk and owner module
	 *
	 * @param string $filename
	 * @return Array 0 - path on disk, 1 - template name
	 */
	function GetTemplatePaths($filename)
	{
		if ($this->Application->IsAdmin() && isset($this->Application->ReplacementTemplates[$filename])) {
			$filename = $this->Application->ReplacementTemplates[$filename];
		}

		// allows to use non-replaced version of replaced template
		$filename = preg_replace('/^original:(.*)/', '\\1', $filename);

		if (preg_match('#^[\/]{0,1}([^\/]*)\/(.*)#', $filename, $regs)) {
			$module_filename = $regs[2];
			$first_dir = $regs[1];
		}
		else {
			$first_dir = '';
			$module_filename = $filename;
		}

		if (is_string($this->forceThemeName)) {
			// when defined, then all templates are read from given theme name
			$first_dir = 'theme:' . $this->forceThemeName . ($first_dir ? '/' . $first_dir : '');
		}

		// !preg_match for backward compatability with full-path plugins
		if ($this->Application->IsAdmin() && $first_dir == 'plugins' && !preg_match('/admin_templates/', $module_filename)) {
			if (preg_match('#^[\/]{0,1}([^\/]*)\/(.*)#', $module_filename, $regs)) {;
				$path = MODULES_PATH.'/'.mb_strtolower($first_dir).'/'.$regs[1].'/admin_templates';
				$module_filename = $regs[2];
			}
			else {
				$first_dir = '';
				$module_filename = $filename;
			}
		}
		elseif ( $this->Application->IsAdmin() && $this->Application->findModule('Name', $first_dir)) {
			if ($first_dir == 'in-portal') {
				$first_dir = 'kernel';
			}
			$path = MODULES_PATH.'/'.mb_strtolower($first_dir).'/admin_templates';
		}
		elseif ($this->forceThemeName && preg_match('/^theme:(.*)/', $first_dir, $regs)) {
			// ability to use Front-End templates in admin (only during mass compilation)
			$path = FULL_PATH . '/themes/' . $regs[1];
		}
		else {
			$path = $this->BasePath;
			$module_filename = $first_dir.'/'.$module_filename;
		}

		return Array ($path, $module_filename);
	}

	function LoadTemplate($filename, $title=NULL, $silent=0)
	{
		list ($path, $module_filename) = $this->GetTemplatePaths($filename);

		$template = new Template($path, $module_filename, $silent);
		if (!isset($title)) $title = $filename;
		$this->SetTemplate($title, $template);
	}

	function GetRealFilename($filename)
	{
		list ($path, $module_filename) = $this->GetTemplatePaths($filename);
		return $path.'/'.trim($module_filename, '/');
	}

	function SetTemplate($title, &$template, $filename=null)
	{
		if (!isset($filename)) $filename=$title;
		$this->Templates[$title] = $template;
		$this->FileNames[$title] = $filename;
	}

	function &GetTemplate($title, $silent=0)
	{
		if (!isset($this->Templates[$title])) {
			$this->LoadTemplate($title, null, $silent);
		}
		return $this->Templates[$title];
	}

	function GetTemplateBody($title, $silent=0)
	{
		$template =& $this->GetTemplate($title, $silent);
		if ( !is_object($template) ) {
			return '';
		}
		return $template->GetBody();
	}

	function GetTemplateFileName($title)
	{
		return getArrayValue($this->FileNames, $title);
	}

	function SetTemplateBody($title, $body)
	{
		$template = new Template();
		$template->SetBody($body);
		$this->SetTemplate($title, $template);
	}

	function ParseTemplate($template_name)
	{
		$Parser = new TemplateParser($this->Application);
		return $Parser->Parse( $this->GetTemplateBody($template_name) );
	}

	function TemplateExists($filename)
	{
		$real_file = $this->GetRealFilename( strtolower($filename) );
		if (!preg_match('/\.tpl$/', $real_file)) {
			$real_file .= '.tpl';
		}
		return file_exists($real_file);
	}


	function GetPreParsed($template)
	{
		$real_name = $this->GetRealFilename($template);
		$fname = $real_name.'.php';
		$fname = str_replace(FULL_PATH, defined('WRITEABLE') ? WRITEABLE.'/cache' : FULL_PATH.'/kernel/cache', $fname);

		$tname = $real_name.'.tpl';
		if (!file_exists($tname)) {
			return false;
		}

		if (defined('SAFE_MODE') && SAFE_MODE) {
			$conn =& $this->Application->GetADODBConnection();
			$cached = $conn->GetRow('SELECT * FROM '.TABLE_PREFIX.'Cache WHERE VarName = "'.$fname.'"');
			if ($cached !== false && $cached['Cached'] > filemtime($tname)) {
				return array('active' => 1, 'fname' => $fname, 'tname' => $tname, 'mode' => 'db', 'content' => $cached['Data']);
			}
		}
		else {
			if (file_exists($fname) && file_exists($tname) && filemtime($fname) > filemtime($tname)) {
				return array('active' => 1, 'fname' => $fname, 'tname' => $tname, 'mode' => 'file');
			}
			if (!file_exists($fname)) {
				 // make sure to create directory if pre-parsed file does not exist
				$this->CheckDir(dirname($fname), defined('WRITEABLE') ? WRITEABLE.'/cache' : FULL_PATH.'/kernel/cache');
			}
		}
		return array('active' => 0, 'fname' => $fname, 'tname' => $tname, 'mode'=>'file');
	}

	/**
	 * Recursive mkdir
	 *
	 * @param string $dir
	 * @param string $base_path base path to directory where folders should be created in
	 */
	function CheckDir($dir, $base_path = '')
	{
		if (file_exists($dir)) {
			return;
		}
		else {
			// remove $base_path from beggining because it is already created during install
			$dir = preg_replace('/^'.preg_quote($base_path.'/', '/').'/', '', $dir, 1);
			$segments = explode('/', $dir);
			$cur_path = $base_path;

			foreach ($segments as $segment) {
				// do not add leading / for windows paths (c:\...)
				$cur_path .= preg_match('/^[a-zA-Z]{1}:/', $segment) ? $segment : '/'.$segment;
				if (!file_exists($cur_path)) {
					mkdir($cur_path);
				}
			}
		}
	}

}


?>