<?php
/**
* @version	$Id: zones_config.php 14582 2011-09-23 14:42:51Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config =	Array (
					'Prefix'			=>	'z',
					'ItemClass'			=>	Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
					'ListClass'			=>	Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
					'EventHandlerClass'	=>	Array ('class' => 'ZonesEventHandler', 'file' => 'zones_event_handler.php', 'build_event' => 'OnBuild'),
					'TagProcessorClass' =>	Array ('class' => 'ZonesTagProcessor', 'file' => 'zones_tag_processor.php', 'build_event' => 'OnBuild'),
					'AutoLoad'			=>	true,
					'hooks'				=>	Array (),
					'QueryString'		=>	Array (
												1 => 'id',
												2 => 'Page',
												3 => 'PerPage',
												4 => 'event',
											),
					'IDField'			=>	'ZoneID',
					'TitleField'		=>  'Name',
					'TitlePresets'		=>	Array (
						'default' => Array (
							'new_status_labels' => Array ('z' => '!la_title_AddingShippingZone!'),
							'edit_status_labels' => Array ('z' => '!la_title_EditingShippingZone!'),
						),
												'zones_edit'		=>	Array (	'prefixes' => Array ('z'), 'format' => "#z_status# - '#z_titlefield#'"),
					),
					'TableName'			=>	TABLE_PREFIX . 'ShippingZones',
					'ForeignKey' 		=> 	'ShippingTypeID', //Name of the field in this table used as ForeignKey
					'ParentTableKey' 	=> 	'ShippingID', //Name of the field in parent table linked with ForeignKey
					'ParentPrefix'	=> 's', //Prefix of parent item
					'AutoDelete'	=>	true,
					'AutoClone'	=> true,

					'SubItems' =>	Array ('dst', 'sc'),

					'ListSQLs'			=>	Array (	'' =>	'SELECT * FROM %s'),
																		 // key - special, value - list select sql
					'ItemSQLs'			=>	Array (	'' =>	'SELECT * FROM %s'),

					'ListSortings'	=> 	Array (
																'' => Array (
																	'Sorting' => Array ('Name' => 'asc'),
																)
															),
					'Fields' => Array (
						'ZoneID' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0, ),
			            'ShippingTypeID' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0, ),
			            'Name' => Array (
			            	'type' => 'string', 'max_len' => 100,
							'required' => 1, 'default' => '', 'not_null' => 1,
							'error_msgs' => Array ('required' => 'Please fill in'),
						),
			            'Type' => Array (
			            	'type' => 'int',
			            	'formatter' => 'kOptionsFormatter', 'use_phrases' => 1,
			            	'options' => Array (
								1 => 'la_ByCountry',
								2 => 'la_ByState',
								3 => 'la_ByZIP'
							),
							'not_null' => 1, 'default' => 1,
						),
			            'CODallowed' => Array (
			            	'type' => 'int',
			            	'formatter' => 'kOptionsFormatter',
			            	'options' => Array (0 => 'la_NotAllowed', 1 => 'la_Allowed',), 'use_phrases' => 1,
			            	'not_null' => 1, 'default' => 1,
						),
					),

					'Grids'	=> Array (
						'Default' =>	Array (
							'Icons' => Array (
								'default' => 'icon16_item.png',
								0 => 'icon16_disabled.png',
								1 => 'icon16_item.png',
								'module' => 'core',
							),
							'Fields' => Array (
								'ZoneID' => Array ( 'title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 50, ),
								'Name' => Array ( 'title' => 'column:la_fld_ShipZoneName', 'filter_block' => 'grid_like_filter', 'width' => 250, ),
								'Type' => Array ( 'filter_block' => 'grid_options_filter', 'width' => 100, ),
								'CODallowed' => Array ( 'filter_block' => 'grid_options_filter', 'width' => 120, )
							),
						),
					),
	);