<?php
/**
* @version	$Id: products_item.php 14258 2011-03-16 21:43:52Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class ProductsItem extends kCatDBItem
	{
		function GetPackageContentIds()
		{
			$ids_string = trim($this->GetDBField('PackageContent'), '|');
			if ($ids_string) {
				$ids_array = explode('|', $ids_string);
				return $ids_array;
			}
			else {
				return array();
			}
		}

		/**
		 * Returns field values from primary pricing for product
		 *
		 * @return array
		 */
		function getPrimaryPricing()
		{
			// product + pricing based
			$cache_key = 'product_primary_pricing[%PIDSerial:' . $this->GetID() . '%][%PrIDSerial:ProductId:' . $this->GetID() . '%]';

			if (!$this->Application->isAdmin && $this->Application->LoggedIn()) {
				// also group based
				$primary_group = (int)$this->Application->Session->GetField('GroupId');
				$cache_key .= ':group=' . $primary_group;
			}

			// don't cache, while in temp table
			$price_info = $this->IsTempTable() ? false : $this->Application->getCache($cache_key);

			if ($price_info === false) {
				if (!$this->Application->isAdmin && $this->Application->LoggedIn()) {
					// logged in user on front-end
					$this->Conn->nextQueryCachable = true;
					$sql = 'SELECT Price, Cost
							FROM ' . TABLE_PREFIX . 'ProductsPricing
							WHERE (ProductId = ' . $this->GetID() . ') AND (GroupId = ' . $primary_group . ')
							ORDER BY MinQty';
					$price_info = $this->Conn->GetRow($sql);

					if ($price_info !== false) {
						$this->Application->setCache($cache_key, $price_info);

						return $price_info;
					}
				}

				// not logged-in user on front-end or in administrative console
				$pr_table = $this->Application->getUnitOption('pr', 'TableName');

				if ($this->IsTempTable()) {
					$pr_table = $this->Application->GetTempName($pr_table, 'prefix:' . $this->Prefix);
				}

				$this->Conn->nextQueryCachable = true;
				$sql = 'SELECT Price, Cost
						FROM ' . $pr_table . '
						WHERE (' . $this->IDField . ' = ' . $this->GetID() . ') AND (IsPrimary = 1)';
				$price_info = $this->Conn->GetRow($sql);

				$this->Application->setCache($cache_key, $price_info);
			}

			return $price_info;
		}

	}