<?php
/**
* @version	$Id: discounts_event_handler.php 15149 2012-03-04 09:05:03Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class DiscountsEventHandler extends kDBEventHandler {

	/**
	 * Occurs before updating item
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnBeforeItemUpdate(kEvent $event)
	{
		parent::OnBeforeItemUpdate($event);

		$this->itemChanged($event);
	}

	/**
	 * Occurs before creating item
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnBeforeItemCreate(kEvent $event)
	{
		parent::OnBeforeItemCreate($event);

		$this->itemChanged($event);
	}

	/**
	 * Occurs before item changed
	 *
	 * @param kEvent $event
	 */
	function itemChanged($event)
	{
		$object = $event->getObject();
		/* @var $object kDBItem */

		$object->SetDBField('Amount', abs($object->GetDBField('Amount')));
	}
}