<?php
/**
* @version	$Id: addresses_list.php 14258 2011-03-16 21:43:52Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/
	defined('FULL_PATH') or die('restricted access!');

	class AddressesList extends kDBList
	{

		function CopyAddress($from_address_id, $to_address_type = '')
		{
			$address_found = false;
			$this->GoFirst();
			while( !$this->EOL() )
			{
				if( $this->GetID() == $from_address_id )
				{
					$address_found = true;
					break;
				}
				$this->GoNext();
			}

			if ($address_found) {
				$order_fields = Array('To', 'Company', 'Phone', 'Fax', 'Email', 'Address1', 'Address2', 'City', 'State', 'Zip', 'Country');

				$order =& $this->Application->recallObject('ord');
				foreach ($order_fields as $order_field) {
					$order->SetDBField($to_address_type.$order_field, $this->GetDBField($order_field) );
				}
			}
		}

		/**
		 * Checks if minimal required fields set is filled in address passed
		 *
		 * @param Array $address_data
		 * @return bool
		 */
		function CheckAddress($address_data, $prefix = '')
		{
			$required_fields = Array('To','Address1','City','Zip','Country','Phone');
			$ret = true;
			foreach($required_fields as $required_field)
			{
				if( !$address_data[$prefix.$required_field] )
				{
					$ret = false;
					break;
				}
			}
			return $ret;
		}

		/*
		function getAddressCRC($address_data, $prefix = '')
		{
			return crc32( 	$address_data[$prefix.'To'].$address_data[$prefix.'Company'].$address_data[$prefix.'Phone'].$address_data[$prefix.'Fax'].
							$address_data[$prefix.'Email'].$address_data[$prefix.'Address1'].$address_data[$prefix.'Address2'].$address_data[$prefix.'City'].
							$address_data[$prefix.'State'].$address_data[$prefix.'Zip'].$address_data[$prefix.'Country'] );
		}
		*/
	}