<?php
/**
* @version	$Id: affiliate_payment_types_tp.php 14594 2011-09-29 15:45:36Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2011 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class AffiliatePaymentTypeTagProcessor extends kDBTagProcessor {

	/**
	 * Checks, that current affiliate payment type matches the one, being printed via PrintList tag
	 *
	 * @param $params
	 * @return bool
	 * @see kDBTagProcessor::PrintList()
	 * @access protected
	 */
	protected function Checked($params)
	{
		static $checked = false;

		$affiliate =& $this->Application->recallObject( $params['prefix'] );
		/* @var $affiliate kDBItem */

		$payment_type = $affiliate->GetDBField( $params['field'] );

		if ( $payment_type ) {
			$object =& $this->getObject($params);
			/* @var $object kDBList */

			return $payment_type == $object->GetID();
		}

		if ( !$checked ) {
			// make first listed affiliate payment type selected
			$checked = true;

			return true;
		}

		return false;
	}
}