<?php
/**
* @version	$Id: product_option_combinations_config.php 14534 2011-09-18 14:13:17Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config =	Array (
					'Prefix'			=>	'poc',
					'ItemClass'			=>	Array ('class' => 'kPOCItem', 'file' => 'products_option_combination_item.php', 'build_event' => 'OnItemBuild'),
					'ListClass'			=>	Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
					'EventHandlerClass'	=>	Array ('class' => 'ProductOptionCombinationsEventHandler', 'file' => 'product_option_combinations_event_handler.php', 'build_event' => 'OnBuild'),
					'TagProcessorClass' =>	Array ('class' => 'ProductOptionCombinationsTagProcessor', 'file' => 'product_option_combinations_tag_processor.php', 'build_event' => 'OnBuild'),
					'RegisterClasses'	=>	Array (
												Array ('pseudo' => 'kCombinationFormatter', 'class' => 'kCombinationFormatter', 'file' => 'product_option_formatters.php', 'build_event' => '', 'require_classes' => 'kFormatter'),
												Array ('pseudo' => 'kCombPriceFormatter', 'class' => 'kCombPriceFormatter', 'file' => 'product_option_formatters.php', 'build_event' => '', 'require_classes' => 'kFormatter'),
											),
					'AutoLoad'			=>	true,
					'Hooks'				=>	Array (

											),
					'AggregateTags' => Array (
											),
					'QueryString'		=>	Array (
												1 => 'id',
												2 => 'Page',
												3 => 'PerPage',
												4 => 'event',
											),
					'TitleField' => 'CombinationId',
					'IDField'			=>	'CombinationId',
					'TableName'			=>	TABLE_PREFIX.'ProductOptionCombinations',
					'ForeignKey'	=>	Array ('p' => 'ProductId'),
					'ParentTableKey' => Array ('p' => 'ProductId'),
					'ParentPrefix' => 'p',
					'AutoDelete'	=>	true,
					'AutoClone'	=> true,

					'ListSQLs'			=>	Array (	'' => 'SELECT %1$s.* %2$s
																					 FROM %1$s
																					 LEFT JOIN '.TABLE_PREFIX.'Products ON '.TABLE_PREFIX.'Products.ProductId = %1$s.ProductId
																					 LEFT JOIN '.TABLE_PREFIX.'ProductsPricing ON '.TABLE_PREFIX.'ProductsPricing.ProductId = %1$s.ProductId AND '.TABLE_PREFIX.'ProductsPricing.IsPrimary = 1
																					',
																		), // key - special, value - list select sql
					'ItemSQLs'			=>	Array (	'' => 'SELECT * FROM %s',
																		),
					'ListSortings'	=> 	Array (
																'' => Array (
																	'Sorting' => Array ('Combination' => 'asc'),
																	'ForcedSorting' => Array ('Priority' => 'desc'),
																)
															),
					'Fields' => Array (
						'CombinationId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0, ),
			            'ProductId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0, ),
			            'Combination' => Array ('type' => 'string', 'required' => 1, 'formatter' => 'kCombinationFormatter', 'format' =>"%s: %s<br>", 'default' => NULL),
			            'CombinationCRC' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0, ),
			            'PriceType' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Txt_=', 2 => 'la_Flat', 3 => 'la_Percent'), 'use_phrases' => 1, 'default' => 3, ),
			            'Price' => Array ('type' => 'float', 'required' => 1, 'formatter' => 'kFormatter', 'default' => '', ),
			            'WeightType' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Txt_=', 2 => 'la_Flat', 3 => 'la_Percent'), 'use_phrases' => 1, 'default' => 3, ),
			            'Weight' => Array ('type' => 'float', 'formatter' => 'kFormatter', 'default' => 0, ),
			            'Availability' =>  Array (
			            	'type' => 'int',
							'formatter' => 'kOptionsFormatter',
			            	'options' => Array ( 0 => 'la_No', 1 => 'la_Yes', ), 'use_phrases' => 1,
							'not_null' => 1, 'default' => 1,
						),
			            'Priority' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0, ),
						'QtyInStock'		=>	Array ('type' => 'int', 'not_null' => '1', 'default' => 0),
						'QtyReserved'		=>	Array ('type' => 'int', 'not_null' => '1', 'default' => 0),
						'QtyBackOrdered'	=>	Array ('type' => 'int', 'not_null' => '1', 'default' => 0),
						'QtyOnOrder'		=>	Array ('type' => 'int', 'not_null' => '1', 'default' => 0),
						'SKU'				=>	Array ('type' => 'string', 'not_null' => '1', 'default' => ''),
					),
					'CalculatedFields' => Array (
							'' => Array (
								'FinalPrice' => 'IF(%1$s.PriceType = 1, %1$s.Price,
																	IF(%1$s.PriceType = 2, '.TABLE_PREFIX.'ProductsPricing.Price + %1$s.Price,
																		'.TABLE_PREFIX.'ProductsPricing.Price * (1 + %1$s.Price/100)
																		)
																	)',
								'BasePrice' => TABLE_PREFIX.'ProductsPricing.Price',
								),
							),
					'VirtualFields'	=> 	Array (
								'FinalPrice' => Array ('type' => 'float', 'formatter' => 'kCombPriceFormatter', 'format' => '%.2f', 'default' => NULL),
								'BasePrice' => Array ('type' => 'float', 'formatter' => 'kFormatter', 'format' => '%.2f', 'default' => NULL),
										),
					'Grids' => Array (
						'Default' => Array (
							'Icons' => Array (
								'default' => 'icon16_item.png',
								'module' => 'core',
							),
							'Fields' => Array (
								'Combination' => Array ( 'title' => 'la_col_Combination', 'data_block' => 'grid_combination_td', 'filter_block' => 'grid_empty_filter'),
								'SKU'		=>	Array ( 'filter_block' => 'grid_like_filter'),
								'Availability' => Array ( 'filter_block' => 'grid_options_filter'),
								'Price' => Array ( 'data_block' => 'price_td', 'filter_block' => 'grid_float_range_filter'),
//								'Weight' => Array ( 'data_block' => 'weight_td', 'filter_block' => 'grid_float_range_filter'),
							),
						),

						'Inventory' => Array (
							'Icons' => Array (
								'default' => 'icon16_item.png',
								'module' => 'core',
							),
							'Selector' => 'radio',
							'Fields' => Array (
								'Combination'	=>	Array ('title' => 'la_col_Combination', 'data_block' => 'grid_combination_td', 'filter_block' => 'grid_empty_filter'),
								'SKU'			=>	Array ('filter_block' => 'grid_like_filter'),
								'QtyInStock'	=>	Array ('filter_block' => 'grid_range_filter'),
								'QtyReserved'	=>	Array ('filter_block' => 'grid_range_filter'),
								'QtyBackOrdered' =>	Array ('filter_block' => 'grid_range_filter'),
								'QtyOnOrder'	=>	Array ('filter_block' => 'grid_range_filter'),
							),
						),

						'Radio' => Array (
							'Selector' => 'radio',
							'Icons' => Array (
								'default' => 'icon16_item.png',
								'module' => 'core',
							),
							'Fields' => Array (
								'Combination' => Array ( 'title' => 'la_col_Combination', 'data_block' => 'grid_combination_td', 'filter_block' => 'grid_empty_filter'),
								'FinalPrice' => Array ( 'title' => 'column:la_fld_Price', 'data_block' => 'grid_data_td', 'currency' => 'primary', 'filter_block' => 'grid_float_range_filter'),
//								'Weight' => Array ('data_block' => 'weight_td', 'filter_block' => 'grid_float_range_filter'),
							),
						),
					),

		);