<?php
/**
* @version	$Id: addresses_tag_processor.php 14257 2011-03-16 21:41:19Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/
	defined('FULL_PATH') or die('restricted access!');

	class AddressesTagProcessor extends kDBTagProcessor {

		function ListAddresses($params) {
			$ret = $this->PrintList2($params);

			if (!$ret){
				$block_params = array('name' => $params['empty_myaddresses_render_as']);
				$ret = $this->Application->ParseBlock($block_params);
			}

			return $ret;
		}

		/**
		 * Print location using only filled in fields
		 *
		 * @param Array $params
		 * @access public
		 */
		function PrintLocation($params)
		{
			$object =& $this->Application->recallObject($this->getPrefixSpecial(),$this->Prefix, $params);

			$fields = Array('City','State','Zip','Country');

			$ret = '';
			foreach($fields as $field)
			{
				$value = $object->GetField($field);
				if ($field == 'Country' && $value) {
					$ret .= '<br/>';
				}
				if ($value) {
					$ret .= $value.', ';
				}
			}
			return rtrim($ret,', ');
		}

		function EditLink($params)
		{
			$tag_processor =& $this->Application->recallTagProcessor('m');
			$params['pass']	= 'm,addr';
			return $tag_processor->Link($params);
		}

		function DeleteLink($params)
		{
			$params['addr_event'] = 'OnDelete';
			return $this->EditLink($params);
		}

		function NewLink($params)
		{
			$params['addr_event'] = 'OnNew';
			return $this->EditLink($params);
		}

		function IsProfileAddress($params)
		{
			$object =& $this->getObject($params);
			return $object->GetDBField('IsProfileAddress');
		}

		function BuildListSpecial($params)
		{
			if ($this->Special != '') {
				return $this->Special;
			}

			$list_unique_key = $this->getUniqueListKey($params);
			if ($list_unique_key == '') {
				return parent::BuildListSpecial($params);
			}

			return crc32($list_unique_key);
		}
	}