<?php
/**
* @version	$Id: coupons_event_handler.php 14257 2011-03-16 21:41:19Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class CouponsEventHandler extends kDBEventHandler {

	/**
	 * Allows to override standart permission mapping
	 *
	 */
	function mapPermissions()
	{
		parent::mapPermissions();
		$permissions = Array(
			'OnItemBuild' => Array('self' => true),
			'OnApplyClone' => Array('self' => 'add'),
			'OnPrepareClone' => Array('self' => 'view'),
		);

		$this->permMapping = array_merge($this->permMapping, $permissions);
	}

	/**
	 * Prepares coupon cloning
	 *
	 * @param kEvent $event
	 */
	function OnPrepareClone(&$event)
	{
		$this->StoreSelectedIDs($event);

		$event->CallSubEvent('OnNew');

		$object =& $event->getObject();
		/* @var $object kDBItem */

		$this->setCloningRequired($object);
		$clone_count = $this->Application->RecallVar('CoupLastCloneCount');

		if ( is_numeric($clone_count) && $clone_count > 0 ) {
			$object->SetDBField('CouponCount', $clone_count);
		}

		$expire_days = $this->Application->ConfigValue('Comm_DefaultCouponDuration');
		$default_expiration = strtotime('+' . $expire_days . ' days');

		$object->SetDBField('DefaultExpiration_date', $default_expiration);
		$object->SetDBField('DefaultExpiration_time', $default_expiration);
	}

	
	function OnBeforeClone(&$event)
	{
		parent::OnBeforeClone($event);
		
		$object =& $event->getObject();
		/* @var $object kDBItem */
		
		$this->SetNewCode($object);
		
		$object->SetDBField('LastUsedBy', NULL);
		$object->SetDBField('LastUsedOn', NULL);
		$object->SetDBField('NumberOfUses', NULL);
		
		$expiration = $this->Application->GetVar('clone_coupon_expiration');
		$object->SetDBField('Expiration_date', $expiration);
		$object->SetDBField('Expiration_time', $expiration);
	}
	
	function OnApplyClone(&$event)
	{	
		if ($this->Application->CheckPermission('SYSTEM_ACCESS.READONLY', 1)) {
			$event->status = erFAIL;
			return;
		}
		
		$object =& $event->getObject( Array ('skip_autoload' => true) );
		/* @var $object kDBItem */

		$this->setCloningRequired($object);

		$items_info = $this->Application->GetVar( $event->getPrefixSpecial(true) );
		list($id, $field_values) = each($items_info);
		$object->SetFieldsFromHash($field_values);
		$object->setID($id);

		if ( !$object->Validate() ) {
			$event->status = erFAIL;
			return ;
		}
		
		$temp =& $this->Application->recallObject($event->getPrefixSpecial().'_TempHandler', 'kTempTablesHandler');
		/* @var $temp kTempTablesHandler */
		
		$original_coupon_ids = $this->getSelectedIDs($event, true);
		$clone_count = $object->GetDBField('CouponCount');
		$this->Application->StoreVar('CoupLastCloneCount', $clone_count);		
		$this->Application->SetVar('clone_coupon_expiration', $object->GetDBField('DefaultExpiration'));
		
		for ($i = 0; $i < $clone_count; $i++) {
			$temp->CloneItems($event->Prefix, $event->Special, $original_coupon_ids);
		}

		$this->finalizePopup($event);
	}

	function setCloningRequired(&$object)
	{
		$this->RemoveRequiredFields($object);
		$object->setRequired('CouponCount');
		$object->setRequired('DefaultExpiration');
	}

	function SetNewCode(&$item)
	{
		do{
			$new_code = $this->RandomCouponCode(10);
			$exists = $this->Conn->GetOne('SELECT COUNT(*) FROM '.TABLE_PREFIX.'ProductsCoupons WHERE Code='.$this->Conn->qstr($new_code));
			if ($exists){
				$new_code = false;
			}
		} while (!$new_code);

		$item->SetDBField('Code', $new_code);
	}

	function RandomCouponCode($size)
	{
		$rand_code = "";
		for ($i=0; $i<10; $i++){
			$is_letter = rand(0,1);
			if ($is_letter){
				$rand_char = chr(rand(65,90));
			}else{
				$rand_char = rand(0,9);
			}
			$rand_code .= $rand_char;
		}
		return $rand_code;
	}

	/**
	 * Enter description here...
	 *
	 * @param kEvent $event
	 */
	function OnApplyCoupon(&$event)
	{
		$code = $this->Application->GetVar('coupon_code');
		if ($code == '') {
			return ;
		}

		$object =& $event->getObject(Array('skip_autoload' => true));
		$object->Load($code, 'Code');

		if (!$object->isLoaded()) {
			$event->status = erFAIL;
			$this->Application->SetVar('set_checkout_error', 4);
			$event->redirect = false; // check!!!
			return ;
		}
//		$object->IDField = $this->Application->getUnitOption($event->Prefix, 'IDField');
//		$object->ID = $object->GetDBField( $object->IDField );

		$expire_date = $object->GetDBField('Expiration');
		$number_of_use = $object->GetDBField('NumberOfUses');
		if(	$object->GetDBField('Status') != 1 || ($expire_date && $expire_date < adodb_mktime()) ||
			(isset($number_of_use) && $number_of_use <= 0))
		{
			$event->status = erFAIL;
			$this->Application->SetVar('set_checkout_error', 5);
			$event->redirect->false;
			return ;
		}

		$last_used = adodb_mktime();
		$object->SetDBField('LastUsedBy', $this->Application->RecallVar('user_id'));
		$object->SetDBField('LastUsedOn_date', $last_used);
		$object->SetDBField('LastUsedOn_time', $last_used);
		if(isset($number_of_use))
		{
			$object->SetDBField('NumberOfUses', $number_of_use - 1);
			if($number_of_use == 1)
			{
				$object->SetDBField('Status', 2);
			}
		}
		$object->Update();

		$this->Application->setUnitOption('ord', 'AutoLoad', true);
		$order =& $this->Application->recallObject('ord');
		$order->SetDBField('CouponId', $object->GetDBField('CouponId'));
		$order->Update();

		$this->Application->SetVar('set_checkout_error', 10);
	}

	/**
	 * Enter description here...
	 *
	 * @param kEvent $event
	 */
	function OnPreCreate(&$event){

		parent::OnPreCreate($event);

		$object = &$event->getObject();
		$exp_date = adodb_mktime();

		$default_duration = $this->Application->ConfigValue('Comm_DefaultCouponDuration');

		if ($default_duration && $default_duration>0){
			$exp_date += (int)$default_duration*86400;
		}
		$object->SetDBField('Expiration_date', $exp_date);
	}

	function OnBeforeItemUpdate(&$event)
	{
		$object =& $event->getObject();
		$object->SetDBField( 'Amount', abs($object->GetDBField('Amount')) );
	}

	function OnBeforeItemCreate(&$event)
	{
		$this->OnBeforeItemUpdate($event);
	}
}