<?php
/**
* @version	$Id: product_options_tag_processor.php 14257 2011-03-16 21:41:19Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class ProductOptionsTagProcessor extends kDBTagProcessor {

	function ShowOptions($params)
	{
		$object =& $this->Application->recallObject($this->getPrefixSpecial());

		$opt_helper =& $this->Application->recallObject('kProductOptionsHelper');

		$parsed = $opt_helper->ExplodeOptionValues($object->GetFieldValues());
		if (!$parsed) return;
		$values = $parsed['Values'];
		$conv_prices = $parsed['Prices'];
		$conv_price_types = $parsed['PriceTypes'];

		$options =& $this->GetOptions();

		$mode = $this->SelectParam($params, 'mode');
		$combination_prefix = $this->SelectParam($params, 'combination_prefix');
		$combination_field = $this->SelectParam($params, 'combination_field');
		if ($mode == 'selected') {
			$comb =& $this->Application->recallObject($combination_prefix);
			$options = unserialize($comb->GetDBField($combination_field));
		}

		$block_params['name'] = $params['render_as'];
		$block_params['selected'] = '';
		$block_params['pass_params'] = 1;

		$lang =& $this->Application->recallObject('lang.current');

		$o = '';
		$first_selected = false;
		foreach ($values as $option) {
//			list($val, $label) = explode('|', $option);
			$val = $option;
			if (getArrayValue($params, 'js')) {
				$block_params['id'] = addslashes($val);
				$block_params['value'] = htmlspecialchars($val);
			}
			else {
				$block_params['id'] = htmlspecialchars($val);
				$block_params['value'] = htmlspecialchars($val);
			}
			if ($conv_prices[$val]) {
				if ($conv_price_types[$val] == '$' && !getArrayValue($params, 'js') && !getArrayValue($params, 'no_currency')) {
					$iso = $this->GetISO($params['currency']);
					$value = sprintf("%.2f", $this->ConvertCurrency($conv_prices[$val], $iso));

					$value = $this->AddCurrencySymbol($lang->formatNumber($value, 2), $iso, true); // true to force sign
					$block_params['price'] = $value;
					$block_params['price_type'] = '';
					$block_params['sign'] = ''; //sign is included in the formatted value
				}
				else {
					$block_params['price'] = isset($params['js']) ? $conv_prices[$val] : $lang->formatNumber($conv_prices[$val],2);
					$block_params['price_type'] = $conv_price_types[$val];
					$block_params['sign'] = $conv_prices[$val] >= 0 ? '+' : '-';
				}
			}
			else {
				$block_params['price'] = '';
				$block_params['price_type'] = '';
				$block_params['sign'] = '';
			}

			/*if ($mode == 'selected') {
				$selected = $combination[$object->GetId()] == $val;
			}
			else*/
			$selected = false;
			if (!$options && isset($params['preselect_first']) && $params['preselect_first'] && !$first_selected) {
				$selected = true;
				$first_selected = true;
			}
			if (is_array($options)) {
				if ($object->GetDBField('OptionType') == 6) { // checkboxeS
					$selected = in_array(htmlspecialchars($val), $options[$object->GetId()]);
				}
				else { // radio buttons ?
					$selected = unhtmlentities($options[$object->GetId()]) == $val;
				}
			}
			if ($selected) {
				if ($mode == 'selected') {
					if ($object->GetDBField('OptionType') != 6) {
						$block_params['selected'] = ' selected="selected" ';
					}
					else {
						$block_params['selected'] = ' checked="checked" ';
					}
				}
				else {
					switch ($object->GetDBField('OptionType')) {
						case 1: //drop-down
							$block_params['selected'] = ' selected="selected" ';
							break;
						case 3: //radio
						case 6: //checkboxes
							$block_params['selected'] = ' checked="checked" ';
							break;
					}
				}
			}
			else {
				$block_params['selected'] = '';
			}

			$o .= $this->Application->ParseBlock($block_params);
		}

		return $o;
	}

	function &GetOptions()
	{
		$opt_data = $this->Application->GetVar('options');
		$options = getArrayValue($opt_data, $this->Application->GetVar('p_id'));
		if (!$options && $this->Application->GetVar('orditems_id')) {
			$ord_item =& $this->Application->recallObject('orditems.-opt', null, Array ('skip_autoload' => true));
			/* @var $ord_item kDBItem */

			$ord_item->Load($this->Application->GetVar('orditems_id'));
			$item_data = unserialize($ord_item->GetDBField('ItemData'));
			$options = getArrayValue($item_data, 'Options');
		}
		return $options;
	}

	function OptionData($params)
	{
		$object =& $this->getObject($params);
		$options =& $this->GetOptions();
		return getArrayValue($options, $object->GetId());
	}

	function ListOptions($params)
	{
		return $this->PrintList2($params);
	}
}