<?php
/**
* @version	$Id: payment_type_config.php 14257 2011-03-16 21:41:19Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config =	Array (
					'Prefix'			=>	'pt',
					'ItemClass'			=>	Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
					'ListClass'			=>	Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
					'EventHandlerClass'	=>	Array ('class' => 'PaymentTypeEventHandler', 'file' => 'payment_type_event_handler.php', 'build_event' => 'OnBuild'),
					'TagProcessorClass' =>	Array ('class' => 'PaymentTypeTagProcessor', 'file' => 'payment_type_tag_processor.php', 'build_event' => 'OnBuild'),
					'AutoLoad'			=>	true,

					'QueryString'		=>	Array (
												1 => 'id',
												2 => 'Page',
												3 => 'PerPage',
												4 => 'event',
												5 => 'mode',
											),
					'IDField'			=>	'PaymentTypeId',
					'StatusField'		=>	Array ('Status', 'IsPrimary'),
					'TableName'			=>	TABLE_PREFIX.'PaymentTypes',

					'TitlePresets'		=>	Array (
												'default'	=>	Array (	'new_status_labels'		=> Array ('pt' => '!la_title_AddingPaymentType!'),
																		'edit_status_labels'	=> Array ('pt' => '!la_title_EditingPaymentType!'),
																		'new_titlefield'		=> Array ('pt' => '!la_title_NewPaymentType!'),
																),

												'payment_type_list' =>Array (	'prefixes'				=> Array ('pt_List'),
																			'format'				=>	"!la_title_PaymentTypes!",
																),

												'payment_type_edit' =>Array (	'prefixes'				=> Array ('pt'),
																			'new_titlefield'		=> Array ('pt' => '!la_title_NewPaymentType!'),
																			'format'				=> "#pt_status# '#pt_titlefield#' - !la_title_General!",
																),

												'gateway'	=>	Array ('prefixes' => Array ('pt'), 'format' => "#pt_status# '#pt_titlefield#' - !la_title_Gateway!"),
												'group_list'	=>	Array ('prefixes' => Array ('pt'), 'format' => "#pt_status# '#pt_titlefield#' - !la_title_Groups!"),

												'payment_currencies_edit'	=>	Array ('prefixes' => Array ('pt'), 'format' => "#pt_status# '#pt_titlefield#' - !la_title_Currencies!"),
											),

					'EditTabPresets' => Array (
						'Default' => Array (
							'general' => Array ('title' => 'la_tab_General', 't' => 'in-commerce/payment_type/payment_type_edit', 'priority' => 1),
							'gateway' => Array ('title' => 'la_tab_Gateway', 't' => 'in-commerce/payment_type/payment_type_gateway', 'priority' => 2),
							'currencies' => Array ('title' => 'la_tab_Currencies', 't' => 'in-commerce/payment_type/payment_type_currencies', 'priority' => 3),
							'groups' => Array ('title' => 'la_tab_UserGroups', 't' => 'in-commerce/payment_type/payment_type_groups', 'priority' => 4),
						),
					),

					'PermSection'		=>	Array ('main' => 'in-commerce:payment_types'),

					'Sections'			=>	Array (
						'in-commerce:payment_types'	=>	Array (
							'parent'		=>	'in-commerce:setting_folder',
							'icon'			=>	'conf_payment_types',
							'label'			=>	'la_tab_PaymentTypes',
							'url'			=>	Array ('t' => 'in-commerce/payment_type/payment_type_list', 'pass' => 'm'),
							'permissions'	=>	Array ('view', 'add', 'edit', 'delete'),
							'priority'		=>	5,
							'type'			=>	stTREE,
						),
					),

					'TitleField'		=>	'Name',		// field, used in bluebar when editing existing item
					'SubItems' => Array ('gwfv', 'ptc'),

					'CalculatedFields'	=>	Array (
						''	=> Array (
							'Gateway' => TABLE_PREFIX . 'Gateways.Name',
						),
					),

					'ListSQLs'			=>	Array (	'' => '	SELECT %1$s.* %2$s
															FROM %1$s
															LEFT JOIN '.TABLE_PREFIX.'Gateways ON %1$s.GatewayId = '.TABLE_PREFIX.'Gateways.GatewayId',
																		), // key - special, value - list select sql
					'ItemSQLs'			=>	Array (	'' => 'SELECT * FROM %s',
																		),
					'ListSortings'	=> 	Array (
						'' => Array (
							'ForcedSorting' => Array ('Priority' => 'desc'),
							'Sorting' => Array ('Name' => 'asc'),
						)
					),

					'Fields'			=>	Array (
					    'PaymentTypeId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0,),
					    'Name' => Array ('type' => 'string', 'not_null' => 1, 'default' => '', 'required' =>true, 'max_len' => 100),
					    'Description' => Array ('type' => 'string', 'max_len' => 255, 'default' => null),
						'Instructions' => Array ('type' => 'string', 'formatter' => 'kFormatter', 'using_fck' => 1, 'default' => null),
						'AdminComments' => Array ('type' => 'string', 'formatter' => 'kFormatter', 'using_fck' => 1, 'default' => null),
					    'Status' => Array (
			            	'type' => 'int',
							'formatter' => 'kOptionsFormatter',
			            	'options' => Array ( 0 => 'la_Disabled', 1 => 'la_Active', ), 'use_phrases' => 1,
							'not_null' => 1, 'default' => 0,
						),
						'Priority' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
					    'IsPrimary' => Array (
			            	'type' => 'int',
							'formatter' => 'kOptionsFormatter',
			            	'options' => Array ( 0 => 'la_No', 1 => 'la_Yes', ), 'use_phrases' => 1,
							'not_null' => 1, 'default' => 0,
						),
					    'BuiltIn' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'use_phrases' => 1, 'options' => Array ( 1 => 'la_BuiltIn', 0 => 'la_UserDefined' ), 'default' => 0, 'not_null' => 1 ),
					    'GatewayId' => Array (
					    	'type' => 'int',
					    	'formatter' => 'kOptionsFormatter',
					    	'options_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'Gateways',
					    	'option_key_field' => 'GatewayId',
					    	'option_title_field' => 'Name',
					    	'default' => 1, 'not_null' => 1,
						),
					    'PlacedOrdersEdit' => Array (
			            	'type' => 'int',
							'formatter' => 'kOptionsFormatter',
			            	'options' => Array ( 0 => 'la_No', 1 => 'la_Yes', ), 'use_phrases' => 1,
							'not_null' => 1, 'default' => 0,
						),
					    'ProcessingFee' => Array ('type' => 'double', 'formatter' => 'kFormatter', 'format' => '%.02f', 'not_null' => 1, 'default' => '0.00'),
					    'PortalGroups' => Array ('type' => 'string', 'default' => null),
					),

 					'VirtualFields'	=> 	Array (
						'Gateway' => Array ('type' => 'string', 'default' => ''),
					),

					'Grids'	=> Array (
						'Default' => Array (
							'Icons' => Array (
								'default' => 'icon16_item.png',
								'0_0' => 'icon16_disabled.png',
								'0_1' => 'icon16_disabled.png',
								'1_0' => 'icon16_item.png',
								'1_1' => 'icon16_primary.png',
								'module' => 'core',
							),
							'Fields' => Array (
								'PaymentTypeId' => Array ( 'title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 50),
								'Name' => Array ( 'title' => 'la_col_PaymentTypeName', 'data_block' => 'payment_caption_td', 'filter_block' => 'grid_like_filter', 'width' => 200),
								'Description' => Array ( 'title' => 'la_col_Description', 'filter_block' => 'grid_like_filter', 'width' => 200),
								'BuiltIn' => Array ( 'title' => 'la_col_BuiltIn', 'filter_block' => 'grid_options_filter', 'width' => 100),
								'Status' => Array ( 'title' => 'la_col_Status', 'filter_block' => 'grid_options_filter', 'width' => 100),
							),
						),
					),
	);