<?php
/**
* @version	$Id: verisign_pflink.php 14257 2011-03-16 21:41:19Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

	require_once GW_CLASS_PATH.'/gw_base.php';

	$class_name = 'kVerisignPfLinkGW'; // for automatic installation

	class kVerisignPfLinkGW extends kGWBase
	{
		function InstallData()
		{
			$data = array(
				'Gateway' => Array('Name' => 'Verisign Payflow Link', 'ClassName' => 'kVerisignPfLinkGW', 'ClassFile' => 'verisign_pflink.php', 'RequireCCFields' => 0),
				'ConfigFields' => Array(
					'submit_url' => Array('Name' => 'Submit URL', 'Type' => 'text', 'ValueList' => '', 'Default' => 'https://payments.verisign.com/payflowlink'),
					'login' => Array('Name' => 'Login', 'Type' => 'text', 'ValueList' => '', 'Default' => ''),
					'partner' => Array('Name' => 'Partner', 'Type' => 'text', 'ValueList' => '', 'Default' => ''),
					'transaction_type' => Array('Name' => 'Transaction Type (S/A)', 'Type' => 'text', 'ValueList' => '', 'Default' => 'S'),
					'shipping_control' => Array('Name' => 'Shipping Control', 'Type' => 'select', 'ValueList' => '3=la_CreditDirect,4=la_CreditPreAuthorize', 'Default' => '3'),
				)
			);
			return $data;
		}

		/**
		 * Returns payment form submit url
		 *
		 * @param Array $gw_params gateway params from payment type config
		 * @return string
		 */
		function getFormAction($gw_params)
		{
			return $gw_params['submit_url'];
		}

		/**
		 * Processed input data and convets it to fields understandable by gateway
		 *
		 * @param Array $item_data
		 * @param Array $tag_params additional params for gateway passed through tag
		 * @param Array $gw_params gateway params from payment type config
		 * @return Array
		 */
		function getHiddenFields($item_data, $tag_params, $gw_params)
		{
			$params['LOGIN'] = $gw_params['login'];
			$params['PARTNER'] = $gw_params['partner'];
			$params['TYPE'] = $gw_params['transaction_type'];

			$params['AMOUNT'] = $item_data['TotalAmount'];


			$billing_email = $item_data['BillingEmail'];
			if (!$billing_email) {
				$billing_email = $this->Conn->GetOne('	SELECT Email FROM '.$this->Application->getUnitOption('u', 'TableName').'
											WHERE PortalUserId = '.$this->Application->RecallVar('user_id'));
			}

			$params['NAME'] = $item_data['BillingTo'];
			$params['PHONE'] = $item_data['BillingPhone'];
			$params['ADDRESS'] = $item_data['BillingAddress1'] . ' ' . $item_data['BillingAddress2'];
			$params['CITY'] = $item_data['BillingCity'];
			$params['ZIP'] = $item_data['BillingZip'];
			$params['COUNTRY'] = $item_data['BillingCountry'];
			$params['EMAIL'] = $billing_email;

			$params['COMMENT1'] = '';

			$params['DESCRIPTION'] = 'Order #'.$item_data['OrderNumber'];

			$params['INVOICE'] = $item_data['OrderNumber'];

			$params['CUSTID'] = $item_data['PortalUserId'];
			$params['USER1'] = $item_data['OrderId'];
			$params['USER2'] = $this->Application->GetSID();

			return $params;
		}

		function processNotification($gw_params)
		{
			$result = $this->parseGWResponce($_POST);

			$session =& $this->Application->recallObject('Session');
			$session->SID = $_POST['USER2'];

			$order_id = $this->Conn->GetOne('SELECT OrderId FROM '.TABLE_PREFIX.'Orders WHERE OrderId = '.$_POST['USER1']);
			$this->Application->SetVar('ord_id', $order_id);
			$order =& $this->Application->recallObject('ord');
			$order->Load($order_id);

			define('ADMIN', 1);
			if (!$this->Application->GetVar('silent')) {
				if ($result['RESULT'] == '0') {
					$this->Application->Redirect('in-commerce/checkout/checkout_success', array('pass'=>'m', 'm_cat_id'=>0), '_FRONT_END_', 'index.php');
				}
				else {
					$this->Application->StoreVar('gw_error', $this->getErrorMsg());
					$this->Application->Redirect('in-commerce/checkout/billing', array('pass'=>'m', 'm_cat_id'=>0), '_FRONT_END_', 'index.php');
				}
			}

			return $result['RESULT'] == '0' ? 1 : 0;
		}

		function parseGWResponce($res)
		{
			$this->parsed_responce = $res;
			return $res;
		}

		function getGWResponce()
		{
			return serialize($this->parsed_responce);
		}

		function getErrorMsg()
		{
			$msg = $this->parsed_responce['RESPMSG'];
			if (!$msg) {
				if ($this->parsed_responce['RESULT'] != '0') {
					$msg = 'Transaction failed';
				}
			}
			return $msg;
		}
	}