<?php
/**
* @version	$Id: section_eh.php 13873 2010-08-28 20:34:54Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2010 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class InCommerceEventHandler extends kEventHandler {

		/**
		 * [HOOK] Creates site domain editing tab
		 *
		 * @param kEvent $event
		 */
		function OnModifySiteDomainConfig(&$event)
		{
			$edit_tab_presets = $this->Application->getUnitOption($event->MasterEvent->Prefix, 'EditTabPresets');
			$edit_tab_presets['Default']['in-commerce'] = Array (
				'title' => 'la_title_In-Commerce', 't' => 'in-commerce/site_domains/site_domain_edit', 'priority' => 2.1
			);
			$this->Application->setUnitOption($event->MasterEvent->Prefix, 'EditTabPresets', $edit_tab_presets);

			$title_presets = $this->Application->getUnitOption($event->MasterEvent->Prefix, 'TitlePresets');
			$title_presets['site_domain_edit_in_commerce'] = Array (
				'prefixes' => Array ('site-domain'), 'format' => "#site-domain_status# '#site-domain_titlefield#' - !la_title_In-Commerce!",
				'toolbar_buttons' => Array ('select', 'cancel', 'reset_edit', 'prev', 'next'),
			);
			$this->Application->setUnitOption($event->MasterEvent->Prefix, 'TitlePresets', $title_presets);

			$new_fields = Array (
				'BillingCountry' => Array (
					'type' => 'string', 'max_len' => 3,
					'formatter' => 'kOptionsFormatter',
					'options_sql' => '	SELECT IF(l%2$s_Name = "", l%3$s_Name, l%2$s_Name) AS Name, IsoCode
										FROM ' . TABLE_PREFIX . 'CountryStates
										WHERE Type = ' . DESTINATION_TYPE_COUNTRY . '
										ORDER BY Name',
					'option_key_field' => 'IsoCode', 'option_title_field' => 'Name',
					'not_null' => 1, 'default' => ''
				),
				'ShippingCountry' => Array (
					'type' => 'string', 'max_len' => 3,
					'formatter' => 'kOptionsFormatter',
					'options_sql' => '	SELECT IF(l%2$s_Name = "", l%3$s_Name, l%2$s_Name) AS Name, IsoCode
										FROM ' . TABLE_PREFIX . 'CountryStates
										WHERE Type = ' . DESTINATION_TYPE_COUNTRY . '
										ORDER BY Name',
					'option_key_field' => 'IsoCode', 'option_title_field' => 'Name',
					'not_null' => 1, 'default' => ''
				),
				'PrimaryCurrencyId' => Array (
					'type' => 'int',
					'formatter' => 'kOptionsFormatter', 'options_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'Currencies WHERE Status = 1 ORDER BY ISO', 'option_key_field' => 'CurrencyId', 'option_title_field' => 'Name', 'use_phrases' => 1,
					'not_null' => 1, 'default' => 0
				),
				'Currencies' => Array (
					'type' => 'string', 'max_len' => 255,
					'formatter' => 'kOptionsFormatter', 'options_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'Currencies WHERE Status = 1 ORDER BY ISO', 'option_key_field' => 'CurrencyId', 'option_title_field' => 'Name', 'use_phrases' => 1,
					'not_null' => 1, 'default' => ''
				),
				'PrimaryPaymentTypeId' => Array (
					'type' => 'int',
					'formatter' => 'kOptionsFormatter', 'options_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'PaymentTypes WHERE Status = 1 ORDER BY Name ASC', 'option_key_field' => 'PaymentTypeId', 'option_title_field' => 'Name',
					'not_null' => 1, 'default' => 0
				),
				'PaymentTypes' => Array (
					'type' => 'string', 'max_len' => 255,
					'formatter' => 'kOptionsFormatter', 'options_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'PaymentTypes WHERE Status = 1 ORDER BY Name ASC', 'option_key_field' => 'PaymentTypeId', 'option_title_field' => 'Name',
					'not_null' => 1, 'default' => ''
				),
			);

			$fields = $this->Application->getUnitOption($event->MasterEvent->Prefix, 'Fields');
			$this->Application->setUnitOption($event->MasterEvent->Prefix, 'Fields', array_merge_recursive2($fields, $new_fields));

			$new_columns = Array (
				'BillingCountry' => Array ('title' => 'la_col_BillingCountry', 'filter_block' => 'grid_options_filter', 'width' => 250, ),
				'ShippingCountry' => Array ('title' => 'la_col_ShippingCountry', 'filter_block' => 'grid_options_filter', 'width' => 250, ),
				'PrimaryCurrencyId' => Array ('title' => 'la_col_Currency', 'filter_block' => 'grid_options_filter', 'width' => 250, ),
				'PrimaryPaymentTypeId' => Array ('title' => 'la_col_PaymentType', 'filter_block' => 'grid_options_filter', 'width' => 250, ),
			);

			$grids = $this->Application->getUnitOption($event->MasterEvent->Prefix, 'Grids');
			$grids['Default']['Fields'] = array_merge_recursive2($grids['Default']['Fields'], $new_columns);
			$this->Application->setUnitOption($event->MasterEvent->Prefix, 'Grids', $grids);

			if (!$this->Application->isAdmin && is_object($this->Application->siteDomain)) {
				// re-configure object, because it's recalled before kUnitConfigReader::AfterConfigRead is called
				$this->Application->siteDomain->defineFields();
			}
		}

	}
